/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.decorator;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.OverlayIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.TeamImages;

public class IconCache {
    private Map<OverlayIcon, Image> cache = Collections.synchronizedMap(new HashMap());
    private Image unmanagedBaseEclipse = null;
    private Image shelveFileBaseImage = null;
    protected int openLocation;
    protected int syncLocation;
    protected int notSyncLocation;
    protected int unresolvedLocation;
    protected int lockLocation;
    protected int otherLocation;
    protected int projectLocation;
    protected int ignoredLocation;
    protected int localOnlyLocation;
    protected int streamAndSandboxLocation;
    protected int streamAndSandboxProjectLocation;
    protected boolean markUnmanaged;

    public IconCache() {
        this.clear();
    }

    public ImageDescriptor getActionDescriptor(FileAction action, boolean openedByOwner) {
        ImageDescriptor descriptor = null;
        if (action != null) {
            switch (action) {
                case ADD: 
                case MOVE_ADD: {
                    if (openedByOwner) {
                        descriptor = this.getAddImage();
                        break;
                    }
                    descriptor = this.getAddOtherImage();
                    break;
                }
                case BRANCH: {
                    if (openedByOwner) {
                        descriptor = this.getBranchImage();
                        break;
                    }
                    descriptor = this.getBranchOtherImage();
                    break;
                }
                case INTEGRATE: {
                    if (openedByOwner) {
                        descriptor = this.getIntegrateImage();
                        break;
                    }
                    descriptor = this.getIntegrateOtherImage();
                    break;
                }
                case DELETE: 
                case MOVE_DELETE: {
                    if (openedByOwner) {
                        descriptor = this.getDeleteImage();
                        break;
                    }
                    descriptor = this.getDeleteOtherImage();
                    break;
                }
            }
        }
        if (descriptor == null) {
            descriptor = openedByOwner ? this.getEditImage() : this.getEditOtherImage();
        }
        return descriptor;
    }

    public void dispose() {
        if (this.unmanagedBaseEclipse != null && !this.unmanagedBaseEclipse.isDisposed()) {
            this.unmanagedBaseEclipse.dispose();
        }
        if (this.shelveFileBaseImage != null && !this.shelveFileBaseImage.isDisposed()) {
            this.shelveFileBaseImage.dispose();
        }
        for (Image image : this.cache.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }

    public void clear() {
        this.cache.clear();
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.openLocation = store.getInt("pref_file_open_icon");
        this.notSyncLocation = store.getInt("pref_file_sync_icon");
        this.syncLocation = store.getInt("pref_file_sync2_icon");
        this.unresolvedLocation = store.getInt("pref_file_unresolved_icon");
        this.lockLocation = store.getInt("pref_file_lock_icon");
        this.otherLocation = store.getInt("pref_file_other_icon");
        this.markUnmanaged = store.getBoolean("pref_mark_unmanaged");
        this.projectLocation = store.getInt("pref_project_icon");
        this.ignoredLocation = store.getInt("pref_ignored_icon");
        this.localOnlyLocation = store.getInt("pref_local_only_icon");
        this.streamAndSandboxLocation = store.getInt("pref_stream_sandbox_icon");
        this.streamAndSandboxProjectLocation = store.getInt("pref_stream_sandbox_project_icon");
    }

    public Image getProjectImage(Image base, IProject project) {
        Image decorated = base;
        IP4Connection connection = P4ConnectionManager.getManager().getConnection(project, false);
        if (connection != null) {
            decorated = this.decorateProjectImageBasedonConnection(base, connection);
        }
        return decorated;
    }

    public Image decorateProjectImageBasedonConnection(Image base, IP4Connection connection) {
        Image decorated = base;
        if (connection != null) {
            Image image;
            OverlayIcon icon;
            ImageDescriptor[] descriptors = new ImageDescriptor[1];
            if (connection.isOffline()) {
                descriptors[0] = this.getProjectDecorationOffline();
            } else if (this.getProjectDecorationOnline() != null) {
                descriptors[0] = this.getProjectDecorationOnline();
            }
            if (descriptors[0] != null) {
                icon = new OverlayIcon(base, descriptors, new int[]{this.projectLocation});
                image = this.cache.get((Object)icon);
                if (image == null) {
                    image = icon.createImage();
                    this.cache.put(icon, image);
                }
                decorated = image;
            }
            descriptors = new ImageDescriptor[1];
            if (connection.isSandbox()) {
                descriptors[0] = this.getSandboxDecoration();
            } else if (!connection.isOffline() && connection.getClient() != null && !StringUtils.isEmpty((CharSequence)connection.getClient().getStream())) {
                descriptors[0] = this.getStreamDecoration();
            }
            if (descriptors[0] != null) {
                icon = new OverlayIcon(base, descriptors, new int[]{this.streamAndSandboxProjectLocation});
                image = this.cache.get((Object)icon);
                if (image == null) {
                    image = icon.createImage();
                    this.cache.put(icon, image);
                }
                decorated = image;
            }
        }
        return decorated;
    }

    public Image getIgnoredImage(Image base) {
        Image decorated = base;
        if (this.ignoredLocation > 0) {
            ImageDescriptor[] descriptors = new ImageDescriptor[]{this.getIgnoredDecoration()};
            OverlayIcon icon = new OverlayIcon(base, descriptors, new int[]{this.ignoredLocation});
            Image image = this.cache.get((Object)icon);
            if (image == null) {
                image = icon.createImage();
                this.cache.put(icon, image);
            }
            decorated = image;
        }
        return decorated;
    }

    public Image getImage(Image base, IP4PendingChangelist list) {
        if (list != null && (list.isShelved() || list.hasReview())) {
            OverlayIcon icon;
            Image image;
            Image decorated = base;
            ArrayList<ImageDescriptor> idList = new ArrayList<ImageDescriptor>();
            idList.add(this.getShelvedDecoration());
            if (list.hasReview()) {
                idList.add(this.getChangeListInReviewDecoration());
            }
            ImageDescriptor[] descriptors = idList.toArray(new ImageDescriptor[idList.size()]);
            int[] iconOlArray = new int[idList.size()];
            int size = iconOlArray.length;
            iconOlArray[0] = 1;
            if (list.hasReview()) {
                iconOlArray[1] = 8;
            }
            if ((image = this.cache.get((Object)(icon = new OverlayIcon(base, descriptors, iconOlArray)))) == null) {
                image = icon.createImage();
                this.cache.put(icon, image);
            }
            decorated = image;
            return decorated;
        }
        return base;
    }

    public Image getImage(Image base, IP4SubmittedChangelist list) {
        if (list != null && list.hasReview()) {
            OverlayIcon icon;
            Image image;
            Image decorated = base;
            ArrayList<ImageDescriptor> idList = new ArrayList<ImageDescriptor>();
            if (list.hasReview()) {
                idList.add(this.getChangeListInReviewDecoration());
            }
            ImageDescriptor[] descriptors = idList.toArray(new ImageDescriptor[idList.size()]);
            int[] iconOlArray = new int[idList.size()];
            if (list.hasReview() && iconOlArray.length > 0) {
                iconOlArray[0] = 8;
            }
            if ((image = this.cache.get((Object)(icon = new OverlayIcon(base, descriptors, iconOlArray)))) == null) {
                image = icon.createImage();
                this.cache.put(icon, image);
            }
            decorated = image;
            return decorated;
        }
        return base;
    }

    public Image getImage(Image base, IP4Connection conn) {
        if (conn != null) {
            Image decorated = base;
            OverlayIcon icon = null;
            if (conn.isSandbox()) {
                ImageDescriptor[] descriptors = new ImageDescriptor[]{this.getSandboxDecoration()};
                icon = new OverlayIcon(decorated, descriptors, new int[]{this.streamAndSandboxLocation});
                Image image = this.cache.get((Object)icon);
                if (image == null) {
                    image = icon.createImage();
                    this.cache.put(icon, image);
                }
                decorated = image;
            } else if (!conn.isOffline() && conn.getClient() != null && !StringUtils.isEmpty((CharSequence)conn.getClient().getStream())) {
                ImageDescriptor[] descriptors = new ImageDescriptor[]{this.getStreamDecoration()};
                icon = new OverlayIcon(decorated, descriptors, new int[]{this.streamAndSandboxLocation});
                Image image = this.cache.get((Object)icon);
                if (image == null) {
                    image = icon.createImage();
                    this.cache.put(icon, image);
                }
                decorated = image;
            }
            return decorated;
        }
        return base;
    }

    public Image getImage(IP4ShelveFile file) {
        IP4File p4File;
        Image image = null;
        if (file != null && (p4File = file.getFile()) != null && p4File.getAction() != null) {
            OverlayIcon icon;
            ImageDescriptor descriptor = null;
            switch (p4File.getAction()) {
                case ADD: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/add.png");
                    break;
                }
                case MOVE_ADD: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/moveadd.png");
                    break;
                }
                case BRANCH: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/branch.png");
                    break;
                }
                case INTEGRATE: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/integrate.png");
                    break;
                }
                case DELETE: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/delete.png");
                    break;
                }
                case MOVE_DELETE: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/movedelete.png");
                    break;
                }
                case EDIT: {
                    descriptor = PerforceUIPlugin.getDescriptor("views/shelved/edit.png");
                    break;
                }
            }
            if (descriptor != null && (image = this.cache.get((Object)(icon = new OverlayIcon(this.getShelveFileBaseImage(), new ImageDescriptor[]{descriptor}, new int[]{1})))) == null) {
                image = icon.createImage();
                this.cache.put(icon, image);
            }
        }
        return image;
    }

    public Image getImage(Image base, IP4SubmittedFile file) {
        return base;
    }

    public Image getImage(Image base, IP4File file, boolean managedFile, boolean ignored) {
        if (file != null) {
            OverlayIcon icon;
            if (!managedFile && this.markUnmanaged) {
                base = this.getUnmanagedBaseEclipse();
            }
            if ((icon = this.getOtherFileIcon(base, file, ignored)) != null) {
                Image image = this.cache.get((Object)icon);
                if (image == null) {
                    image = icon.createImage();
                    this.cache.put(icon, image);
                }
                return image;
            }
        }
        return base;
    }

    public Image getImage(Image base, boolean managedFile) {
        if (this.markUnmanaged && !managedFile) {
            return this.getUnmanagedBaseEclipse();
        }
        return base;
    }

    private FileAction getAction(String action) {
        FileAction fileAction = null;
        try {
            fileAction = FileAction.fromString((String)action);
        }
        catch (Throwable e) {
            fileAction = null;
        }
        return fileAction;
    }

    private OverlayIcon getOtherFileIcon(Image base, IP4File p4File, boolean ignored) {
        ArrayList<ImageDescriptor> overlays = new ArrayList<ImageDescriptor>();
        int[] locations = new int[6];
        if (this.ignoredLocation > 0 && ignored) {
            overlays.add(this.getIgnoredDecoration());
            locations[overlays.size() - 1] = this.ignoredLocation;
        }
        if (p4File.getP4JFile() != null) {
            if (this.openLocation > 0 && p4File.isOpened() && p4File.openedByOwner()) {
                overlays.add(this.getActionDescriptor(p4File.getAction(), true));
                locations[overlays.size() - 1] = this.openLocation;
            }
            if (this.otherLocation > 0) {
                if (p4File.openedElsewhere()) {
                    List actions = p4File.getOtherActions();
                    if (actions.size() > 0) {
                        String action = (String)actions.get(0);
                        overlays.add(this.getActionDescriptor(this.getAction(action), false));
                        locations[overlays.size() - 1] = this.otherLocation;
                    }
                } else if (p4File.isOpened() && p4File.openedByOtherOwner()) {
                    overlays.add(this.getActionDescriptor(p4File.getAction(), false));
                    locations[overlays.size() - 1] = this.otherLocation;
                }
            }
            if (!(this.syncLocation <= 0 && this.notSyncLocation <= 0 || p4File.getHaveRevision() <= 0 && p4File.getHeadAction() == FileAction.DELETE || p4File.getHeadRevision() <= 0 || p4File.getClientPath() == null)) {
                if (p4File.isSynced()) {
                    if (this.syncLocation > 0) {
                        overlays.add(this.getSyncImage());
                        locations[overlays.size() - 1] = this.syncLocation;
                    }
                } else if (this.notSyncLocation > 0) {
                    overlays.add(this.getNotsyncImage());
                    locations[overlays.size() - 1] = this.notSyncLocation;
                }
            }
            if (this.lockLocation > 0 && p4File.isLocked()) {
                overlays.add(this.getLockImage());
                locations[overlays.size() - 1] = this.lockLocation;
            }
            if (this.unresolvedLocation > 0 && p4File.isUnresolved()) {
                overlays.add(this.getUnresolveImage());
                locations[overlays.size() - 1] = this.unresolvedLocation;
            }
        } else if (!ignored && this.localOnlyLocation > 0) {
            overlays.add(this.getLocalOnlyDecoration());
            locations[overlays.size() - 1] = this.localOnlyLocation;
        }
        OverlayIcon icon = null;
        if (!overlays.isEmpty()) {
            int[] locations2 = new int[overlays.size()];
            System.arraycopy(locations, 0, locations2, 0, locations2.length);
            ImageDescriptor[] overlays2 = overlays.toArray(new ImageDescriptor[overlays.size()]);
            icon = new OverlayIcon(base, overlays2, locations2);
        }
        return icon;
    }

    private ImageDescriptor createAndGetImageDesc(String key) {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        return plugin.getImageDescriptor(key);
    }

    private ImageDescriptor getEditImage() {
        return this.createAndGetImageDesc("decorations/edit.png");
    }

    private ImageDescriptor getAddImage() {
        return this.createAndGetImageDesc("decorations/add.png");
    }

    private ImageDescriptor getDeleteImage() {
        return this.createAndGetImageDesc("decorations/delete.png");
    }

    private ImageDescriptor getSyncImage() {
        return this.createAndGetImageDesc("decorations/sync.png");
    }

    private ImageDescriptor getNotsyncImage() {
        return this.createAndGetImageDesc("decorations/notsync.png");
    }

    private ImageDescriptor getLockImage() {
        return this.createAndGetImageDesc("decorations/lock.png");
    }

    private ImageDescriptor getUnresolveImage() {
        return this.createAndGetImageDesc("decorations/unresolved.png");
    }

    private ImageDescriptor getEditOtherImage() {
        return this.createAndGetImageDesc("decorations/edit_other.png");
    }

    private ImageDescriptor getAddOtherImage() {
        return this.createAndGetImageDesc("decorations/add_other.png");
    }

    private ImageDescriptor getDeleteOtherImage() {
        return this.createAndGetImageDesc("decorations/delete_other.png");
    }

    private ImageDescriptor getBranchImage() {
        return this.createAndGetImageDesc("decorations/branch.png");
    }

    private ImageDescriptor getBranchOtherImage() {
        return this.createAndGetImageDesc("decorations/branch_other.png");
    }

    private ImageDescriptor getIntegrateImage() {
        return this.createAndGetImageDesc("decorations/integrate.png");
    }

    private ImageDescriptor getIntegrateOtherImage() {
        return this.createAndGetImageDesc("decorations/integrate_other.png");
    }

    private ImageDescriptor getUnmanagedFileEclipseImage() {
        return this.createAndGetImageDesc("perforce/unmanaged_ec.png");
    }

    private Image getUnmanagedBaseEclipse() {
        if (this.unmanagedBaseEclipse == null) {
            this.unmanagedBaseEclipse = this.getUnmanagedFileEclipseImage().createImage();
        }
        return this.unmanagedBaseEclipse;
    }

    private Image getShelveFileBaseImage() {
        if (this.shelveFileBaseImage == null) {
            this.shelveFileBaseImage = PerforceUIPlugin.getPlugin().getImageDescriptor("views/shelved/file.png").createImage();
        }
        return this.shelveFileBaseImage;
    }

    private ImageDescriptor getProjectDecorationOnline() {
        return TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif");
    }

    private ImageDescriptor getProjectDecorationOffline() {
        return this.createAndGetImageDesc("decorations/connection_offline.png");
    }

    private ImageDescriptor getIgnoredDecoration() {
        return this.createAndGetImageDesc("decorations/ignored.png");
    }

    private ImageDescriptor getLocalOnlyDecoration() {
        return this.createAndGetImageDesc("decorations/local_only.png");
    }

    private ImageDescriptor getShelvedDecoration() {
        return this.createAndGetImageDesc("decorations/shelved.png");
    }

    private ImageDescriptor getChangeListInReviewDecoration() {
        return this.createAndGetImageDesc("decorations/changelist_in_review_badge.png");
    }

    private ImageDescriptor getSandboxDecoration() {
        return this.createAndGetImageDesc("decorations/sandbox_ovl.png");
    }

    private ImageDescriptor getStreamDecoration() {
        return this.createAndGetImageDesc("decorations/stream_ovl.png");
    }
}

