/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.AuthTicketsHelper;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ErrorHandler;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.BaseConnectionWizardPage;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.connection.mfa.MFAUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerWizardPage
extends BaseConnectionWizardPage {
    public static final int RECENT_SERVER_LENGTH = 10;
    public static final String SERVERS_SECTION = "Servers";
    public static final String RECENT_KEY = "recent";
    public static final String IGNORE_SSL_KEY = "inoressl";
    public static final String LEGACY_SECTION = "NewConnection";
    private Composite displayArea;
    private Group locationGroup;
    private Label previousServersLabel;
    private Combo previousServersCombo;
    private Label serverLabel;
    private Text serverText;
    private Label charsetLabel;
    private Combo charsetCombo;
    private Group authGroup;
    private Label userNameLabel;
    private Text userNameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Button ignoreSSLValidationButton;
    private String server = null;
    private String user = null;
    private String password = null;
    private boolean savePassword = false;
    private boolean ignoreSSLValidation = false;
    private String charset = null;
    private ModifyListener modify = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ServerWizardPage.this.validatePage();
        }
    };

    public ServerWizardPage(String pageName) {
        super(pageName);
        this.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/wizard.png"));
        this.setTitle(Messages.ServerWizardPage_AddConnectionTitle);
        this.setDescription(Messages.ServerWizardPage_AddConnectionMessage);
    }

    private void loadServerHistory() {
        IDialogSettings settings = PerforceUIPlugin.getPlugin().getDialogSettings();
        String[] serverHistory = null;
        if (settings != null) {
            IDialogSettings section = settings.getSection(SERVERS_SECTION);
            if (section != null) {
                serverHistory = section.getArray(RECENT_KEY);
            } else {
                String[] oldHistory;
                IDialogSettings oldSection = settings.getSection(LEGACY_SECTION);
                if (oldSection != null && (oldHistory = oldSection.getArray(RECENT_KEY)) != null) {
                    ArrayList<String> migratedHistory = new ArrayList<String>();
                    String[] stringArray = oldHistory;
                    int n = oldHistory.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String old = stringArray[n2];
                        ConnectionParameters params = new ConnectionParameters(old);
                        String port = params.getPort();
                        if (port != null && !migratedHistory.contains(port)) {
                            migratedHistory.add(port);
                        }
                        ++n2;
                    }
                    serverHistory = migratedHistory.toArray(new String[0]);
                }
            }
        }
        if (serverHistory != null && serverHistory.length > 0) {
            String[] stringArray = serverHistory;
            int n = serverHistory.length;
            int n3 = 0;
            while (n3 < n) {
                String entry = stringArray[n3];
                if (entry != null && entry.trim().length() > 0) {
                    this.previousServersCombo.add(entry);
                }
                ++n3;
            }
        }
    }

    public void saveServerHistory() {
        IDialogSettings settings;
        String currentServer = this.serverText.getText().trim();
        if (currentServer.isEmpty()) {
            return;
        }
        ArrayList<String> history = new ArrayList<String>(Arrays.asList(this.previousServersCombo.getItems()));
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(currentServer)) continue;
            iter.remove();
        }
        history.add(0, currentServer);
        if (history.size() > 10) {
            history.remove(10);
        }
        if ((settings = PerforceUIPlugin.getPlugin().getDialogSettings()) != null) {
            IDialogSettings section = settings.getSection(SERVERS_SECTION);
            if (section == null) {
                section = settings.addNewSection(SERVERS_SECTION);
            }
            section.put(RECENT_KEY, history.toArray(new String[0]));
            section.put(IGNORE_SSL_KEY, this.ignoreSSLValidation);
            PerforceUIPlugin.getPlugin().saveSettings();
        }
    }

    private void createCharsetArea(Composite parent) {
        this.charsetLabel = new Label(parent, 16384);
        this.charsetLabel.setText(Messages.ServerWizardPage_Charset);
        this.charsetCombo = new Combo(parent, 12);
        this.charsetCombo.setItems(P4UIUtils.getDisplayCharsets());
        this.charsetCombo.select(this.charsetCombo.indexOf("none"));
        this.charsetCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.charset = this.charsetCombo.getText();
        this.charsetCombo.addModifyListener(this.modify);
    }

    private void createLocationGroup(Composite parent) {
        this.locationGroup = new Group(parent, 0);
        this.locationGroup.setText(Messages.ServerWizardPage_Location);
        this.locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.locationGroup.setLayout((Layout)new GridLayout(2, false));
        this.previousServersLabel = new Label((Composite)this.locationGroup, 16384);
        this.previousServersLabel.setText(Messages.ServerWizardPage_RecentServers);
        this.previousServersCombo = new Combo((Composite)this.locationGroup, 12);
        this.previousServersCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.loadServerHistory();
        this.previousServersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerWizardPage.this.serverText.setText(ServerWizardPage.this.previousServersCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.serverLabel = new Label((Composite)this.locationGroup, 16384);
        this.serverLabel.setText(Messages.ServerWizardPage_Server);
        this.serverText = new Text((Composite)this.locationGroup, 2052);
        this.serverText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serverText.addModifyListener(this.modify);
        this.createCharsetArea((Composite)this.locationGroup);
    }

    private void createAuthGroup(Composite parent) {
        System.setProperty("IGNORE_SSL", Boolean.toString(this.ignoreSSLValidation));
        this.authGroup = new Group(parent, 0);
        this.authGroup.setText(Messages.ServerWizardPage_Authentication);
        this.authGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.authGroup.setLayout((Layout)new GridLayout(2, false));
        this.userNameLabel = new Label((Composite)this.authGroup, 0);
        this.userNameLabel.setText(Messages.ServerWizardPage_User);
        this.userNameText = new Text((Composite)this.authGroup, 2052);
        this.userNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.userNameText.addModifyListener(this.modify);
        this.passwordLabel = new Label((Composite)this.authGroup, 0);
        this.passwordLabel.setText(Messages.ServerWizardPage_Password);
        this.passwordText = new Text((Composite)this.authGroup, 0x400804);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.addModifyListener(this.modify);
        this.savePasswordButton = new Button((Composite)this.authGroup, 32);
        this.ignoreSSLValidationButton = new Button((Composite)this.authGroup, 32);
        this.ignoreSSLValidationButton.setText(Messages.ServerWizardPage_IgnoreSSLValidation);
        this.savePasswordButton.setText(Messages.ServerWizardPage_SavePassword);
        GridData spbData = new GridData(4, 4, true, false);
        spbData.horizontalSpan = 2;
        this.savePasswordButton.setLayoutData((Object)spbData);
        this.savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerWizardPage.this.savePassword = ServerWizardPage.this.savePasswordButton.getSelection();
                ServerWizardPage.this.validatePage();
            }
        });
        this.ignoreSSLValidationButton.setLayoutData((Object)spbData);
        this.ignoreSSLValidationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerWizardPage.this.ignoreSSLValidation = ServerWizardPage.this.ignoreSSLValidationButton.getSelection();
                System.setProperty("IGNORE_SSL", Boolean.toString(ServerWizardPage.this.ignoreSSLValidation));
                ServerWizardPage.this.validatePage();
            }
        });
    }

    public IWizardPage getNextPage() {
        boolean doit = this.preNextPage();
        if (!doit) {
            return super.getPreviousPage();
        }
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLocationGroup(this.displayArea);
        this.createAuthGroup(this.displayArea);
        this.setControl((Control)this.displayArea);
        this.setPageComplete(false);
    }

    private boolean preNextPage() {
        AtomicBoolean doit = new AtomicBoolean(false);
        if (this.getContainer() instanceof WizardDialog) {
            WizardDialog wd = (WizardDialog)this.getContainer();
            String[] messages = new String[1];
            try {
                doit.set(this.canDoNext(null));
            }
            catch (Exception e) {
                e.printStackTrace();
                doit.set(false);
            }
            if (!doit.get()) {
                this.setErrorMessage(messages[0]);
                this.getContainer().updateButtons();
            }
        }
        return doit.get();
    }

    public boolean canDoNext(IProgressMonitor monitor1) throws InvocationTargetException, InterruptedException {
        String[] messages = new String[1];
        boolean doit = false;
        IP4Connection conn = null;
        try {
            ConnectionParameters params = new ConnectionParameters();
            params.setPort(this.getPort());
            params.setClient(this.getClient());
            params.setUser(this.getUser());
            params.setCharset(this.getCharset());
            params.setPassword(this.getPassword());
            params.setSavePassword(this.savePassword());
            params.setIgnoreSSLValidation(this.ignoreSSLValidation);
            ErrorHandler handler = new ErrorHandler(){

                public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
                    boolean retry = P4ConnectionManager.getManager().displayException(connection, exception, false, false);
                    return retry;
                }
            };
            conn = P4Workspace.getWorkspace().tryToConnect(params, (IErrorHandler)handler);
            IServerInfo info = conn.getServer().getServerInfo();
            String ticket = null;
            try {
                ticket = AuthTicketsHelper.getTicketValue((String)ConnectionParameters.getTicketUser((ConnectionParameters)params, (IServer)conn.getServer()), (String)info.getServerAddress(), (String)P4Connection.getP4TicketsOSLocation());
            }
            catch (Throwable t) {
                PerforceProviderPlugin.logWarning((Throwable)t);
            }
            if (conn.getServerInfo().isSSOAuthRequired().booleanValue()) {
                boolean loginOK = conn.login("");
                return loginOK;
            }
            if (ticket != null && params.getPasswordNoNull().isEmpty()) {
                conn.getServer().setAuthTicket(ticket);
                doit = true;
            } else {
                try {
                    conn.getServer().login(params.getPassword());
                    doit = true;
                }
                catch (Throwable t) {
                    String[] options = new String[]{IDialogConstants.OK_LABEL};
                    MessageDialog errdlg = new MessageDialog(this.getShell(), Messages.ServerWizardPage_ErrorAuthenticatingUserTitle, null, Messages.ServerWizardPage_ErrorAuthenticatingUserMessage, 1, options, 0);
                    if (System.getProperty("isTestMode") != null) {
                        errdlg.setBlockOnOpen(false);
                    }
                    errdlg.open();
                    throw t;
                }
            }
            doit = MFAUtil.doMFA(this.getShell(), doit, conn);
            if (doit) {
                this.setWizardConnection(conn);
            }
        }
        catch (Throwable t) {
            messages[0] = t.getLocalizedMessage();
            PerforceProviderPlugin.logError((Throwable)t);
            if (conn != null) {
                conn.dispose();
            }
            doit = false;
        }
        return doit;
    }

    @Override
    public String getPort() {
        if (this.server != null && this.server.startsWith("rsh") && !this.server.endsWith(" --java")) {
            this.server = String.valueOf(this.server) + " --java";
        }
        return this.server;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isIgnoreSSLValidation() {
        return this.ignoreSSLValidation;
    }

    public void setPort(String port) {
        if (port != null) {
            this.serverText.setText(port);
        }
    }

    public void setUser(String user) {
        if (user != null) {
            this.userNameText.setText(user);
        }
    }

    public void setPassword(String pw) {
        if (pw != null) {
            this.passwordText.setText(pw);
        }
    }

    private void validatePage() {
        this.server = this.serverText.getText().trim();
        this.user = this.userNameText.getText().trim();
        this.charset = P4UIUtils.getP4Charset(this.charsetCombo.getText());
        this.password = this.passwordText.getText();
        if (this.password.isEmpty()) {
            this.password = null;
        }
        String message = null;
        if (!this.server.matches("(ssl:)?[^:]+:[1-9]\\d*") && !this.server.matches("((rsh)?(:{1})[^:]+[a-zA-Z:]?.*)")) {
            message = Messages.ServerWizardPage_MustSpecifyServer;
        } else if (this.user.isEmpty()) {
            message = Messages.ServerWizardPage_MustSpecifyUser;
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public boolean savePassword() {
        return this.savePassword;
    }

    public void setCharset(String charset) {
        if (charset != null) {
            this.charsetCombo.setText(P4UIUtils.getDisplayCharset(charset));
            this.validatePage();
        }
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.getErrorMessage() == null;
    }
}

