/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.StyledLabelProvider;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;

public class StyledChangelistLabelProvider
extends StyledLabelProvider {
    public StyledChangelistLabelProvider(ILabelProvider labelProvider) {
        super(labelProvider);
    }

    @Override
    public StyledString getStyledText(Object element) {
        StyledString styled = super.getStyledText(element);
        IP4Changelist list = (IP4Changelist)P4CoreUtils.convert((Object)element, IP4Changelist.class);
        if (list != null) {
            this.addCounter(list, styled);
            this.addQualifier(list, styled);
        }
        return styled;
    }

    protected void addCounter(IP4Changelist list, StyledString styled) {
        if (!list.needsRefresh()) {
            styled.append(MessageFormat.format(" ({0})", list.getFiles().length), StyledString.COUNTER_STYLER);
        }
    }

    protected void addQualifier(IP4Changelist list, StyledString styled) {
        if (list instanceof IP4PendingChangelist || list instanceof IP4SubmittedChangelist) {
            String user = list.getUserName();
            String client = list.getClientName();
            if (user != null && client != null) {
                styled.append(MessageFormat.format(" {0}@{1}", user, client), StyledString.QUALIFIER_STYLER);
            }
        }
    }
}

