/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.IChangelistEditorInput;
import com.perforce.team.ui.changelists.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class ChangelistEditorInput
extends PlatformObject
implements IChangelistEditorInput {
    private IP4Changelist changelist = null;

    public ChangelistEditorInput(IP4Changelist changelist) {
        this.changelist = changelist;
    }

    @Override
    public IP4Changelist getChangelist() {
        return this.changelist;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.changelist instanceof IP4SubmittedChangelist) {
            return PerforceUIPlugin.getDescriptor("perforce/submitted_editor.png");
        }
        if (this.changelist instanceof IP4ShelvedChangelist) {
            return PerforceUIPlugin.getDescriptor("perforce/shelved_editor.png");
        }
        return null;
    }

    public String getName() {
        return MessageFormat.format(Messages.ChangelistEditorInput_ChangeNumber, this.changelist.getId());
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChangelistEditorInput) {
            return this.changelist.equals(((ChangelistEditorInput)obj).getChangelist());
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IP4Resource.class == adapter || IP4Changelist.class == adapter || IP4SubmittedChangelist.class == adapter) {
            return this.changelist;
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.changelist.getId();
    }
}

