/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.dialogs.P4FormDialog;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BranchWidget {
    private Composite displayArea;
    private Text branchText;
    private Label accessLabel;
    private Text accessText;
    private Label updateLabel;
    private Text updateText;
    private Text ownerText;
    private Text descriptionText;
    private Button lockedButton;
    private Text viewText;

    public void addFormNameValidation(P4FormDialog dialog) {
        dialog.addFormNameValidation(this.branchText, "branch");
    }

    public BranchWidget(Composite parent) {
        this(parent, 5, 5, true);
    }

    public BranchWidget(Composite parent, int marginWidth, int marginHeight, boolean editable) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(4, false);
        daLayout.marginHeight = marginHeight;
        daLayout.marginWidth = marginWidth;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData multiTextData = new GridData(4, 4, true, true);
        multiTextData.horizontalSpan = 3;
        multiTextData.heightHint = 75;
        Label nameLabel = new Label(this.displayArea, 16384);
        nameLabel.setText(Messages.BranchWidget_Name);
        this.branchText = new Text(this.displayArea, 2052);
        this.branchText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.accessLabel = new Label(this.displayArea, 16384);
        this.accessLabel.setLayoutData((Object)new GridData());
        this.accessLabel.setText(Messages.BranchWidget_AccessTime);
        this.accessText = new Text(this.displayArea, 2052);
        this.accessText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateLabel = new Label(this.displayArea, 16384);
        this.updateLabel.setText(Messages.BranchWidget_UpdateTime);
        this.updateLabel.setLayoutData((Object)new GridData());
        this.updateText = new Text(this.displayArea, 2052);
        this.updateText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label ownerLabel = new Label(this.displayArea, 16384);
        ownerLabel.setText(Messages.BranchWidget_Owner);
        this.ownerText = new Text(this.displayArea, 2052);
        this.ownerText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label descriptionLabel = new Label(this.displayArea, 16384);
        descriptionLabel.setText(Messages.BranchWidget_Description);
        this.descriptionText = new Text(this.displayArea, 2114);
        this.descriptionText.setLayoutData((Object)multiTextData);
        Label optionsLabel = new Label(this.displayArea, 16384);
        optionsLabel.setText(Messages.BranchWidget_Options);
        this.lockedButton = new Button(this.displayArea, 32);
        this.lockedButton.setText(Messages.BranchWidget_Locked);
        GridData lbData = new GridData(1, 0x1000000, false, false);
        lbData.horizontalSpan = 3;
        this.lockedButton.setLayoutData((Object)lbData);
        Label viewLabel = new Label(this.displayArea, 16384);
        viewLabel.setText(Messages.BranchWidget_View);
        this.viewText = new Text(this.displayArea, 2114);
        this.viewText.setLayoutData((Object)multiTextData);
        this.setEditable(editable);
    }

    public void setEditable(boolean editable) {
        this.viewText.setEditable(editable);
        this.branchText.setEditable(editable);
        this.accessText.setEditable(editable);
        this.updateText.setEditable(editable);
        this.ownerText.setEditable(editable);
        this.descriptionText.setEditable(editable);
        this.lockedButton.setEnabled(editable);
    }

    public void setBranchNameEditable(boolean editable) {
        this.branchText.setEditable(editable);
    }

    public void setDatesEditable(boolean editable) {
        this.accessText.setEditable(editable);
        this.updateText.setEditable(editable);
    }

    public void setDatesVisible(boolean visible) {
        this.accessLabel.setVisible(visible);
        ((GridData)this.accessLabel.getLayoutData()).exclude = !visible;
        this.accessText.setVisible(visible);
        ((GridData)this.accessText.getLayoutData()).exclude = !visible;
        this.updateLabel.setVisible(visible);
        ((GridData)this.updateLabel.getLayoutData()).exclude = !visible;
        this.updateText.setVisible(visible);
        ((GridData)this.updateText.getLayoutData()).exclude = !visible;
    }

    public void update(IP4Branch branch) {
        this.clear();
        if (branch != null) {
            ViewMap view;
            String description;
            String name = branch.getName();
            if (name != null) {
                this.branchText.setText(name);
            }
            this.accessText.setText(P4UIUtils.formatLabelDate(branch.getAccessTime()));
            this.updateText.setText(P4UIUtils.formatLabelDate(branch.getUpdateTime()));
            String owner = branch.getOwner();
            if (owner != null) {
                this.ownerText.setText(owner);
            }
            if ((description = branch.getDescription()) != null) {
                this.descriptionText.setText(description);
            }
            if ((view = branch.getView()) != null) {
                Collections.sort(view.getEntryList(), new Comparator<IBranchMapping>(){

                    @Override
                    public int compare(IBranchMapping b1, IBranchMapping b2) {
                        return b1.getOrder() - b2.getOrder();
                    }
                });
                StringBuilder builder = new StringBuilder();
                for (IBranchMapping mapping : view) {
                    builder.append(mapping.toString(" ", true));
                    builder.append('\n');
                }
                this.viewText.setText(builder.toString());
            }
            this.lockedButton.setSelection(branch.isLocked());
        }
    }

    public String getBranchName() {
        return this.branchText.getText();
    }

    public void setBranchName(String name) {
        if (name != null) {
            this.branchText.setText(name);
        } else {
            this.branchText.setText("");
        }
    }

    public String getAccess() {
        return this.accessText.getText();
    }

    public String getUpdate() {
        return this.updateText.getText();
    }

    public String getView() {
        return this.viewText.getText();
    }

    public boolean isLocked() {
        return this.lockedButton.getSelection();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public String getOwner() {
        return this.ownerText.getText();
    }

    public void clear() {
        String empty = "";
        this.viewText.setText(empty);
        this.branchText.setText(empty);
        this.accessText.setText(empty);
        this.updateText.setText(empty);
        this.ownerText.setText(empty);
        this.descriptionText.setText(empty);
        this.lockedButton.setSelection(false);
    }

    public Composite getControl() {
        return this.displayArea;
    }
}

