/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.actions.stub;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.actions.stub.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.ide.IContributorResourceAdapter2;

public class Utils {
    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "com.perforce.team.ui", 1, Messages.TeamAction_internal, t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                PerforceProviderPlugin.log((IStatus)new Status(toShow.getSeverity(), "com.perforce.team.core", 0, message, t));
            }
        }
    }

    public static ResourceMapping getResourceMapping(Object o) {
        if (o instanceof ResourceMapping) {
            return (ResourceMapping)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            Object adapted = adaptable.getAdapter(ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
            adapted = adaptable.getAdapter(IContributorResourceAdapter.class);
            if (adapted instanceof IContributorResourceAdapter2) {
                IContributorResourceAdapter2 cra = (IContributorResourceAdapter2)adapted;
                return cra.getAdaptedResourceMapping(adaptable);
            }
        } else {
            Object adapted = Platform.getAdapterManager().getAdapter(o, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }
}

