/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.ui.LabelDecoratorAdapter;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.PerforceDecorator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PerforceLabelProvider
implements ITableLabelProvider,
ILabelProvider,
IFontProvider,
IColorProvider {
    protected DecoratingLabelProvider decorator = null;
    protected boolean decorateLocalFolders = false;
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

    public PerforceLabelProvider() {
        this(false);
    }

    public PerforceLabelProvider(boolean decorateResources) {
        this.decorator = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new PerforceDecorator(decorateResources){

            @Override
            public String getName() {
                return String.valueOf(PerforceLabelProvider.class.getSimpleName()) + "3";
            }
        });
    }

    public PerforceLabelProvider(boolean decorateResources, boolean decorateTextLabels, boolean decorateImageLabels) {
        this.decorator = decorateTextLabels && decorateImageLabels ? new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new PerforceDecorator(decorateResources){

            @Override
            public String getName() {
                return String.valueOf(PerforceLabelProvider.class.getSimpleName()) + "1";
            }
        }) : (decorateImageLabels ? new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new LabelDecoratorAdapter(decorateResources){
            private PerforceDecorator decorator;
            {
                this.decorator = new PerforceDecorator(bl){

                    @Override
                    public String getName() {
                        return String.valueOf(PerforceLabelProvider.class.getSimpleName()) + "2";
                    }
                };
            }

            @Override
            public Image decorateImage(Image image, Object element) {
                return this.decorator.decorateImage(image, element);
            }

            @Override
            public void dispose() {
                this.decorator.dispose();
                super.dispose();
            }
        }) : (decorateTextLabels ? new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new PerforceDecorator(decorateResources){

            @Override
            public Image decorateImage(Image image, Object element) {
                return image;
            }

            @Override
            public String getName() {
                return String.valueOf(PerforceLabelProvider.class.getSimpleName()) + "4";
            }
        }) : new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), (ILabelDecorator)new LabelDecoratorAdapter(){

            @Override
            public Image decorateImage(Image image, Object element) {
                return image;
            }
        })));
    }

    public void setDecorateLocalFolders(boolean decorate) {
        this.decorateLocalFolders = decorate;
    }

    private ImageDescriptor getConnectionImage(IP4Connection connection) {
        if (!connection.isOffline()) {
            return PerforceUIPlugin.getDescriptor("views/server_connection.png");
        }
        return PerforceUIPlugin.getDescriptor("views/server_connection_offline.png");
    }

    private ImageDescriptor getSubmittedFileImage(IP4SubmittedFile file) {
        ImageDescriptor desc = null;
        FileAction action = file.getAction();
        if (action != null) {
            switch (action) {
                case ADD: 
                case MOVE_ADD: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-add.png");
                    break;
                }
                case DELETE: 
                case MOVE_DELETE: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-delete.png");
                    break;
                }
                case EDIT: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-edit.png");
                    break;
                }
                case INTEGRATE: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-integrate.png");
                    break;
                }
                case BRANCH: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-branch.png");
                    break;
                }
                case PURGE: {
                    desc = PerforceUIPlugin.getDescriptor("views/submitted/revision-purge.png");
                    break;
                }
            }
        }
        return desc;
    }

    private String getShelvedChangelistText(IP4ShelvedChangelist list) {
        StringBuilder changeDescription = new StringBuilder(Messages.PerforceLabelProvider_ShelvedFiles);
        if (!list.needsRefresh()) {
            changeDescription.append(" (");
            changeDescription.append(list.members().length);
            changeDescription.append(')');
        }
        return changeDescription.toString();
    }

    private String getSubmittedFileText(IP4SubmittedFile file) {
        IFileSpec spec = file.getFileSpec();
        int rev = 0;
        if (spec != null) {
            rev = spec.getEndRevision();
        }
        return String.valueOf(file.getRemotePath()) + "#" + rev;
    }

    private String getShelvedFileText(IP4ShelveFile file) {
        int rev;
        IFileSpec spec = file.getFile().getP4JFile();
        if (spec instanceof IExtendedFileSpec && (rev = ((IExtendedFileSpec)spec).getHaveRev()) >= 0) {
            return String.valueOf(file.getRemotePath()) + "#" + rev;
        }
        return file.getRemotePath();
    }

    private String getChangelistText(IP4Changelist change) {
        StringBuilder changeDescription = new StringBuilder(Messages.PerforceLabelProvider_Change);
        int id = change.getId();
        if (id > 0) {
            changeDescription.append(id);
        }
        String description = change.getShortDescription();
        String user = change.getUserName();
        String client = change.getClientName();
        if (user != null && client != null) {
            changeDescription.append(" " + user + "@" + client);
        }
        if (description.length() > 0) {
            changeDescription.append(" { " + description + " }");
        }
        return changeDescription.toString();
    }

    private ImageDescriptor getDepotImage(P4Depot depot) {
        ImageDescriptor descriptor = null;
        IDepot.DepotType type = depot.getType();
        if (type == null) {
            type = IDepot.DepotType.LOCAL;
        }
        switch (type) {
            case REMOTE: {
                descriptor = PerforceUIPlugin.getDescriptor("perforce/depot_remote.png");
                break;
            }
            case SPEC: {
                descriptor = PerforceUIPlugin.getDescriptor("perforce/depot_spec.png");
                break;
            }
            case STREAM: {
                descriptor = PerforceUIPlugin.getDescriptor("perforce/depot_stream.png");
                break;
            }
            default: {
                descriptor = PerforceUIPlugin.getDescriptor("perforce/depot.png");
            }
        }
        return descriptor;
    }

    private ImageDescriptor getStreamImage(IP4Stream element) {
        ImageDescriptor descriptor = PerforceUIPlugin.getDescriptor("perforce/stream.png");
        return descriptor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element != null) {
            ImageDescriptor desc = null;
            Image image = null;
            if (element instanceof PerforceContentProvider.Loading) {
                desc = PerforceUIPlugin.getDescriptor("perforce/hourglass.png");
            } else {
                image = this.decorator.getImage(element);
                if (image == null) {
                    String text = null;
                    if (element instanceof IP4Job) {
                        desc = PerforceUIPlugin.getDescriptor("perforce/job.png");
                    } else if (element instanceof IP4Connection) {
                        desc = this.getConnectionImage((IP4Connection)element);
                    } else if (element instanceof P4Depot) {
                        desc = this.getDepotImage((P4Depot)element);
                    } else if (element instanceof IP4Stream) {
                        desc = this.getStreamImage((IP4Stream)element);
                    } else if (element instanceof IP4SubmittedChangelist) {
                        desc = PerforceUIPlugin.getDescriptor("perforce/submitted.png");
                    } else if (element instanceof IP4ShelvedChangelist) {
                        desc = PerforceUIPlugin.getDescriptor("views/shelve.png");
                    } else if (element instanceof IP4Changelist) {
                        desc = ((IP4Changelist)element).isReadOnly() ? PerforceUIPlugin.getDescriptor("perforce/their_pending.png") : PerforceUIPlugin.getDescriptor("perforce/your_pending.png");
                    } else if (element instanceof IP4Folder) {
                        IContainer[] locals;
                        if (this.decorateLocalFolders && desc == null && (locals = ((IP4Folder)element).getLocalContainers()) != null && locals.length > 0 && locals[0] instanceof IProject) {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                        }
                        if (desc == null) {
                            if (this.isStreamRoot(element)) {
                                desc = PerforceUIPlugin.getDescriptor("perforce/depot_stream_folder.png");
                            }
                            if (desc == null) {
                                desc = PerforceUIPlugin.getDescriptor("perforce/depot_folder.png");
                            }
                        }
                    } else if (element instanceof IP4Container) {
                        desc = PerforceUIPlugin.getDescriptor("perforce/depot_folder.png");
                    } else if (element instanceof IP4SubmittedFile) {
                        desc = this.getSubmittedFileImage((IP4SubmittedFile)element);
                    } else {
                        text = element.toString();
                        int lastSlash = text.lastIndexOf(47);
                        if (lastSlash != -1 && lastSlash + 1 < text.length()) {
                            text = text.substring(lastSlash + 1);
                        }
                        desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(text);
                    }
                }
            }
            if (desc != null) {
                image = this.images.get(desc);
                if (image == null) {
                    image = desc.createImage();
                    this.images.put(desc, image);
                }
                image = this.decorator.getLabelDecorator().decorateImage(image, element);
            }
            return image;
        }
        return null;
    }

    private boolean isStreamRoot(Object element) {
        if (!(element instanceof IP4Folder)) {
            return false;
        }
        IP4Folder folder = (IP4Folder)element;
        if (!(folder.getParent() instanceof P4Depot)) {
            return false;
        }
        P4Depot depot = (P4Depot)folder.getParent();
        if (depot.getType() != IDepot.DepotType.STREAM) {
            return false;
        }
        for (IStreamSummary stream : depot.getStreams()) {
            if (!stream.getStream().equals(folder.getRemotePath())) continue;
            return true;
        }
        return false;
    }

    protected String getDecoratedText(String text, Object element) {
        String decorated = this.decorator.getLabelDecorator().decorateText(text, element);
        if (decorated == null) {
            decorated = text;
        }
        return decorated;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element == null) {
            return null;
        }
        if (columnIndex == 0) {
            String text = null;
            if (element instanceof PerforceContentProvider.Loading) {
                text = Messages.PerforceLabelProvider_Loading;
            } else {
                if (element instanceof IP4ShelvedChangelist) {
                    return this.getShelvedChangelistText((IP4ShelvedChangelist)element);
                }
                if (element instanceof IP4Changelist && !((IP4Changelist)element).isDefault()) {
                    text = this.getChangelistText((IP4Changelist)element);
                    text = this.getDecoratedText(text, element);
                } else if (element instanceof IP4Job) {
                    text = ((IP4Job)element).getId();
                } else if (element instanceof IP4SubmittedFile) {
                    text = this.getSubmittedFileText((IP4SubmittedFile)element);
                } else if (element instanceof IP4ShelveFile) {
                    text = this.getShelvedFileText((IP4ShelveFile)element);
                } else if (element instanceof IP4Resource) {
                    text = ((IP4Resource)element).getName();
                    text = this.getDecoratedText(text, element);
                }
            }
            if (text == null) {
                text = this.decorator.getText(element);
            }
            if (text == null || text.length() == 0) {
                text = element.toString();
            }
            return text;
        }
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.decorator != null) {
            this.decorator.addListener(listener);
        }
    }

    public void dispose() {
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        for (Image img : this.images.values()) {
            if (img == null || img.isDisposed()) continue;
            img.dispose();
        }
        this.images.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.decorator != null) {
            this.decorator.removeListener(listener);
        }
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Font getFont(Object element) {
        IP4PendingChangelist list;
        if (element instanceof IP4PendingChangelist && (list = (IP4PendingChangelist)element).isActive()) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

