/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceStringMatcher;
import com.perforce.team.ui.PerforceUIPlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;

public class IgnoredFiles {
    private static final Path P4IGNORE = new Path(".p4ignore");
    private static final String IGNORE_WILDCARD = "*";
    private static final String IGNORE_CHARACTER = "?";
    private static final int CANCEL_IGNORE = 0;
    private static boolean updateDecorations = true;

    public static IFile[] filterAddFiles(IFile[] files) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            try {
                files[i].deleteMarkers("com.perforce.team.core.perforceadd", false, 0);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (!PerforceProviderPlugin.isIgnoredHint((IResource)files[i])) {
                list.add(files[i]);
            }
            ++i;
        }
        files = list.toArray(new IFile[list.size()]);
        return IgnoredFiles.removeIgnoredFiles(files);
    }

    public static IFile[] removeIgnoredFiles(IFile[] files) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (!IgnoredFiles.isIgnored((IResource)file)) {
                list.add(file);
            }
            ++n2;
        }
        return list.toArray(new IFile[list.size()]);
    }

    public static boolean isIgnored(IResource resource) {
        return IgnoredFiles.isIgnored(resource.getFullPath(), resource.getParent());
    }

    public static void addIgnore(IResource resource) {
        if (resource.getType() == 8) {
            return;
        }
        updateDecorations = true;
        IContainer container = resource.getParent();
        if (container == null || container.getType() == 8) {
            return;
        }
        final IFile ignore = container.getFile((IPath)P4IGNORE);
        if (ignore != null) {
            String path = String.valueOf(resource.getName()) + "\n";
            try {
                byte[] bytes = path.getBytes(P4CoreUtils.charsetForName((String)ignore.getCharset()));
                if (!ignore.exists()) {
                    ignore.create((InputStream)new ByteArrayInputStream(bytes), false, null);
                } else {
                    ignore.appendContents((InputStream)new ByteArrayInputStream(bytes), false, false, null);
                }
            }
            catch (Exception e) {
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        while (PerforceUIPlugin.getDisplay().readAndDispatch()) {
                        }
                        String msg = MessageFormat.format(Messages.IgnoredFiles_UnableToIgnoreMessage, ignore.getFullPath());
                        MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.IgnoredFiles_CantUpdate, null, msg, 1, new String[]{Messages.IgnoredFiles_OK}, 0);
                        errdlg.open();
                        updateDecorations = false;
                    }
                });
            }
        }
        if (updateDecorations) {
            IP4Resource p4Resource = P4Workspace.getWorkspace().getResource(resource);
            P4Event event = IgnoredFiles.createIgnoredEvent(p4Resource);
            P4Workspace.getWorkspace().notifyListeners(event);
        }
    }

    private static P4Event createIgnoredEvent(final IP4Resource resource) {
        P4Event event = new P4Event(P4Event.EventType.IGNORED, resource){

            public IResource[] getLocalResources() {
                if (resource instanceof IP4Container) {
                    IContainer[] locals;
                    final ArrayList<IContainer> localResources = new ArrayList<IContainer>();
                    IContainer[] iContainerArray = locals = ((IP4Folder)resource).getLocalContainers();
                    int n = locals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer localFolder = iContainerArray[n2];
                        if (localFolder != null) {
                            localResources.add(localFolder);
                            try {
                                localFolder.accept(new IResourceVisitor(){

                                    public boolean visit(IResource resource) throws CoreException {
                                        localResources.add(resource);
                                        return true;
                                    }
                                });
                            }
                            catch (CoreException e) {
                                PerforceProviderPlugin.logError((Throwable)e);
                            }
                        }
                        ++n2;
                    }
                    return localResources.toArray(new IResource[0]);
                }
                return super.getLocalResources();
            }
        };
        return event;
    }

    private static boolean isIgnored(IPath path, IContainer container) {
        boolean found = false;
        if (container == null || container.getType() == 8) {
            return false;
        }
        IFile ignore = container.getFile((IPath)P4IGNORE);
        if (ignore != null && ignore.exists()) {
            try {
                String name = path.lastSegment();
                boolean tryAgain = true;
                InputStream contents = null;
                while (contents == null && tryAgain && ignore.exists()) {
                    try {
                        contents = ignore.getContents();
                        tryAgain = false;
                    }
                    catch (CoreException cx) {
                        PerforceProviderPlugin.log((IStatus)new Status(1, "com.perforce.p4api", 1, "Refreshing .p4ignore file '" + ignore.getFullPath() + "'", null));
                        try {
                            ignore.refreshLocal(0, null);
                            tryAgain = true;
                        }
                        catch (CoreException e1) {
                            tryAgain = false;
                        }
                    }
                }
                if (contents != null) {
                    found = IgnoredFiles.matchNames(contents, name, ignore.getCharset());
                }
            }
            catch (Exception e) {
                PerforceProviderPlugin.log((IStatus)new Status(2, "com.perforce.p4api", 2, "Error reading .p4ignore file '" + ignore.getFullPath() + "'", null));
            }
        }
        if (!found) {
            IContainer parent = container.getParent();
            if (parent.getType() == 8) {
                return false;
            }
            return IgnoredFiles.isIgnored(path.removeLastSegments(1), parent);
        }
        return true;
    }

    private static boolean matchNames(InputStream contents, String name, String charset) throws IOException {
        boolean found = false;
        BufferedReader input = new BufferedReader(new InputStreamReader(contents, charset));
        if (input != null) {
            String line;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).contains(IGNORE_WILDCARD) || line.contains(IGNORE_CHARACTER)) {
                    PerforceStringMatcher matcher = new PerforceStringMatcher(line, false, false);
                    if (!matcher.match(name)) continue;
                    found = true;
                    break;
                }
                if (!line.equals(name)) continue;
                found = true;
                break;
            }
            input.close();
        }
        return found;
    }
}

