/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.EditAction;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileModificationValidatorManager
extends FileModificationValidator {
    private static final Status OK_STATUS = new Status(0, "com.perforce.team.core.PerforceTeamProvider", 0, "", null);

    private boolean editRefactorOn() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_refactor_support");
    }

    private boolean saveRefactorOn() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_refactor_save_support");
    }

    public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
        if (files != null && files.length > 0 && this.editRefactorOn()) {
            IP4Resource p4Resource = P4ConnectionManager.getManager().getResource((IResource)files[0]);
            IP4Connection connection = this.getConnection(p4Resource, files[0]);
            if (connection != null && !connection.isOffline()) {
                if (!this.editFile((ISelection)new StructuredSelection((Object[])files))) {
                    return Status.CANCEL_STATUS;
                }
            } else {
                Display currentDisplay = PerforceUIPlugin.getDisplay();
                int i = 0;
                while (i < files.length) {
                    final IFile file = files[i];
                    if (file.isReadOnly() && MessageDialog.openQuestion((Shell)currentDisplay.getActiveShell(), (String)Messages.FileModificationValidatorManager_confirm0, (String)MessageFormat.format(Messages.FileModificationValidatorManager_Overwrite, file.getName()))) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                                PerforceUIPlugin.log((IStatus)new Status(4, "com.perforce.team.ui", 4, exception.getMessage(), exception));
                            }

                            public void run() throws Exception {
                                ResourceAttributes attr = file.getResourceAttributes();
                                attr.setReadOnly(false);
                                file.setResourceAttributes(attr);
                            }
                        });
                    }
                    ++i;
                }
            }
            return OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IP4Connection getConnection(IP4Resource resource, IFile file) {
        if (resource != null) {
            return resource.getConnection();
        }
        if (file != null) {
            return P4Workspace.getWorkspace().getConnection(file.getProject());
        }
        return null;
    }

    private boolean editFile(ISelection selection) {
        EditAction action = new EditAction();
        action.setAsync(false);
        action.selectionChanged(null, selection);
        action.run(null);
        return !action.wasDialogCancelled();
    }

    public IStatus validateSave(IFile file) {
        IP4Resource p4Resource;
        IP4Connection connection;
        if (file != null && this.saveRefactorOn() && (connection = this.getConnection(p4Resource = P4ConnectionManager.getManager().getResource((IResource)file), file)) != null && !connection.isOffline() && p4Resource instanceof IP4File && ((IP4File)p4Resource).isRemote() && !((IP4File)p4Resource).isOpened()) {
            this.editFile((ISelection)new StructuredSelection((Object)file));
        }
        return OK_STATUS;
    }
}

