/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DecorationLabel {
    private Composite area;
    private String leftText;
    private String rightText;
    private Label left;
    private Label middle;
    private Label right;

    public DecorationLabel(Composite parent) {
        this(parent, "(", ")");
    }

    public DecorationLabel(Composite parent, String left, String right) {
        this.leftText = left;
        this.rightText = right;
        this.area = new Composite(parent, 0);
        GridLayout aLayout = new GridLayout(3, false);
        aLayout.marginWidth = 0;
        aLayout.marginHeight = 0;
        aLayout.verticalSpacing = 0;
        aLayout.horizontalSpacing = 0;
        this.area.setLayout((Layout)aLayout);
        this.left = new Label(this.area, 0);
        this.middle = new Label(this.area, 0);
        Color decorationColor = JFaceResources.getColorRegistry().get("DECORATIONS_COLOR");
        this.middle.setForeground(decorationColor);
        this.right = new Label(this.area, 0);
    }

    public void setForeground(Color color) {
        this.left.setForeground(color);
        this.right.setForeground(color);
    }

    public Composite getControl() {
        return this.area;
    }

    public void setText(String text) {
        if (text == null || text.length() == 0) {
            this.left.setText("");
            this.middle.setText("");
            this.right.setText("");
        } else {
            this.left.setText(this.leftText);
            this.middle.setText(text);
            this.right.setText(this.rightText);
        }
    }
}

