/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.ruby.timelapse;

import com.perforce.team.ui.ruby.timelapse.ASTFoldingProvider;
import com.perforce.team.ui.ruby.timelapse.RubyNodeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ruby.ast.FakeModuleDeclaration;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.text.IRubyPartitions;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class RubyFoldingProvider
extends ASTFoldingProvider {
    private boolean fInitCollapseRequires;

    public RubyFoldingProvider(ProjectionViewer viewer, ProjectionSupport support) {
        super(viewer, support);
    }

    @Override
    protected String getCommentPartition() {
        return "__ruby_comment";
    }

    @Override
    protected String getDocPartition() {
        return "__ruby_doc";
    }

    @Override
    protected String getPartition() {
        return "__ruby_partitioning";
    }

    @Override
    protected IPartitionTokenScanner getPartitionScanner() {
        return new RubyPartitionScanner();
    }

    @Override
    protected String[] getPartitionTypes() {
        return IRubyPartitions.RUBY_PARTITION_TYPES;
    }

    @Override
    protected String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    @Override
    protected ILog getLog() {
        return RubyUI.getDefault().getLog();
    }

    @Override
    protected ASTFoldingProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ModuleDeclaration decl = this.parse(code, offset);
        if (decl == null || decl instanceof FakeModuleDeclaration) {
            return null;
        }
        return this.buildCodeBlocks(decl, offset);
    }

    @Override
    protected boolean mayCollapse(ASTNode s, ASTFoldingProvider.FoldingStructureComputationContext ctx) {
        return super.mayCollapse(s, ctx) || s instanceof CallExpression;
    }

    @Override
    protected boolean initiallyCollapse(ASTNode s) {
        return super.initiallyCollapse(s) || s instanceof CallExpression && this.fInitCollapseRequires;
    }

    @Override
    protected void initializePreferences() {
        super.initializePreferences();
        this.fInitCollapseRequires = RubyUI.getDefault().getPreferenceStore().getBoolean("editor_folding_init_requires");
    }

    @Override
    protected ASTFoldingProvider.FoldingASTVisitor getFoldingVisitor(int offset) {
        return new RubyFoldingASTVisitor(offset);
    }

    @Override
    protected String getHandle(ASTFoldingProvider.ScriptProjectionAnnotation annotation) {
        return annotation != null ? RubyNodeModel.getRubyHandle(annotation.getElement()) : null;
    }

    protected static class RubyFoldingASTVisitor
    extends ASTFoldingProvider.FoldingASTVisitor {
        private final Stack<DeclarationContainer> declarations = new Stack();

        private DeclarationContainer peekDeclaration() {
            return this.declarations.peek();
        }

        private DeclarationContainer popDeclaration() {
            return this.declarations.pop();
        }

        private ModuleDeclarationContainer peekModuleDeclaration() {
            DeclarationContainer container;
            if (this.declarations.size() == 1 && (container = this.peekDeclaration()) instanceof ModuleDeclarationContainer) {
                return (ModuleDeclarationContainer)container;
            }
            return null;
        }

        protected RubyFoldingASTVisitor(int offset) {
            super(offset);
        }

        public boolean visit(ModuleDeclaration s) throws Exception {
            this.declarations.push(new ModuleDeclarationContainer());
            return this.visitGeneral((ASTNode)s);
        }

        @Override
        public boolean visit(TypeDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer child = new DeclarationContainer((Declaration)s, false);
            this.peekDeclaration().addChild(child);
            this.declarations.push(child);
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(TypeDeclaration s) throws Exception {
            this.declarations.pop();
            return super.endvisit(s);
        }

        @Override
        public boolean visit(MethodDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer child = new DeclarationContainer((Declaration)s, true);
            this.peekDeclaration().addChild(child);
            this.declarations.push(child);
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(MethodDeclaration s) throws Exception {
            this.declarations.pop();
            return super.endvisit(s);
        }

        private void processDeclarations(DeclarationContainer container, int level, boolean collapsible) {
            if (container.declaration != null && (collapsible || container.foldAlways)) {
                this.add((ASTNode)container.declaration);
            }
            boolean nextCollabsible = collapsible || level > 0 && container.countChildren() > 1;
            for (Object child : container.children) {
                if (child instanceof DeclarationContainer) {
                    this.processDeclarations((DeclarationContainer)child, level + 1, nextCollabsible);
                    continue;
                }
                if (!(child instanceof ASTFoldingProvider.CodeBlock)) continue;
                this.add((ASTFoldingProvider.CodeBlock)child);
            }
        }

        public boolean endvisit(ModuleDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer container = this.popDeclaration();
            this.processDeclarations(container, 0, false);
            return super.endvisit(s);
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (this.declarations.size() == 1) {
                if (node instanceof CallExpression) {
                    CallExpression call = (CallExpression)node;
                    if ("require".equals(call.getName())) {
                        ModuleDeclarationContainer container = this.peekModuleDeclaration();
                        if (container != null) {
                            container.requires.add(call);
                        }
                        return false;
                    }
                } else {
                    this.handleRequireStatements();
                }
            }
            return super.visitGeneral(node);
        }

        private void handleRequireStatements() {
            ModuleDeclarationContainer container = this.peekModuleDeclaration();
            if (container != null && !container.requires.isEmpty()) {
                CallExpression firstRequire = container.requires.get(0);
                CallExpression lastRequire = container.requires.get(container.requires.size() - 1);
                container.addChild(new ASTFoldingProvider.CodeBlock((ASTNode)firstRequire, (IRegion)new Region(firstRequire.sourceStart(), lastRequire.sourceEnd() - firstRequire.sourceStart())));
                container.requires.clear();
            }
        }

        static class DeclarationContainer {
            final List<Object> children = new ArrayList<Object>();
            final Declaration declaration;
            final boolean foldAlways;

            public DeclarationContainer(Declaration declaration, boolean foldAlways) {
                this.declaration = declaration;
                this.foldAlways = foldAlways;
            }

            void addChild(DeclarationContainer child) {
                this.children.add(child);
            }

            int countChildren() {
                return this.children.size();
            }

            public String toString() {
                return this.declaration != null ? this.declaration.toString() : "(TOP)";
            }
        }

        static class ModuleDeclarationContainer
        extends DeclarationContainer {
            final List<CallExpression> requires = new ArrayList<CallExpression>();

            public ModuleDeclarationContainer() {
                super(null, false);
            }

            public void addChild(ASTFoldingProvider.CodeBlock block) {
                this.children.add(block);
            }
        }
    }
}

