/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.mylyn.IP4JobConfiguration;
import com.perforce.team.core.mylyn.Messages;
import com.perforce.team.core.mylyn.P4JobConfigurationManager;
import com.perforce.team.core.mylyn.P4JobConnector;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

public class P4JobDataHandler
extends AbstractTaskDataHandler {
    public static final String INTERNAL_COMMENT_FIELD = "com.perforce.team.core.mylyn.internalComment";
    public static final int MAX_QUERY_COUNT = 1000;
    public static final String OR_SEPARATOR = "|";
    private P4JobConnector connector = null;
    private P4JobConfigurationManager provider = null;

    public P4JobDataHandler(P4JobConfigurationManager provider, P4JobConnector connector) {
        this.provider = provider;
        this.connector = connector;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        return this.getConfiguration(taskRepository).getAttributeMapper(taskRepository);
    }

    private String getFieldId(IJobSpec.IJobSpecField field, IP4JobConfiguration configuration, IJobSpec spec) {
        String id = null;
        switch (field.getCode()) {
            case 105: {
                id = "task.common.description";
                break;
            }
            case 102: {
                id = "task.common.status";
                break;
            }
            case 103: {
                id = "task.common.user.reporter";
                break;
            }
            default: {
                if ("date".equals(field.getDataType())) {
                    if (configuration.isCreatedDateField(field, spec)) {
                        id = "task.common.date.created";
                    } else if (configuration.isModifiedDateField(field, spec)) {
                        id = "task.common.date.modified";
                    }
                } else if (configuration.isPriorityField(field)) {
                    id = "task.common.priority";
                } else if (configuration.isKindField(field)) {
                    id = "task.common.kind";
                }
                if (id != null) break;
                id = Integer.toString(field.getCode());
            }
        }
        return id;
    }

    private String getFieldType(int code, String dataType, String name) {
        String type = "shortText";
        if (103 == code) {
            type = "person";
        } else if ("line".equals(dataType)) {
            type = "shortText";
        } else if ("select".equals(dataType)) {
            type = "singleSelect";
        } else if ("text".equals(dataType)) {
            type = "longRichText";
        } else if ("date".equals(dataType)) {
            type = "dateTime";
        } else if ("word".equals(dataType)) {
            type = "shortText";
        }
        return type;
    }

    private boolean isReadOnly(boolean isNew, int code, String fieldType) {
        if (!isNew && code == 101) {
            return true;
        }
        return "always".equals(fieldType) || "once".equals(fieldType);
    }

    private TaskAttribute createAttribute(TaskAttribute parent, String id, String label, String type, boolean readOnly) {
        TaskAttribute attr = new TaskAttribute(parent, id);
        TaskAttributeMetaData metadata = attr.getMetaData();
        metadata.setKind("task.common.kind.default");
        metadata.setLabel(label);
        metadata.setType(type);
        metadata.setReadOnly(readOnly);
        return attr;
    }

    private IP4JobConfiguration getConfiguration(TaskRepository repository) {
        return this.provider.getConfiguration(repository);
    }

    public void buildTask(TaskData data, TaskRepository repository, IP4Job job, boolean isNew) throws CoreException {
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        if (!isNew && connection.isOffline()) {
            throw new CoreException(P4MylynUtils.getConnectionOfflineStatus());
        }
        IJobSpec spec = connection.getJobSpec();
        if (spec == null) {
            throw new CoreException(P4MylynUtils.getErrorStatus(Messages.P4JobDataHandler_JobspecRetrievalFailed));
        }
        TaskAttribute root = data.getRoot();
        TaskAttribute key = root.createAttribute("task.common.key");
        key.getMetaData().setKind("task.common.kind.default");
        TaskAttribute summary = root.createAttribute("task.common.summary");
        summary.getMetaData().setLabel(Messages.P4JobDataHandler_SummaryLabel);
        if (job != null && !isNew) {
            key.setValue(job.getId());
            summary.setValue(job.getShortDescription());
        } else {
            summary.setValue(Messages.P4JobDataHandler_NewJob);
        }
        IP4JobConfiguration config = this.getConfiguration(repository);
        for (IJobSpec.IJobSpecField field : spec.getFields()) {
            String name = field.getName();
            if (!config.isCommentField(field)) {
                Date date;
                String dataType = field.getDataType();
                int code = field.getCode();
                String id = this.getFieldId(field, config, spec);
                String attributeType = this.getFieldType(code, dataType, name);
                boolean readOnly = this.isReadOnly(isNew, code, field.getFieldType());
                TaskAttribute attr = this.createAttribute(root, id, name, attributeType, readOnly);
                Object value = null;
                if (isNew) {
                    value = this.getJobDefaultValue(job, connection, field, spec.getFieldPreset(name));
                }
                if (value == null && job != null) {
                    value = job.getField(name);
                }
                if ("select".equals(dataType)) {
                    List values = spec.getFieldValues(name);
                    for (String fieldValue : values) {
                        attr.putOption(fieldValue, fieldValue);
                    }
                } else if ("date".equals(dataType) && value != null && (date = P4MylynUtils.parseDate(value.toString())) != null) {
                    value = date.getTime();
                }
                if (value == null) continue;
                attr.setValue(value.toString());
                continue;
            }
            if (job == null) continue;
            Object value = job.getField(name);
            if (value == null) {
                value = "";
            }
            String text = value.toString();
            root.createAttribute(INTERNAL_COMMENT_FIELD).setValue(text);
            config.buildCommentField(root, text, repository);
        }
        config.setCompletionDate(root);
    }

    public void buildJobTask(TaskData data, TaskRepository repository, IP4Job job) throws CoreException {
        this.buildTask(data, repository, job, false);
    }

    private Object getJobDefaultValue(IP4Job template, IP4Connection connection, IJobSpec.IJobSpecField field, String preset) {
        Object value;
        boolean set = false;
        String defaultValue = null;
        if (template != null && (value = template.getField(field.getName())) != null) {
            defaultValue = value.toString();
            set = true;
        }
        if (!set && preset != null) {
            String type = field.getFieldType();
            if (!"optional".equals(type)) {
                if ("$blank".equals(preset)) {
                    defaultValue = IP4Job.BLANK_VALUE;
                } else if ("$user".equals(preset)) {
                    defaultValue = connection.getParameters().getUserNoNull();
                } else if (!"$now".equals(preset)) {
                    defaultValue = preset;
                }
            }
        } else if (101 == field.getCode()) {
            defaultValue = "new";
        }
        return defaultValue;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        data.setPartial(true);
        IP4Job template = connection.getJob("new");
        this.buildTask(data, repository, template, true);
        return true;
    }

    public boolean canGetMultiTaskData(TaskRepository taskRepository) {
        return true;
    }

    private String getQuery(String[] taskIds, int length, String idField) {
        StringBuilder query = new StringBuilder();
        query.append('(');
        String id = null;
        String separator = "";
        int i = 0;
        while (i < length) {
            id = taskIds[i];
            query.append(separator);
            separator = OR_SEPARATOR;
            query.append(idField);
            query.append('=');
            id = CoreUtil.decode((String)id);
            id = P4MylynUtils.escapeJobQueryValue(id);
            query.append(id);
            ++i;
        }
        query.append(')');
        return query.toString();
    }

    private IP4Job[] fetchJobs(String[] ids, int length, String idField, IP4Connection connection) {
        String query = this.getQuery(ids, length, idField);
        return connection.getJobs(null, length, query);
    }

    private void collectJobs(IP4Job[] jobs, TaskRepository repository, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        IP4Job[] iP4JobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Job job = iP4JobArray[n2];
            this.connector.getCache().add(job);
            TaskData data = this.generateTaskData(repository, job);
            monitor.worked(1);
            collector.accept(data);
            ++n2;
        }
    }

    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        if (taskIds == null || taskIds.isEmpty()) {
            return;
        }
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        if (connection.isOffline()) {
            throw new CoreException(P4MylynUtils.getConnectionOfflineStatus());
        }
        int taskCount = taskIds.size();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        monitor.beginTask(MessageFormat.format(Messages.P4JobConnector_FetchingJobs, connection.getParameters().getPortNoNull()), taskCount);
        try {
            IJobSpec spec = connection.getJobSpec();
            if (spec == null) {
                throw new CoreException(P4MylynUtils.getErrorStatus(Messages.P4JobDataHandler_JobspecRetrievalFailed));
            }
            String idField = null;
            for (IJobSpec.IJobSpecField field : spec.getFields()) {
                if (101 != field.getCode()) continue;
                idField = field.getName();
                break;
            }
            if (idField == null) {
                throw new CoreException(P4MylynUtils.getErrorStatus(Messages.P4JobDataHandler_JobIdFieldNotFound));
            }
            if (taskCount > 1) {
                if (taskCount <= 1000) {
                    IP4Job[] jobs = this.fetchJobs(taskIds.toArray(new String[taskCount]), taskCount, idField, connection);
                    this.collectJobs(jobs, repository, collector, monitor);
                } else {
                    String[] ids = new String[1000];
                    String[] all = taskIds.toArray(new String[taskCount]);
                    int read = 0;
                    int left = taskCount;
                    while (left > 0) {
                        int chunkSize = Math.min(left, 1000);
                        System.arraycopy(all, read, ids, 0, chunkSize);
                        left -= chunkSize;
                        read += chunkSize;
                        IP4Job[] jobs = this.fetchJobs(ids, chunkSize, idField, connection);
                        this.collectJobs(jobs, repository, collector, monitor);
                    }
                }
            } else {
                String id = CoreUtil.decode((String)taskIds.iterator().next());
                IP4Job job = connection.getJob(id);
                this.connector.getCache().add(job);
                TaskData data = this.generateTaskData(repository, job);
                collector.accept(data);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public TaskData generateTaskData(TaskRepository repository, String id) {
        TaskAttributeMapper mapper = this.getAttributeMapper(repository);
        TaskData data = new TaskData(mapper, this.connector.getConnectorKind(), repository.getUrl(), CoreUtil.encode((String)id));
        data.setPartial(true);
        return data;
    }

    public TaskData generateTaskData(TaskRepository repository, IP4Job job) throws CoreException {
        TaskAttributeMapper mapper = this.getAttributeMapper(repository);
        TaskData data = new TaskData(mapper, this.connector.getConnectorKind(), repository.getUrl(), CoreUtil.encode((String)job.getId()));
        data.setPartial(false);
        this.buildJobTask(data, repository, job);
        return data;
    }

    public String getTaskKey(TaskData data) {
        TaskAttribute key;
        String id = null;
        if (data != null && (key = data.getRoot().getAttribute("task.common.key")) != null) {
            id = key.getValue();
        }
        return id;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData data, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        String message;
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        if (connection.isOffline()) {
            throw new CoreException(P4MylynUtils.getConnectionOfflineStatus());
        }
        IJobSpec spec = connection.getJobSpec();
        if (spec == null) {
            throw new CoreException(P4MylynUtils.getErrorStatus(Messages.P4JobDataHandler_JobspecRetrievalFailed));
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        TaskAttribute newComment = data.getRoot().getAttribute("task.common.comment.new");
        IP4JobConfiguration config = this.getConfiguration(repository);
        TaskAttribute root = data.getRoot();
        for (IJobSpec.IJobSpecField field : spec.getFields()) {
            String id = this.getFieldId(field, config, spec);
            TaskAttribute attribute = root.getAttribute(id);
            if (attribute == null) continue;
            String value = null;
            String type = attribute.getMetaData().getType();
            if ("date".equals(type) || "dateTime".equals(type)) {
                try {
                    long time = Long.parseLong(attribute.getValue());
                    value = P4MylynUtils.formatToP4Date(new Date(time));
                }
                catch (NumberFormatException numberFormatException) {
                    value = attribute.getValue();
                }
            } else if (newComment != null && config.isCommentField(field)) {
                TaskAttribute internalComment = data.getRoot().getAttribute(INTERNAL_COMMENT_FIELD);
                String currentValue = "";
                if (internalComment != null) {
                    currentValue = internalComment.getValue();
                }
                value = config.generateCommentFieldValue(connection, newComment.getValue(), currentValue);
            } else {
                value = attribute.getValue();
            }
            fields.put(field.getName(), value);
        }
        if (data.isNew()) {
            try {
                IP4Job created = connection.createJob(fields);
                if (created != null) {
                    return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, created.getId());
                }
                throw new CoreException(P4MylynUtils.getErrorStatus(Messages.P4JobConnector_JobRetrievalFailed));
            }
            catch (P4JavaException e) {
                String message2 = e.getLocalizedMessage();
                if (message2 != null) {
                    message2 = message2.trim();
                }
                throw new CoreException(P4MylynUtils.getErrorStatus(message2, e));
            }
        }
        Job updatedJob = new Job(null, fields);
        try {
            IServer server = connection.getServer();
            if (server != null) {
                server.updateJob((IJob)updatedJob);
            }
        }
        catch (P4JavaException e) {
            message = e.getLocalizedMessage();
            if (message != null) {
                message = message.trim();
            }
            throw new CoreException(P4MylynUtils.getErrorStatus(message, e));
        }
        catch (P4JavaError e) {
            message = e.getLocalizedMessage();
            if (message != null) {
                message = message.trim();
            }
            throw new CoreException(P4MylynUtils.getErrorStatus(message, e));
        }
        return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, data.getTaskId());
    }
}

