/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.mylyn.IP4JobConfiguration;
import com.perforce.team.core.mylyn.P4JobAttributeMapper;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class P4DefaultJobConfiguration
implements IP4JobConfiguration {
    public static final String COMMENT_FIELD = "Comments";
    public static final String PRIORITY_FIELD = "Priority";
    public static final String CLOSED_STATUS_VALUE = "closed";
    public static final Pattern JOB_PATTERN = Pattern.compile("job\\d+");
    public static final String COMMENT_REGEX = "^(\\d\\d/\\d\\d/\\d\\d\\d\\d\\s*\\d\\d:\\d\\d:\\d\\d)\\s*\\-?\\s*(\\w+)\\s*:(.*)$";
    public static final Pattern COMMENT_PATTERN = Pattern.compile("^(\\d\\d/\\d\\d/\\d\\d\\d\\d\\s*\\d\\d:\\d\\d:\\d\\d)\\s*\\-?\\s*(\\w+)\\s*:(.*)$");

    @Override
    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        if (comment != null) {
            ArrayList<String> jobs = new ArrayList<String>();
            Matcher matcher = JOB_PATTERN.matcher(comment);
            while (matcher.find()) {
                jobs.add(matcher.group());
            }
            if (!jobs.isEmpty()) {
                return jobs.toArray(new String[jobs.size()]);
            }
        }
        return null;
    }

    @Override
    public boolean isCommentField(IJobSpec.IJobSpecField field) {
        if (field == null) {
            return false;
        }
        return COMMENT_FIELD.equals(field.getName());
    }

    @Override
    public boolean isModifiedDateField(IJobSpec.IJobSpecField field, IJobSpec spec) {
        if (field == null || spec == null) {
            return false;
        }
        return "date".equals(field.getDataType()) && "always".equals(field.getFieldType()) && "$now".equals(spec.getFieldPreset(field.getName()));
    }

    @Override
    public boolean isPriorityField(IJobSpec.IJobSpecField field) {
        if (field == null) {
            return false;
        }
        return PRIORITY_FIELD.equals(field.getName());
    }

    @Override
    public void setCompletionDate(TaskAttribute root) {
        TaskAttribute status;
        if (root != null && root.getAttribute("task.common.date.completed") == null && (status = root.getAttribute("task.common.status")) != null) {
            TaskAttribute mod;
            TaskAttribute completion = root.createAttribute("task.common.date.completed");
            if (CLOSED_STATUS_VALUE.equals(status.getValue()) && (mod = root.getAttribute("task.common.date.modified")) != null) {
                completion.setValue(mod.getValue());
            }
        }
    }

    @Override
    public void buildCommentField(TaskAttribute root, String value, TaskRepository repository) {
        StringTokenizer tokenizer = new StringTokenizer(value, "\r\n", false);
        TaskCommentMapper mapper = null;
        StringBuilder commentText = new StringBuilder();
        ArrayList<TaskCommentMapper> comments = new ArrayList<TaskCommentMapper>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            Matcher matcher = COMMENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                String startText;
                if (mapper != null) {
                    mapper.setText(commentText.toString());
                }
                commentText = new StringBuilder();
                mapper = new TaskCommentMapper();
                comments.add(mapper);
                mapper.setCreationDate(P4MylynUtils.parseCommentDate(matcher.group(1)));
                String person = matcher.group(2);
                if (person != null && person.length() > 0) {
                    mapper.setAuthor(repository.createPerson(person));
                }
                if ((startText = matcher.group(3)) == null || startText.length() <= 0) continue;
                commentText.append(startText);
                commentText.append('\n');
                continue;
            }
            if (commentText == null) continue;
            commentText.append(line);
            commentText.append('\n');
        }
        if (mapper != null && commentText != null) {
            mapper.setText(commentText.toString());
        }
        int count = comments.size();
        for (TaskCommentMapper comment : comments) {
            comment.setNumber(Integer.valueOf(count));
            TaskAttribute attribute = root.createAttribute("task.common.comment-" + count);
            comment.applyTo(attribute);
            --count;
        }
        TaskAttribute newComment = root.createMappedAttribute("task.common.comment.new");
        newComment.getMetaData().setKind("task.common.kind.default");
        newComment.getMetaData().setType("longRichText");
        newComment.setValue("");
    }

    @Override
    public String generateCommentFieldValue(IP4Connection connection, String newCommentValue, String currentCommentValue) {
        StringBuilder builder = new StringBuilder();
        String user = connection.getParameters().getUser();
        if (newCommentValue != null && newCommentValue.length() > 0) {
            builder.append(P4MylynUtils.formatCommentDate(new Date()));
            builder.append(' ');
            builder.append(user);
            builder.append(':');
            builder.append('\n');
            builder.append(newCommentValue);
            builder.append('\n');
        }
        if (currentCommentValue != null && currentCommentValue.length() > 0) {
            builder.append(currentCommentValue);
        }
        return builder.toString();
    }

    @Override
    public boolean isConfigurationFor(TaskRepository repository) {
        return true;
    }

    @Override
    public boolean isCreatedDateField(IJobSpec.IJobSpecField field, IJobSpec spec) {
        if (field == null || spec == null) {
            return false;
        }
        return "date".equals(field.getDataType()) && "once".equals(field.getFieldType()) && "$now".equals(spec.getFieldPreset(field.getName()));
    }

    @Override
    public boolean isKindField(IJobSpec.IJobSpecField field) {
        return false;
    }

    @Override
    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
    }

    @Override
    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        return new P4JobAttributeMapper(taskRepository);
    }
}

