/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mylyn.IP4Configuration;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public abstract class P4ConfigurationManager {
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ID_ATTRIBUTE = "id";
    private Map<TaskRepository, IP4Configuration> repositoryConfigs = null;
    protected IP4Configuration[] configs;
    private IP4Configuration defaultConfig;

    public P4ConfigurationManager(String extensionId) {
        TreeMap<String, IP4Configuration> allConfigs = new TreeMap<String, IP4Configuration>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (CONFIGURATION_ELEMENT.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String configClass = element.getAttribute(CLASS_ATTRIBUTE);
                if (configClass != null && id != null) {
                    try {
                        Object config = element.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (this.isValidConfiguration(config)) {
                            allConfigs.put(id, (IP4Configuration)config);
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            }
            ++n2;
        }
        this.configs = allConfigs.values().toArray(new IP4Configuration[allConfigs.size()]);
        this.defaultConfig = this.createDefault();
        this.repositoryConfigs = Collections.synchronizedMap(new WeakHashMap());
    }

    protected abstract IP4Configuration createDefault();

    protected boolean isValidConfiguration(Object config) {
        return config instanceof IP4Configuration;
    }

    protected IP4Configuration findConfiguration(TaskRepository repository) {
        IP4Configuration config = null;
        if (repository != null) {
            config = this.repositoryConfigs.get(repository);
            if (config == null) {
                IP4Configuration[] iP4ConfigurationArray = this.configs;
                int n = this.configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Configuration candidate = iP4ConfigurationArray[n2];
                    if (candidate.isConfigurationFor(repository)) {
                        config = candidate;
                        break;
                    }
                    ++n2;
                }
                if (config == null) {
                    config = this.defaultConfig;
                }
                this.repositoryConfigs.put(repository, config);
            }
        } else {
            config = this.defaultConfig;
        }
        return config;
    }
}

