/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model.factory;

import com.perforce.team.core.mergequest.model.factory.IBranchGraphElementFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BranchGraphElementFactory
implements IBranchGraphElementFactory {
    protected AtomicInteger counter = new AtomicInteger(-1);

    protected abstract String getPrefix();

    protected String generateId() {
        return String.valueOf(this.getPrefix()) + this.counter.incrementAndGet();
    }

    protected void setCounter(int value) {
        if (value > this.counter.get()) {
            this.counter.set(value);
        }
    }

    @Override
    public void update(String id) {
        if (id != null) {
            String prefix = this.getPrefix();
            int index = id.indexOf(prefix);
            int offset = index + prefix.length();
            if (index == 0 && offset < id.length()) {
                String suffix = id.substring(offset);
                try {
                    this.setCounter(Integer.parseInt(suffix));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected String getId(String id) {
        if (id == null || id.length() == 0) {
            id = this.generateId();
        } else {
            this.update(id);
        }
        return id;
    }
}

