/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.builder.BranchGraphBuilder;
import com.perforce.team.core.mergequest.builder.Messages;
import com.perforce.team.core.mergequest.builder.xml.BuilderRegistry;
import com.perforce.team.core.mergequest.builder.xml.IElementBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.factory.IContainerFactory;
import com.perforce.team.core.p4java.P4Workspace;
import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlBranchGraphBuilder
extends BranchGraphBuilder {
    public static final String EXTENSION_POINT_ID = "com.perforce.team.core.mergequest.builders";
    private static final String GRAPHS_ELEMENT = "graphs";
    private static final String GRAPH_ELEMENT = "graph";
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Transformer transformer;
    private BuilderRegistry registry = null;

    public XmlBranchGraphBuilder(IContainerFactory factory) {
        super(factory);
    }

    public XmlBranchGraphBuilder() {
    }

    private BuilderRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = new BuilderRegistry(EXTENSION_POINT_ID);
        }
        return this.registry;
    }

    protected void logLoadException(Throwable t) {
        if (t == null) {
            return;
        }
        if (t.getCause() != null) {
            t = t.getCause();
        }
        IOException ioException = new IOException(MessageFormat.format(Messages.XmlBranchGraphBuilder_ErrorLoading, t.getLocalizedMessage()), t);
        PerforceProviderPlugin.logError((Throwable)ioException);
    }

    protected void logPersistException(Throwable t) {
        if (t == null) {
            return;
        }
        if (t.getCause() != null) {
            t = t.getCause();
        }
        IOException ioException = new IOException(MessageFormat.format(Messages.XmlBranchGraphBuilder_ErrorSaving, t.getLocalizedMessage()), t);
        PerforceProviderPlugin.logError((Throwable)ioException);
    }

    private String createString(Document document) throws TransformerException {
        String value = null;
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        if (this.transformer == null) {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
        }
        this.transformer.transform(source, result);
        value = writer.toString();
        return value;
    }

    private DocumentBuilder getBuilder() {
        if (this.builder == null) {
            if (this.factory == null) {
                this.factory = DocumentBuilderFactory.newInstance();
            }
            try {
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        return this.builder;
    }

    private Document createNewDocument() {
        Document document = null;
        DocumentBuilder builder = this.getBuilder();
        if (builder != null) {
            document = builder.newDocument();
        }
        return document;
    }

    private IBranchGraph createGraph(Element graphElement, IBranchGraphContainer container) {
        String id = graphElement.getAttribute("id");
        IBranchGraph graph = container.createGraph(id);
        String name = graphElement.getAttribute("name");
        if (name.length() > 0) {
            graph.setName(name);
        }
        return graph;
    }

    protected String format(IBranchGraphContainer container) throws TransformerException {
        Document document;
        String value = null;
        if (container != null && (document = this.createNewDocument()) != null) {
            Element root = document.createElement(GRAPHS_ELEMENT);
            root.setAttribute("version", P4Workspace.getWorkspace().getVersion());
            document.appendChild(root);
            IBranchGraph[] iBranchGraphArray = container.getGraphs();
            int n = iBranchGraphArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraph graph = iBranchGraphArray[n2];
                Element graphNode = document.createElement(GRAPH_ELEMENT);
                this.fillGraph(graph, graphNode);
                root.appendChild(graphNode);
                ++n2;
            }
            value = this.createString(document);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void fillGraph(IBranchGraph graph, Element root) {
        root.setAttribute("id", graph.getId());
        String name = graph.getName();
        if (name != null) {
            root.setAttribute("name", name);
        }
        IElementBuilder builder = null;
        BuilderRegistry registry = this.getRegistry();
        IBranchGraphElement[] iBranchGraphElementArray = graph.getElements();
        int n = iBranchGraphElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBranchGraphElement element = iBranchGraphElementArray[n2];
            builder = registry.getBuilder(element);
            if (builder == null) {
                builder = (IElementBuilder)P4CoreUtils.convert((Object)element, IElementBuilder.class);
            }
            if (builder != null) {
                builder.save(root, element);
            }
            ++n2;
        }
    }

    protected IBranchGraphContainer unformat(InputSource source) throws SAXException, IOException {
        Document document;
        Element containerNode;
        DocumentBuilder builder;
        IBranchGraphContainer container = this.containerFactory.create();
        if (source != null && (builder = this.getBuilder()) != null && GRAPHS_ELEMENT.equals((containerNode = (document = builder.parse(source)).getDocumentElement()).getTagName())) {
            BuilderRegistry registry = this.getRegistry();
            NodeList graphs = containerNode.getElementsByTagName(GRAPH_ELEMENT);
            int h = 0;
            while (h < graphs.getLength()) {
                Element graphNode = (Element)graphs.item(h);
                IBranchGraph graph = this.createGraph(graphNode, container);
                if (graph != null && container.add(graph)) {
                    NodeList elements = graphNode.getChildNodes();
                    HashMap<IBranchGraphElement, IElementBuilder> completions = new HashMap<IBranchGraphElement, IElementBuilder>();
                    int e = 0;
                    while (e < elements.getLength()) {
                        Element element;
                        IElementBuilder elementBuilder;
                        Node node = elements.item(e);
                        if (node.getNodeType() == 1 && (elementBuilder = registry.getBuilder((element = (Element)node).getTagName())) != null) {
                            IBranchGraphElement created = elementBuilder.initialize(element, graph);
                            completions.put(created, elementBuilder);
                        }
                        ++e;
                    }
                    for (Map.Entry entry : completions.entrySet()) {
                        IElementBuilder eb = (IElementBuilder)entry.getValue();
                        if (eb == null) continue;
                        eb.complete((IBranchGraphElement)entry.getKey(), graph);
                    }
                }
                ++h;
            }
        }
        return container;
    }
}

