/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder;

import com.perforce.p4java.CharsetDefs;
import com.perforce.team.core.mergequest.builder.xml.XmlBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.model.factory.IContainerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileBranchGraphBuilder
extends XmlBranchGraphBuilder {
    private String path;

    public FileBranchGraphBuilder(IContainerFactory factory, String path) {
        super(factory);
        Assert.isNotNull((Object)path, (String)"Path cannot be null");
        this.path = path;
    }

    public FileBranchGraphBuilder(String path) {
        Assert.isNotNull((Object)path, (String)"Path cannot be null");
        this.path = path;
    }

    @Override
    public IBranchGraphContainer load() throws IOException {
        IOException ioException = null;
        try {
            InputSource source = new InputSource(new FileInputStream(this.path));
            IBranchGraphContainer iBranchGraphContainer = this.unformat(source);
            return iBranchGraphContainer;
        }
        catch (IOException e) {
            ioException = e;
            throw ioException;
        }
        catch (SAXException e) {
            ioException = new IOException(e);
            throw ioException;
        }
        finally {
            this.logLoadException(ioException);
        }
    }

    @Override
    public void persist(IBranchGraphContainer container) throws IOException {
        if (container != null) {
            PrintWriter writer = null;
            IOException ioException = null;
            try {
                try {
                    writer = new PrintWriter(this.path, CharsetDefs.DEFAULT_NAME);
                    writer.println(this.format(container));
                }
                catch (IOException e) {
                    ioException = e;
                    throw ioException;
                }
                catch (TransformerException e) {
                    ioException = new IOException(e);
                    throw ioException;
                }
            }
            finally {
                this.logPersistException(ioException);
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

