/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.model;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.patch.P4PatchUiPlugin;
import com.perforce.team.ui.patch.model.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PatchDiffRunner {
    public static final String PATCH_COMMAND_FILE_PREFIX = "p4eclipsePatch";
    public static final String PATCH_COMMAND_FILE_SUFFIX = ".txt";
    public static final String P4_ENV_PREFIX = "P4";
    private IP4Connection connection;
    private LinkedList<String> arguments;
    private File tmpFile = null;

    public PatchDiffRunner(IP4Connection connection) throws IOException {
        this.connection = connection;
        this.arguments = this.setupArguments();
    }

    protected void setupEnvironment(Map<String, String> environment) {
        if (environment != null) {
            String envKey = null;
            Object[] objectArray = environment.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                envKey = key.toString();
                if (envKey.startsWith(P4_ENV_PREFIX) && !envKey.equals("P4LOGINSSO") && !envKey.equals("P4TICKETS")) {
                    environment.remove(key);
                }
                ++n2;
            }
        }
    }

    protected LinkedList<String> setupArguments() throws IOException {
        String passwd;
        ConnectionParameters params = this.connection.getParameters();
        LinkedList<String> arguments = new LinkedList<String>();
        String p4Path = P4PatchUiPlugin.getDefault().getPreferenceStore().getString("P4_PATH");
        if (p4Path.length() == 0) {
            p4Path = "p4";
        }
        arguments.add(p4Path);
        arguments.add("-p");
        arguments.add(params.getPort());
        arguments.add("-u");
        arguments.add(params.getUser());
        arguments.add("-c");
        arguments.add(params.getClient());
        String charset = params.getCharsetNoNone();
        if (charset != null) {
            arguments.add("-C");
            arguments.add(charset);
        }
        if ((passwd = params.getPassword()) != null) {
            arguments.add("-P");
            arguments.add(passwd);
        }
        this.tmpFile = this.generateTempFile(arguments);
        arguments.add("diff");
        arguments.add("-t");
        arguments.add("-du");
        return arguments;
    }

    protected File generateTempFile(List<String> arguments) throws IOException {
        File file = File.createTempFile(PATCH_COMMAND_FILE_PREFIX, PATCH_COMMAND_FILE_SUFFIX);
        if (file != null) {
            file.deleteOnExit();
            arguments.add("-x");
            arguments.add(file.getAbsolutePath());
        }
        return file;
    }

    protected void writeFilePath(String filePath) throws IOException {
        Charset charset = ConnectionParameters.getJavaCharset((IP4Resource)this.connection);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(this.tmpFile, charset.name());
            writer.println(filePath);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public Process run(String filePath) throws IOException {
        Process process = null;
        if (filePath != null) {
            this.writeFilePath(filePath);
            ProcessBuilder builder = new ProcessBuilder(this.arguments);
            this.setupEnvironment(builder.environment());
            process = builder.start();
        }
        return process;
    }

    public void dispose() {
        if (this.tmpFile != null && !this.tmpFile.delete()) {
            String msg = MessageFormat.format(Messages.PatchDiffRunner_DeleteFileError, this.tmpFile.getAbsolutePath());
            PerforceProviderPlugin.logError((String)msg);
        }
    }
}

