/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.patch.actions.Messages;
import com.perforce.team.ui.patch.model.ErrorCollector;
import com.perforce.team.ui.patch.model.IPatchStream;
import com.perforce.team.ui.patch.model.P4Patch;
import com.perforce.team.ui.patch.wizard.CreatePatchWizard;
import com.perforce.team.ui.patch.wizard.CreatePatchWizardDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;

public class CreatePatchAction
extends P4Action {
    public static final int PATCH_SERVER_VERSION = 20092;

    protected boolean connectionSupported(IP4Connection connection) {
        if (!connection.isConnected()) {
            connection.connect();
        }
        return connection.getIntVersion() >= 20092;
    }

    protected void showNotSupported() {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.CreatePatchAction_NotSupported_Title, Messages.CreatePatchAction_NotSupported_Description);
            }
        });
    }

    protected void scheduleOpen(final P4Collection collection) {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                CreatePatchWizard wizard = new CreatePatchWizard(collection);
                CreatePatchWizardDialog dialog = new CreatePatchWizardDialog(P4UIUtils.getDialogShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    Object[] resources = wizard.getResources();
                    IPatchStream stream = wizard.getStream();
                    P4Patch patch = new P4Patch(stream, resources);
                    ErrorCollector collector = new ErrorCollector(){

                        @Override
                        public void done() {
                            if (this.getErrorCount() > 0) {
                                String message = this.getErrorCount() > 1 ? Messages.CreatePatchAction_MultipleErrorsMessage : Messages.CreatePatchAction_SingleErrorMessage;
                                final MultiStatus status = new MultiStatus("com.perforce.team.ui.patch", 4, message, null);
                                Throwable[] throwableArray = this.getErrors();
                                int n = throwableArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Throwable throwable = throwableArray[n2];
                                    status.add((IStatus)new Status(4, "com.perforce.team.ui.patch", Messages.CreatePatchAction_PatchErrorMessage, throwable));
                                    ++n2;
                                }
                                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ErrorDialog.openError((Shell)P4UIUtils.getDialogShell(), (String)Messages.CreatePatchAction_PatchFailedTitle, (String)Messages.CreatePatchAction_PatchFailedMessage, (IStatus)status);
                                    }
                                });
                            }
                        }
                    };
                    patch.generate(collector);
                }
            }
        });
    }

    protected void runAction() {
        final P4Collection collection = this.getResourceSelection();
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                boolean supported = true;
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (!CreatePatchAction.this.connectionSupported(resource.getConnection())) {
                        supported = false;
                        break;
                    }
                    ++n2;
                }
                if (supported) {
                    CreatePatchAction.this.scheduleOpen(collection);
                } else {
                    CreatePatchAction.this.showNotSupported();
                }
            }

            public String getTitle() {
                return Messages.CreatePatchAction_OpeningWizard_Titlte;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    protected boolean isEnabledEx() throws TeamException {
        return !this.getResourceSelection().isEmpty();
    }
}

