/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.synchronize;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.synchronize.IP4ReusableChangeSet;
import com.perforce.team.core.p4java.synchronize.P4PendingChangeSet;
import com.perforce.team.core.p4java.synchronize.PerforceSubscriber;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import com.perforce.team.core.p4java.synchronize.SubscriberChangeSetManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;

public final class P4ChangeSetManager
extends SubscriberChangeSetManager {
    private static P4ChangeSetManager manager;
    private ISubscriberChangeListener listener = new ISubscriberChangeListener(){

        public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
            HashMap<P4PendingChangeSet, ArrayList<IResource>> setAdds = null;
            ISubscriberChangeEvent[] iSubscriberChangeEventArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                ISubscriberChangeEvent event = iSubscriberChangeEventArray[n2];
                if ((1 & event.getFlags()) != 0 && (resource = event.getResource()) != null) {
                    try {
                        SyncInfo info = event.getSubscriber().getSyncInfo(resource);
                        P4PendingChangeSet set = P4ChangeSetManager.this.getChangeSet(info, resource);
                        if (set != null && !set.contains(resource)) {
                            ArrayList<IResource> resources;
                            if (setAdds == null) {
                                setAdds = new HashMap<P4PendingChangeSet, ArrayList<IResource>>();
                            }
                            if ((resources = (ArrayList<IResource>)setAdds.get(set)) == null) {
                                resources = new ArrayList<IResource>();
                                setAdds.put(set, resources);
                            }
                            resources.add(resource);
                        }
                    }
                    catch (TeamException e) {
                        PerforceProviderPlugin.logError(e);
                    }
                }
                ++n2;
            }
            if (setAdds != null) {
                for (Map.Entry entry : setAdds.entrySet()) {
                    P4PendingChangeSet changeSet = (P4PendingChangeSet)entry.getKey();
                    List resources = (List)entry.getValue();
                    try {
                        changeSet.add(resources.toArray(new IResource[resources.size()]));
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError(e);
                    }
                }
            }
        }
    };
    private IP4Listener p4Listener = new IP4Listener(){

        @Override
        public void resoureChanged(P4Event event) {
            P4Event.EventType type = event.getType();
            switch (type) {
                case CHANGED: 
                case REFRESHED: 
                case CREATE_CHANGELIST: {
                    P4ChangeSetManager.this.handleChangeEvent(event);
                    break;
                }
                case DELETE_CHANGELIST: 
                case SUBMIT_CHANGELIST: {
                    P4ChangeSetManager.this.handleDeleteEvent(event);
                    break;
                }
                case ACTIVE_CHANGELIST: {
                    P4ChangeSetManager.this.handleActiveEvent(event);
                    break;
                }
                case INACTIVE_CHANGELIST: {
                    P4ChangeSetManager.this.handleInactiveEvent(event);
                    break;
                }
                case OPENED: {
                    P4ChangeSetManager.this.handleReload(event);
                    break;
                }
            }
        }

        @Override
        public String getName() {
            return ((Object)((Object)P4ChangeSetManager.this)).getClass().getSimpleName();
        }
    };

    public static synchronized P4ChangeSetManager getChangeSetManager() {
        if (manager == null) {
            manager = new P4ChangeSetManager(PerforceSubscriber.getSubscriber());
        }
        return manager;
    }

    private P4ChangeSetManager(Subscriber subscriber) {
        super(subscriber);
    }

    @Override
    protected void initializeSets() {
        super.initializeSets();
        this.getSubscriber().addListener(this.listener);
        P4Workspace.getWorkspace().addListener(this.p4Listener);
    }

    private P4PendingChangeSet findListChangeSet(IP4PendingChangelist list) {
        if (list == null) {
            return null;
        }
        return this.findListChangeSet(new IP4PendingChangelist[]{list});
    }

    private P4PendingChangeSet findListChangeSet(IP4PendingChangelist[] lists) {
        P4PendingChangeSet pendingSet = null;
        IP4PendingChangelist[] iP4PendingChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist list = iP4PendingChangelistArray[n2];
            ChangeSet[] changeSetArray = this.getSets();
            int n3 = changeSetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ChangeSet set = changeSetArray[n4];
                pendingSet = (P4PendingChangeSet)set;
                if (list.equals(pendingSet.getChangelist())) {
                    return pendingSet;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private P4PendingChangeSet findEventChangeSet(P4Event event) {
        return this.findListChangeSet(event.getPending());
    }

    private void handleChangeEvent(P4Event event) {
        P4PendingChangeSet set = this.findEventChangeSet(event);
        if (set != null) {
            set.refresh();
        }
    }

    private void handleDeleteEvent(P4Event event) {
        P4PendingChangeSet set = this.findEventChangeSet(event);
        if (set != null) {
            set.setValid(false);
            this.remove((ChangeSet)set);
        }
    }

    private void handleActiveEvent(P4Event event) {
        P4PendingChangeSet set = this.findEventChangeSet(event);
        if (set != null) {
            this.syncDefaultList(set, false);
        }
    }

    private void handleInactiveEvent(P4Event event) {
        IP4Connection[] connections = event.getConnections();
        P4PendingChangeSet defaultSet = (P4PendingChangeSet)this.getDefaultSet();
        if (defaultSet != null && defaultSet.getConnection() != null) {
            IP4Connection[] iP4ConnectionArray = connections;
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Connection connection = iP4ConnectionArray[n2];
                if (connection.equals(defaultSet.getConnection())) {
                    this.syncDefaultList(null, false);
                    break;
                }
                ++n2;
            }
        }
    }

    private void handleReload(P4Event event) {
        P4PendingChangeSet defaultSet = (P4PendingChangeSet)this.getDefaultSet();
        if (defaultSet == null || defaultSet.isValid()) {
            return;
        }
        if (defaultSet instanceof IP4ReusableChangeSet && ((IP4ReusableChangeSet)((Object)defaultSet)).activate(event.getFiles())) {
            defaultSet.setValid(true);
            this.add((ChangeSet)defaultSet);
            this.makeDefault(defaultSet);
        }
    }

    public P4PendingChangeSet getPendingChangeSet(IP4File file) {
        IP4PendingChangelist list;
        P4PendingChangeSet changeSet = null;
        if (file != null && file.isOpened() && (list = file.getChangelist(true)) != null && (changeSet = this.findListChangeSet(list)) == null) {
            changeSet = new P4PendingChangeSet((ActiveChangeSetManager)this, list);
            this.add((ChangeSet)changeSet);
        }
        return changeSet;
    }

    public void add(ChangeSet set) {
        P4PendingChangeSet p4Set;
        if (set instanceof P4PendingChangeSet && (p4Set = (P4PendingChangeSet)set).isValid() && p4Set.getConnection() != null && p4Set.getChangelist() != null) {
            if (!this.contains(set)) {
                super.add(set);
            } else {
                this.replaceList(p4Set);
            }
        }
    }

    private void replaceList(P4PendingChangeSet set) {
        if (this.contains((ChangeSet)set)) {
            ChangeSet[] changeSetArray = this.getSets();
            int n = changeSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet current = changeSetArray[n2];
                if (set.equals(current) && set.getPriority() > ((P4PendingChangeSet)current).getPriority()) {
                    this.remove(current);
                    try {
                        set.add(current.getResources());
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError(e);
                    }
                    this.add((ChangeSet)set);
                    break;
                }
                ++n2;
            }
        }
    }

    private void syncDefaultList(ActiveChangeSet set, boolean makeActive) {
        if (set instanceof P4PendingChangeSet) {
            IP4PendingChangelist list;
            this.replaceList((P4PendingChangeSet)set);
            super.makeDefault(set);
            if (makeActive && (list = ((P4PendingChangeSet)set).getChangelist()) != null) {
                list.makeActive();
            }
        } else {
            IP4PendingChangelist list;
            ActiveChangeSet current = this.getDefaultSet();
            super.makeDefault(null);
            if (current != null && makeActive && (list = ((P4PendingChangeSet)current).getChangelist()) != null && list.isActive()) {
                list.getConnection().setActivePendingChangelist(-1);
            }
        }
    }

    public void makeDefault(ActiveChangeSet set) {
        this.syncDefaultList(set, true);
    }

    @Override
    protected void updateChangeSet(IResource resource) {
        if (resource != null) {
            try {
                this.updateChangeSet(this.getSubscriber().getSyncInfo(resource), resource);
            }
            catch (TeamException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    private boolean isValidInfo(SyncInfo info) {
        return info instanceof PerforceSyncInfo && (info.getKind() & 4) != 0;
    }

    protected P4PendingChangeSet getChangeSet(SyncInfo info, IResource resource) {
        if (this.isValidInfo(info)) {
            return this.getPendingChangeSet(((PerforceSyncInfo)info).getP4File());
        }
        return null;
    }

    protected void updateChangeSet(SyncInfo info, IResource resource) {
        if (this.isValidInfo(info)) {
            IP4File file = ((PerforceSyncInfo)info).getP4File();
            this.updateChangeSet(file, resource);
        }
    }

    protected void updateChangeSet(IP4File file, IResource resource) {
        P4PendingChangeSet changeSet = this.getPendingChangeSet(file);
        if (changeSet != null && !changeSet.contains(resource)) {
            try {
                changeSet.add(new IResource[]{resource});
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getSubscriber().removeListener(this.listener);
        P4Workspace.getWorkspace().removeListener(this.p4Listener);
    }

    protected ActiveChangeSet doCreateSet(String name) {
        return new P4PendingChangeSet((ActiveChangeSetManager)this, name);
    }

    protected void handleAddedResources(ChangeSet set, IDiff[] diffs) {
        if (set != null) {
            super.handleAddedResources(set, diffs);
        }
    }
}

