/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.team.core.p4java.AbstractP4ProgressPresenter;
import com.perforce.team.core.p4java.Messages;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorProgressPresenter
extends AbstractP4ProgressPresenter {
    IProgressMonitor monitor;

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void begin(String command, int total) {
        super.begin(command, total);
        this.getMonitor().beginTask(command, total);
    }

    @Override
    public void update(int total, int current, int delta, String filePath) {
        if (filePath != null) {
            String fileName = this.getFileNameOnly(filePath);
            this.getMonitor().setTaskName(MessageFormat.format(Messages.ProgressMonitorProgressPresenter_CurrentOfTotalNextFile, this.command, current + delta, total, fileName));
        } else {
            this.getMonitor().setTaskName(MessageFormat.format(Messages.ProgressMonitorProgressPresenter_CurrentOfTotal, this.command, current, total));
        }
        this.getMonitor().worked(delta);
    }

    @Override
    public void update(long total, long current, String filePath, int thisPercent, long thisSize) {
        if (filePath != null) {
            String fileName = this.getFileNameOnly(filePath);
            this.getMonitor().setTaskName(MessageFormat.format(Messages.ProgressMonitorProgressPresenter_CurrentOfTotalNextFilePercentOfSize, this.command, current, total, fileName, thisPercent, NumberFormat.getInstance().format(thisSize)));
        } else {
            this.getMonitor().setTaskName(MessageFormat.format(Messages.ProgressMonitorProgressPresenter_CurrentOfTotal, this.command, current, total));
        }
    }

    private String getFileNameOnly(String filePath) {
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            int index = 0;
            int i = filePath.length() - 1;
            while (i >= 0) {
                if (filePath.charAt(i) == '/' || filePath.charAt(i) == '\\') {
                    index = i;
                    break;
                }
                --i;
            }
            if (index + 1 < filePath.length()) {
                return filePath.substring(index + 1);
            }
        }
        return null;
    }

    @Override
    public void end() {
        this.getMonitor().done();
    }

    @Override
    public boolean isCancelled() {
        return this.getMonitor().isCanceled();
    }
}

