/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NoSuchObjectException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.ResourceException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.ILogCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4JavaCallback;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.ConnectionMappedException;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IErrorReporter;
import com.perforce.team.core.p4java.IEventObject;
import com.perforce.team.core.p4java.IP4CommandListener;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ConnectionListener;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4WorkspaceConfigurer;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public final class P4Workspace
implements IEventObject,
IErrorReporter {
    public static final String LISTENER_ELEMENT = "listener";
    public static final String CONNECTION_LISTENER = "connectionListener";
    public static final String CONFIGURER_ELEMENT = "configurer";
    public static final String WORKSPACE_EXTENSION_POINT = "com.perforce.team.core.workspace";
    public static final String CLASS_ATTR = "class";
    public static final String CONNECTIONS = "com.perforce.team.core.p4java.P4_CONNECTIONS";
    public static final String VERSION_UNKNOWN = "unknown";
    public static final String PROG_NAME = "p4eclipse";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    private static P4Workspace cache;
    private Map<ConnectionParameters, IP4Connection> connections;
    private IErrorHandler errorHandler = null;
    private ListenerList listeners;
    private ListenerList connectionListeners;
    private ISchedulingRule rule;
    private P4JavaCallback callbackHandler;
    private ILogCallback.LogTraceLevel traceLevel = null;
    private Properties advancedProperties = new Properties();
    private boolean persistOffline = false;
    private String version = null;
    private ISystemFileCommandsHelper fileHelper = SysFileHelperBridge.getSysFileCommands();
    private final Properties serverProperties = new Properties(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getProperty(String key, String defaultValue) {
            String property = P4Workspace.this.advancedProperties.getProperty(key);
            if (property == null) {
                property = super.getProperty(key, defaultValue);
            }
            return property;
        }

        @Override
        public String getProperty(String key) {
            String property = P4Workspace.this.advancedProperties.getProperty(key);
            if (property == null) {
                property = super.getProperty(key);
            }
            return property;
        }
    };

    private P4Workspace() {
        this.connections = Collections.synchronizedMap(new HashMap());
        this.listeners = new ListenerList();
        this.rule = P4Runner.createRule();
        this.connectionListeners = new ListenerList();
        this.callbackHandler = new P4JavaCallback();
    }

    private void load() {
        this.loadServerProperties();
        this.loadConfigurer();
        ServerFactory.setRpcFileSystemHelper((ISystemFileCommandsHelper)this.getFileHelper());
        this.loadConnections();
        this.loadProjectProperties();
        this.loadExtensionPointListeners();
    }

    private void loadConfigurer() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(WORKSPACE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (CONFIGURER_ELEMENT.equals(element.getName()) && (className = element.getAttribute(CLASS_ATTR)) != null) {
                try {
                    Object createdListener = element.createExecutableExtension(CLASS_ATTR);
                    if (createdListener instanceof IP4WorkspaceConfigurer) {
                        ((IP4WorkspaceConfigurer)createdListener).configure(this);
                    }
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
            ++n2;
        }
    }

    public String getVersion() {
        if (this.version == null) {
            String parsed = VERSION_UNKNOWN;
            try {
                int lastDot;
                Bundle bundle = PerforceProviderPlugin.getPlugin().getBundle();
                Object versionValue = bundle.getHeaders().get(BUNDLE_VERSION);
                if (versionValue != null && (lastDot = (parsed = versionValue.toString()).lastIndexOf(46)) > -1 && lastDot + 1 < parsed.length()) {
                    parsed = String.valueOf(parsed.substring(0, lastDot)) + "/" + parsed.substring(lastDot + 1);
                }
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError(e);
            }
            this.version = parsed;
        }
        return this.version;
    }

    private void loadServerProperties() {
        this.serverProperties.put("com.perforce.p4java.programVersion", this.getVersion());
        this.serverProperties.put("com.perforce.p4java.programName", PROG_NAME);
        this.serverProperties.put("relaxCmdNameChecks", (Object)true);
    }

    private void loadProjectProperties() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.getConnection(project);
            ++n2;
        }
    }

    private void loadConnections() {
        String s = InstanceScope.INSTANCE.getNode("com.perforce.team.core").get(CONNECTIONS, "");
        if (s != null && s.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(s, ":");
            while (tokenizer.hasMoreTokens()) {
                String conString = this.unescapeColons(tokenizer.nextToken());
                ConnectionParameters params = new ConnectionParameters(conString);
                IP4Connection connection = this.getConnection(params);
                if (!this.persistOffline) continue;
                connection.setOffline(params.isOffline());
            }
        }
    }

    private String unescapeColons(String s) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (s.charAt(++i) == '\\') {
                    buff.append('\\');
                } else {
                    buff.append(':');
                }
            } else {
                buff.append(ch);
            }
            ++i;
        }
        return buff.toString();
    }

    private String escapeColons(String s) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case ':': {
                    buff.append("\\c");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                default: {
                    buff.append(ch);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public ISchedulingRule getRule() {
        return this.rule;
    }

    public boolean canConnect(String serverAddress) throws P4JavaException {
        try {
            ConnectionParameters params = new ConnectionParameters();
            params.setPort(serverAddress);
            this.tryToConnect(params);
            return true;
        }
        catch (P4JavaError e) {
            PerforceProviderPlugin.logError(e);
            return false;
        }
    }

    public IP4Connection tryToConnect(ConnectionParameters params, IErrorHandler handler) throws P4JavaException {
        P4Connection connection = new P4Connection(params);
        connection.setErrorHandler(handler);
        IServer server = connection.getServer();
        if (server != null) {
            if (server.getStatus() == ServerStatus.READY) {
                return connection;
            }
            throw new P4JavaException(Messages.P4Workspace_ServerNotReady);
        }
        throw new P4JavaException(MessageFormat.format(Messages.P4Workspace_CannotReachServer, params.toString()));
    }

    public IP4Connection tryToConnect(ConnectionParameters params) throws P4JavaException {
        final P4JavaException[] exceptions = new P4JavaException[1];
        IErrorHandler handler = new IErrorHandler(){

            @Override
            public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
                exceptions[0] = exception;
                return false;
            }

            @Override
            public void handleErrorSpecs(IFileSpec[] specs) {
            }
        };
        P4Connection connection = new P4Connection(params);
        connection.setErrorHandler(handler);
        IServer server = connection.getServer();
        if (server != null) {
            if (server.getStatus() == ServerStatus.READY) {
                return connection;
            }
            throw new P4JavaException(Messages.P4Workspace_ServerNotReady);
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        throw new P4JavaException(MessageFormat.format(Messages.P4Workspace_CannotReachServer, params.toString()));
    }

    public IClient getClient(String serverAddress, String user, String client) throws P4JavaException {
        return this.getClient(serverAddress, user, client, null);
    }

    public IClient getClient(String serverAddress, String user, String client, String authTicket) throws P4JavaException {
        IClient p4jClient = null;
        try {
            String serverUri = "p4java://" + serverAddress;
            IServer server = P4Workspace.createServer(serverUri);
            if (server != null) {
                server.setUserName(user);
                server.setAuthTicket(authTicket);
                server.connect();
                p4jClient = server.getClient(client);
            }
        }
        catch (URISyntaxException e) {
            PerforceProviderPlugin.logError(e);
        }
        catch (P4JavaError e) {
            PerforceProviderPlugin.logError(e);
        }
        return p4jClient;
    }

    public IUserSummary[] getUsers(String host, int port, int max, List<String> usernames) throws P4JavaException {
        List users = new ArrayList();
        try {
            String serverUri = "p4java://" + host + ":" + port;
            IServer server = P4Workspace.createServer(serverUri);
            if (server != null) {
                server.connect();
                users = server.getUsers(usernames, max);
            }
        }
        catch (URISyntaxException e) {
            PerforceProviderPlugin.logError(e);
        }
        catch (P4JavaError e) {
            PerforceProviderPlugin.logError(e);
        }
        return (IUserSummary[])users.toArray(new IUser[0]);
    }

    public IUserSummary[] getUsers(String host, int port) throws P4JavaException {
        return this.getUsers(host, port, -1, null);
    }

    public void saveConnections() {
        StringBuilder s = new StringBuilder();
        for (IP4Connection connection : this.connections.values()) {
            ConnectionParameters params = connection.getParameters();
            if (params == null) continue;
            params.setOffline(connection.isOffline());
            s.append(this.escapeColons(params.toString()));
            s.append(':');
        }
        if (s.length() > 0) {
            s.deleteCharAt(s.length() - 1);
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.perforce.team.core");
        node.put(CONNECTIONS, s.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            PerforceProviderPlugin.logError(e);
        }
    }

    private void loadExtensionPointListeners() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(WORKSPACE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object createdListener;
            String className;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (LISTENER_ELEMENT.equals(element.getName())) {
                className = element.getAttribute(CLASS_ATTR);
                if (className != null) {
                    try {
                        createdListener = element.createExecutableExtension(CLASS_ATTR);
                        if (createdListener instanceof IP4Listener) {
                            this.addListener((IP4Listener)createdListener);
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError(e);
                    }
                }
            } else if (CONNECTION_LISTENER.equals(element.getName()) && (className = element.getAttribute(CLASS_ATTR)) != null) {
                try {
                    createdListener = element.createExecutableExtension(CLASS_ATTR);
                    if (createdListener instanceof IP4ConnectionListener) {
                        this.addConnectionListener((IP4ConnectionListener)createdListener);
                    }
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
            ++n2;
        }
    }

    public P4JavaCallback getCallback() {
        return this.callbackHandler;
    }

    ISSOCallback getSSOCallback() {
        return this.callbackHandler;
    }

    @Override
    public void addListener(IP4Listener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    @Override
    public void removeListener(IP4Listener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    public void addConnectionListener(IP4ConnectionListener listener) {
        if (listener != null) {
            this.connectionListeners.add((Object)listener);
        }
    }

    public void removeConnectionListener(IP4ConnectionListener listener) {
        if (listener != null) {
            this.connectionListeners.remove((Object)listener);
        }
    }

    @Override
    public void notifyListeners(final P4Event event) {
        Tracing.printTrace(String.valueOf(this.getClass().getSimpleName()) + ":notifyListners()", event.toString());
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            Tracing.printExecTime(Policy.DEBUG, String.valueOf(this.getClass().getSimpleName()) + ":notifyListeners()", MessageFormat.format("{0}", ((IP4Listener)listener).getName()), new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IP4Listener)listener).resoureChanged(event);
                    }
                    catch (Exception e) {
                        PerforceProviderPlugin.logError(e);
                    }
                    catch (Error e) {
                        PerforceProviderPlugin.logError(e);
                    }
                }
            });
            ++n2;
        }
    }

    private IP4Resource loadResource(IResource resource) {
        IP4Connection connection;
        IProject project;
        IP4Resource p4Resource = null;
        if (resource != null && (project = resource.getProject()) != null && (connection = this.getConnection(project)) != null && !connection.isOffline()) {
            p4Resource = connection.getResource(resource);
        }
        return p4Resource;
    }

    private IP4Resource findResource(IResource resource) throws IllegalArgumentException {
        IProject project;
        IP4Resource p4Resource = null;
        if (resource != null && (project = resource.getProject()) != null) {
            PerforceTeamProvider provider = PerforceProviderPlugin.getPerforceProviderFor((IResource)project);
            if (provider != null) {
                try {
                    ConnectionParameters params = provider.getProjectProperties(false);
                    IP4Connection connection = this.getConnection(params);
                    if (connection != null) {
                        String path = resource.getLocation().makeAbsolute().toOSString();
                        p4Resource = connection.getResource(path);
                    }
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError(e);
                }
            } else {
                throw new IllegalArgumentException(Messages.P4Workspace_NonPerforceProject);
            }
        }
        return p4Resource;
    }

    public IP4Resource asyncGetResource(final IResource resource) {
        IP4Resource p4Resource = null;
        boolean valid = true;
        try {
            p4Resource = this.findResource(resource);
        }
        catch (IllegalArgumentException e) {
            valid = false;
        }
        if (p4Resource == null && valid) {
            P4Runner.schedule(new P4Runnable(){

                @Override
                public void run(IProgressMonitor monitor) {
                    P4Workspace.this.loadResource(resource);
                }
            }, this.rule);
        }
        return p4Resource;
    }

    public IP4Resource getResource(IResource resource) {
        return this.loadResource(resource);
    }

    public IP4Connection getConnection(IProject project) {
        PerforceTeamProvider provider;
        IP4Connection connection = null;
        if (project != null && (provider = PerforceProviderPlugin.getPerforceProviderFor((IResource)project)) != null) {
            try {
                ConnectionParameters params = provider.getProjectProperties(false);
                connection = this.getConnection(params);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IP4Connection getConnection(ConnectionParameters parameters) {
        boolean newConnection = false;
        IP4Connection connection = null;
        P4Workspace p4Workspace = this;
        synchronized (p4Workspace) {
            connection = this.connections.get(parameters);
            if (connection == null) {
                connection = new P4Connection(parameters);
                if (this.errorHandler != null) {
                    connection.setErrorHandler(this.errorHandler);
                }
                this.connections.put(parameters, connection);
                newConnection = true;
            }
        }
        if (connection != null && newConnection) {
            this.notifyListeners(new P4Event(P4Event.EventType.ADDED, connection));
            final IP4Connection eventConnection = connection;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    Object[] objectArray = P4Workspace.this.connectionListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        ((IP4ConnectionListener)listener).connectionAdded(eventConnection);
                        ++n2;
                    }
                }

                public void handleException(Throwable exception) {
                    PerforceProviderPlugin.logError(exception);
                }
            });
        }
        return connection;
    }

    public boolean containsConnection(ConnectionParameters parameters) {
        return parameters != null && this.connections.containsKey(parameters);
    }

    public IP4Connection[] getConnections() {
        return this.connections.values().toArray(new P4Connection[0]);
    }

    public int size() {
        return this.connections.size();
    }

    public void removeConnection(final ConnectionParameters parameters) throws ConnectionMappedException {
        if (parameters != null) {
            if (this.hasMappedProjects(parameters)) {
                throw new ConnectionMappedException(this.getMappedProjects(parameters));
            }
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    Object[] objectArray = P4Workspace.this.connectionListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        ((IP4ConnectionListener)listener).connectionRemovalRequested(parameters);
                        ++n2;
                    }
                }

                public void handleException(Throwable exception) {
                    PerforceProviderPlugin.logError(exception);
                }
            });
            final IP4Connection removed = this.connections.remove(parameters);
            if (removed != null) {
                removed.dispose();
                this.notifyListeners(new P4Event(P4Event.EventType.REMOVED, removed));
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        Object[] objectArray = P4Workspace.this.connectionListeners.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object listener = objectArray[n2];
                            ((IP4ConnectionListener)listener).connectionRemoved(removed);
                            ++n2;
                        }
                    }

                    public void handleException(Throwable exception) {
                        PerforceProviderPlugin.logError(exception);
                    }
                });
            }
        }
    }

    public void removeConnection(IP4Connection connection) throws ConnectionMappedException {
        if (connection != null) {
            this.removeConnection(connection.getParameters());
        }
    }

    public void clear() {
        this.connections.clear();
    }

    public static synchronized P4Workspace getWorkspace() {
        if (cache == null) {
            cache = new P4Workspace();
            cache.load();
        }
        return cache;
    }

    @Override
    public void addListeners(IP4Listener[] listeners) {
        if (listeners != null) {
            IP4Listener[] iP4ListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Listener listener = iP4ListenerArray[n2];
                this.addListener(listener);
                ++n2;
            }
        }
    }

    public void addCommandListener(IP4CommandListener listener) {
        if (listener != null) {
            this.callbackHandler.addCommandListener(listener);
        }
    }

    public void removeCommandListener(IP4CommandListener listener) {
        if (listener != null) {
            this.callbackHandler.removeCommandListener(listener);
        }
    }

    public Properties getServerProperties() {
        return this.serverProperties;
    }

    public boolean hasMappedProjects(IP4Connection connection) {
        boolean mapped = false;
        if (connection != null) {
            mapped = connection.hasMappedProjects();
        }
        return mapped;
    }

    public IProject[] getMappedProjects(ConnectionParameters parameters) {
        IProject[] projects = new IProject[]{};
        if (parameters != null) {
            IP4Connection connection = this.connections.get(parameters);
            projects = this.getMappedProjects(connection);
        }
        return projects;
    }

    public IProject[] getMappedProjects(IP4Connection connection) {
        IProject[] projects = new IProject[]{};
        if (connection != null) {
            projects = connection.getMappedProjects();
        }
        return projects;
    }

    public boolean hasMappedProjects(ConnectionParameters parameters) {
        boolean mapped = false;
        if (parameters != null) {
            IP4Connection connection = this.connections.get(parameters);
            mapped = this.hasMappedProjects(connection);
        }
        return mapped;
    }

    public synchronized IP4Connection editConnection(IP4Connection connection, ConnectionParameters newParameters) {
        IP4Connection newConnection = null;
        if (connection != null && newParameters != null && !newParameters.equals(connection.getParameters())) {
            IP4Connection oldConnection = connection;
            IErrorHandler oldHandler = oldConnection.getErrorHandler();
            IProject[] projects = connection.getMappedProjects();
            connection = newConnection = this.getConnection(newParameters);
            if (oldHandler != null) {
                connection.setErrorHandler(oldHandler);
            }
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                PerforceTeamProvider provider = PerforceTeamProvider.getPerforceProvider((IResource)project);
                if (provider != null) {
                    provider.setProjectProperties(connection.getParameters());
                }
                ++n2;
            }
            final ConnectionParameters oldParams = oldConnection.getParameters();
            if (oldParams != null && newConnection != null) {
                final IP4Connection eventConnection = connection;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        Object[] objectArray = P4Workspace.this.connectionListeners.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object listener = objectArray[n2];
                            ((IP4ConnectionListener)listener).connectionChanged(eventConnection, oldParams);
                            ++n2;
                        }
                    }

                    public void handleException(Throwable exception) {
                        PerforceProviderPlugin.logError(exception);
                    }
                });
            }
            try {
                this.removeConnection(oldConnection);
            }
            catch (ConnectionMappedException cme) {
                PerforceProviderPlugin.logError(cme);
            }
        }
        return newConnection;
    }

    @Override
    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean handleError(P4JavaException exception) {
        return false;
    }

    @Override
    public void handleErrors(IFileSpec[] specs) {
    }

    @Override
    public void setErrorHandler(IErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ILogCallback.LogTraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(ILogCallback.LogTraceLevel traceLevel) {
        this.traceLevel = traceLevel;
    }

    public Properties getAdvancedProperties() {
        return this.advancedProperties;
    }

    public ISystemFileCommandsHelper getFileHelper() {
        return this.fileHelper;
    }

    public void setFileHelper(ISystemFileCommandsHelper fileHelper) {
        this.fileHelper = fileHelper;
    }

    public boolean isPersistOffline() {
        return this.persistOffline;
    }

    public void setPersistOffline(boolean persistOffline) {
        this.persistOffline = persistOffline;
    }

    public static boolean addTrust(String serverIpPort, String fingerprint) throws P4JavaException {
        String serverUri = "p4javassl://" + serverIpPort;
        try {
            Properties properties = new Properties();
            properties.put("filesys.utf8bom", "0");
            IOptionsServer server = ServerFactory.getOptionsServer((String)serverUri, (Properties)properties);
            String result = server.addTrust(fingerprint);
            return result.contains("Added trust for P4 server");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static IServer createServer(String serverUri) throws ConnectionException, NoSuchObjectException, ConfigException, ResourceException, URISyntaxException {
        Properties props = P4Workspace.getWorkspace().getServerProperties();
        props.put("filesys.utf8bom", "0");
        return P4Workspace.createServer(serverUri, props);
    }

    public static IServer createServer(String serverUri, Properties props) throws ConnectionException, NoSuchObjectException, ConfigException, ResourceException, URISyntaxException {
        props.put("enableProgress", "true");
        UsageOptions opts = new UsageOptions(props);
        opts.setHostName(P4Workspace.getP4HOST());
        IOptionsServer newServer = ServerFactory.getOptionsServer((String)serverUri, (Properties)props, (UsageOptions)opts);
        return newServer;
    }

    public static String getP4HOST() {
        Properties props = P4Workspace.getWorkspace().getServerProperties();
        String hostname = props.getProperty("P4HOST");
        if (StringUtils.isEmpty((CharSequence)hostname)) {
            hostname = System.getenv("P4HOST");
        }
        return hostname;
    }
}

