/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.PerforceProviderPlugin;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class P4LogUtils {
    public static String getError(IFileSpec[] specs) {
        StringBuffer buffer = new StringBuffer();
        IFileSpec[] iFileSpecArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            IFileSpec spec = iFileSpecArray[n2];
            String message = spec.getStatusMessage();
            if (message != null) {
                buffer.append(message).append("\n");
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static void logError(IFileSpec[] specs) {
        PerforceProviderPlugin.logError(P4LogUtils.getError(specs));
    }

    public static boolean reflectiveEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        String astring = ReflectionToStringBuilder.reflectionToString((Object)a, (ToStringStyle)new RecursiveToStringStyle(-1));
        String bstring = ReflectionToStringBuilder.reflectionToString((Object)b, (ToStringStyle)new RecursiveToStringStyle(-1));
        return astring.endsWith(bstring);
    }

    public static boolean testEquals(Object a, Object b) {
        if ((a instanceof String || b instanceof String) && StringUtils.isEmpty((CharSequence)((String)a)) && StringUtils.isEmpty((CharSequence)((String)b))) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static class RecursiveToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 2509154210044460206L;
        private static final int INFINITE_DEPTH = -1;
        private int maxDepth;
        private int depth;

        public RecursiveToStringStyle() {
            this(-1);
        }

        public RecursiveToStringStyle(int maxDepth) {
            String indent = SystemUtils.LINE_SEPARATOR;
            this.setContentStart(String.valueOf(indent) + "{");
            this.setFieldSeparator(String.valueOf(indent) + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(String.valueOf(indent) + "}");
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.maxDepth = maxDepth;
        }

        private void updateDepth(int delta) {
            String indent;
            if (delta > 0) {
                indent = String.valueOf(SystemUtils.LINE_SEPARATOR) + this.getIndent(this.depth);
                this.setContentStart(String.valueOf(indent) + "{");
            } else {
                indent = String.valueOf(SystemUtils.LINE_SEPARATOR) + this.getIndent(this.depth + delta);
                this.setContentStart(String.valueOf(indent) + "{");
            }
            this.depth += delta;
            indent = String.valueOf(SystemUtils.LINE_SEPARATOR) + this.getIndent(this.depth);
            this.setFieldSeparator(indent);
            if (delta > 0) {
                indent = String.valueOf(SystemUtils.LINE_SEPARATOR) + this.getIndent(this.depth - delta);
                this.setContentEnd(String.valueOf(indent) + "}");
            } else {
                indent = String.valueOf(SystemUtils.LINE_SEPARATOR) + this.getIndent(this.depth + delta);
                this.setContentEnd(String.valueOf(indent) + "}");
            }
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value.getClass().getName().startsWith("java.lang.") || this.maxDepth != -1 && this.depth >= this.maxDepth) {
                buffer.append(value);
            } else {
                this.updateDepth(1);
                buffer.append(ReflectionToStringBuilder.toString((Object)value, (ToStringStyle)this));
                this.updateDepth(-1);
            }
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
            this.updateDepth(1);
            buffer.append(ReflectionToStringBuilder.toString((Object)coll.toArray(), (ToStringStyle)this, (boolean)true, (boolean)true));
            this.updateDepth(-1);
        }

        protected String getIndent(int depth) {
            StringBuilder sb = new StringBuilder();
            int i = -1;
            while (i < depth) {
                sb.append("  ");
                ++i;
            }
            return sb.toString();
        }
    }
}

