/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.P4ProgressListener;
import com.perforce.team.core.p4java.ProgressMonitorProgressPresenter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public final class P4CoreUtils {
    private static Random rand = new Random(System.currentTimeMillis());
    public static final int BUFFER_SIZE = 8192;
    private static final boolean IS_MAC;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_LINUX;
    private static final boolean IS_COCOA;
    private static Comparator<IP4Changelist> CHANGELIST_COMPARATOR;

    static {
        String os = Platform.getOS();
        IS_MAC = "macosx".equals(os);
        IS_WINDOWS = "win32".equals(os);
        IS_LINUX = "linux".equals(os);
        IS_COCOA = IS_MAC ? "cocoa".equals(Platform.getWS()) : false;
        CHANGELIST_COMPARATOR = null;
    }

    private P4CoreUtils() {
    }

    public static String getResourceActionPath(IResource resource) {
        StringBuilder path = null;
        if (resource != null) {
            IPath location = resource.getLocation();
            if (location != null) {
                location = location.makeAbsolute();
            }
            if (location != null) {
                int length;
                path = new StringBuilder(location.toOSString());
                if (resource instanceof IContainer && (length = path.length()) > 0 && path.charAt(length - 1) != File.separatorChar) {
                    path.append(IP4Folder.DIR_ELLIPSIS);
                }
            }
        }
        return path != null ? path.toString() : null;
    }

    public static String getCommonPath(String ... resourcePaths) {
        if (resourcePaths != null) {
            return P4CoreUtils.getCommonPath(Arrays.asList(resourcePaths));
        }
        return P4CoreUtils.getCommonPath(null);
    }

    public static String getCommonPath(Collection<String> resourcePaths) {
        StringBuilder path = null;
        String[] paths = null;
        if (resourcePaths != null && !resourcePaths.isEmpty()) {
            for (String resourcePath : resourcePaths) {
                String[] segments = resourcePath.split("/");
                if (paths != null) {
                    int common = 0;
                    int length = Math.min(paths.length, segments.length);
                    int i = 0;
                    while (i < length) {
                        if (!segments[i].equals(paths[i])) break;
                        ++common;
                        ++i;
                    }
                    String[] newPaths = new String[common];
                    System.arraycopy(segments, 0, newPaths, 0, common);
                    paths = newPaths;
                    continue;
                }
                paths = new String[segments.length - 1];
                System.arraycopy(segments, 0, paths, 0, segments.length - 1);
            }
        }
        if (paths != null) {
            path = new StringBuilder("//");
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                void segment = stringArray[n2];
                if (segment.length() > 0) {
                    path.append((String)segment);
                    path.append('/');
                }
                ++n2;
            }
            path.append("...");
        }
        if (path == null) {
            path = new StringBuilder("//...");
        }
        return path.toString();
    }

    public static String getName(String depotPath) {
        int lastSlash;
        String name = "";
        if (depotPath != null && (lastSlash = depotPath.lastIndexOf(47)) >= 0 && lastSlash + 1 < depotPath.length()) {
            name = depotPath.substring(lastSlash + 1);
        }
        return name;
    }

    public static <Converted> Converted convert(Object object, Class<Converted> target) {
        if (object != null && target != null) {
            if (target.isInstance(object)) {
                Object converted = object;
                return (Converted)converted;
            }
            if (object instanceof IAdaptable && (object = ((IAdaptable)object).getAdapter(target)) != null && target.isInstance(object)) {
                Object converted = object;
                return (Converted)converted;
            }
        }
        return null;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isCocoa() {
        return IS_COCOA;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static IResource getResource(Object obj) {
        Object adapter;
        IResource resource = null;
        if (obj instanceof IResource) {
            resource = (IResource)obj;
        } else if (obj instanceof IAdaptable && (adapter = ((IAdaptable)obj).getAdapter(IResource.class)) instanceof IResource) {
            resource = (IResource)adapter;
        }
        return resource;
    }

    public static void sort(IP4Changelist[] lists) {
        if (CHANGELIST_COMPARATOR == null) {
            CHANGELIST_COMPARATOR = new Comparator<IP4Changelist>(){

                @Override
                public int compare(IP4Changelist change1, IP4Changelist change2) {
                    return change1.getId() - change2.getId();
                }
            };
        }
        Arrays.sort(lists, CHANGELIST_COMPARATOR);
    }

    public static List<IFile> getAllFiles(IResource[] resources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    files.addAll(P4CoreUtils.getAllChildren((IContainer)resource));
                } else if (resource instanceof IFile) {
                    files.add((IFile)resource);
                }
                ++n2;
            }
        }
        return files;
    }

    public static List<IFile> getAllChildren(IContainer container) {
        List<Object> files = null;
        if (container != null) {
            try {
                files = P4CoreUtils.getAllFiles(container.members());
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
                files = new ArrayList();
            }
        } else {
            files = new ArrayList();
        }
        return files;
    }

    public static void copyFile(File source, File destination) throws Exception {
        FileInputStream stream = null;
        OutputStream output = null;
        try {
            stream = new FileInputStream(source);
            if (stream != null) {
                output = new FileOutputStream(destination);
                byte[] buffer = new byte[8192];
                int len = -1;
                while ((len = stream.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                    output.flush();
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
    }

    public static File createFile(InputStream stream) {
        File file;
        block23: {
            file = null;
            if (stream != null) {
                Channel streamChannel = null;
                Channel fileChannel = null;
                try {
                    try {
                        file = File.createTempFile("p4ws", ".tmp");
                        file.deleteOnExit();
                        FileOutputStream output = new FileOutputStream(file);
                        streamChannel = Channels.newChannel(stream);
                        fileChannel = Channels.newChannel(output);
                        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
                        while (streamChannel.read(buffer) != -1) {
                            buffer.flip();
                            fileChannel.write(buffer);
                            buffer.compact();
                        }
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            fileChannel.write(buffer);
                        }
                    }
                    catch (IOException e) {
                        PerforceProviderPlugin.logError(e);
                        if (streamChannel != null) {
                            try {
                                streamChannel.close();
                            }
                            catch (IOException e2) {
                                PerforceProviderPlugin.logError(e2);
                            }
                        }
                        if (fileChannel == null) break block23;
                        try {
                            fileChannel.close();
                        }
                        catch (IOException e3) {
                            PerforceProviderPlugin.logError(e3);
                        }
                    }
                }
                finally {
                    if (streamChannel != null) {
                        try {
                            streamChannel.close();
                        }
                        catch (IOException e) {
                            PerforceProviderPlugin.logError(e);
                        }
                    }
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (IOException e) {
                            PerforceProviderPlugin.logError(e);
                        }
                    }
                }
            }
        }
        return file;
    }

    protected static void getResourceFiles(IResource resource, List<IFile> files) {
        if (resource instanceof IFile) {
            if (!files.contains(resource)) {
                files.add((IFile)resource);
            }
        } else if (resource instanceof IContainer) {
            try {
                IResource[] members = ((IContainer)resource).members();
                int i = 0;
                while (i < members.length) {
                    P4CoreUtils.getResourceFiles(members[i], files);
                    ++i;
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    public static IFile[] getResourceFiles(IResource[] resources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        int i = 0;
        while (i < resources.length) {
            P4CoreUtils.getResourceFiles(resources[i], files);
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static String removeWhitespace(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(value.toString());
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) < ' ') {
                buffer.setCharAt(i, ' ');
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static void deleteEmptyParentDir(File file) {
        if (file == null) {
            return;
        }
        String p = file.getParent();
        if (p != null) {
            File d = new File(p);
            if (!d.exists()) {
                P4CoreUtils.deleteEmptyParentDir(d);
                return;
            }
            String[] c = d.list();
            if (c != null && c.length == 0 && d.delete()) {
                P4CoreUtils.deleteEmptyParentDir(d);
            }
        }
    }

    public static int getRandomInt() {
        return Math.abs(rand.nextInt(Integer.MAX_VALUE));
    }

    public static List<IFileSpec> extractFileSpecs(IP4Connection connection, Map<String, Object>[] results) throws P4JavaException {
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (results != null) {
            Map<String, Object>[] mapArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> map = mapArray[n2];
                IFileSpec spec = P4CoreUtils.extractFileSpec(map, connection);
                if (spec != null) {
                    specList.add(spec);
                }
                ++n2;
            }
        }
        return specList;
    }

    public static List<IFileSpec> extractFileSpecs(IP4Connection connection, List<Map<String, Object>> results) throws P4JavaException {
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (results != null) {
            for (Map<String, Object> map : results) {
                IFileSpec spec = P4CoreUtils.extractFileSpec(map, connection);
                if (spec == null) continue;
                specList.add(spec);
            }
        }
        return specList;
    }

    public static IFileSpec extractFileSpec(Map<String, Object> map, IP4Connection connection) throws P4JavaException {
        if (map.get("submittedChange") != null) {
            Integer id = new Integer((String)map.get("submittedChange"));
            FileSpec spec = new FileSpec(FileSpecOpStatus.INFO, "Submitted as change " + id);
            return spec;
        }
        Server server = (Server)connection.getServer();
        IFileSpec spec = server.handleFileReturn(map, connection.getClient());
        return spec;
    }

    public static P4ProgressListener createStreamCallback(IP4Connection connection, CmdSpec cmd, IProgressMonitor monitor) {
        return P4CoreUtils.createStreamCallback(connection, cmd.name().toLowerCase(), monitor);
    }

    public static P4ProgressListener createStreamCallback(IP4Connection connection, String cmdName, IProgressMonitor monitor) {
        P4ProgressListener handler = new P4ProgressListener(cmdName, connection);
        ProgressMonitorProgressPresenter presenter = new ProgressMonitorProgressPresenter();
        presenter.setMonitor(monitor);
        handler.setPresenter(presenter);
        return handler;
    }

    public static String printMap(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(String.valueOf(entry.getKey()) + ",");
            sb.append(entry.getValue() + "; ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String getFileSpecsActionReport(List<IFileSpec> specs) {
        HashMap<FileAction, Integer> summary = new HashMap<FileAction, Integer>();
        for (IFileSpec spec : specs) {
            if (spec.getOpStatus() != FileSpecOpStatus.VALID) continue;
            FileAction action = spec.getAction();
            if (!summary.containsKey(action)) {
                summary.put(action, 0);
            }
            summary.put(action, (Integer)summary.get(action) + 1);
        }
        StringBuilder sb = new StringBuilder();
        FileAction[] fileActionArray = FileAction.values();
        int n = fileActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileAction act = fileActionArray[n2];
            if (summary.containsKey(act)) {
                sb.append(MessageFormat.format("  {0} files {1}\n", summary.get(act), act.name().toLowerCase()));
            }
            ++n2;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static int[] getVersion(String serverInfo) {
        int[] result = new int[2];
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)serverInfo));
        String[] list = serverInfo.split("/", 4);
        Pattern reg = Pattern.compile("\\d{4}.\\d.*");
        if (reg.matcher(list[2]).matches()) {
            String[] versions = list[2].split("\\.");
            result[0] = Integer.parseInt(versions[0]);
            result[1] = Integer.parseInt(versions[1]);
        }
        return result;
    }

    public static Charset charsetForName(String name) {
        try {
            return Charset.forName(name);
        }
        catch (Exception e) {
            PerforceProviderPlugin.logWarning(e);
            return CharsetDefs.DEFAULT;
        }
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        if (obj1 == obj2) {
            return true;
        }
        return obj1.equals(obj2);
    }
}

