/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.timelapse.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class FolderTimeLapseInput
extends PlatformObject
implements IEditorInput {
    private IContainer container;
    private IP4Folder folder;

    public FolderTimeLapseInput(IP4Folder folder) {
        this(folder, null);
    }

    public FolderTimeLapseInput(IP4Folder folder, IContainer container) {
        this.folder = folder;
        this.container = container;
    }

    public IP4Folder getFolder() {
        return this.folder;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PerforceUIPlugin.getPlugin().getImageDescriptor("normal/time_lapse.png");
    }

    public String getName() {
        String name = this.folder.getName();
        if (name == null && this.container != null) {
            name = this.container.getName();
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return MessageFormat.format(Messages.FolderTimeLapseInput_Tooltip, this.folder.getActionPath());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContainer.class) {
            if (this.container != null) {
                return this.container;
            }
            IContainer[] containers = this.folder.getLocalContainers();
            if (containers != null && containers.length > 0) {
                return containers[0];
            }
        }
        return super.getAdapter(adapter);
    }
}

