/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4ChangelistRevision;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.timelapse.FileEntry;
import com.perforce.team.ui.folder.timelapse.FolderEntry;
import com.perforce.team.ui.folder.timelapse.FolderLabelDecorator;
import com.perforce.team.ui.folder.timelapse.FolderLabelProvider;
import com.perforce.team.ui.folder.timelapse.FolderTickDecorator;
import com.perforce.team.ui.folder.timelapse.FolderTickFormatter;
import com.perforce.team.ui.folder.timelapse.FolderTimeLapseInput;
import com.perforce.team.ui.folder.timelapse.IEntry;
import com.perforce.team.ui.folder.timelapse.Messages;
import com.perforce.team.ui.folder.timelapse.RootEntry;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import com.perforce.team.ui.timelapse.ITickDecorator;
import com.perforce.team.ui.timelapse.ITickFormatter;
import com.perforce.team.ui.timelapse.TimeLapseChangelistWidget;
import com.perforce.team.ui.timelapse.TimeLapseSlider;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class FolderTimeLapseEditor
extends EditorPart {
    public static final String ID = "com.perforce.team.ui.folder.timelapse.FolderTimeLapseEditor";
    public static final String SHOW_INCREMENTAL = "com.perforce.team.ui.text.timelapse.folder.SHOW_INCREMENTAL";
    private static final int[] SASH_WEIGHTS = new int[]{80, 20};
    private SashForm displayArea;
    private Composite loadingArea;
    private Composite mainArea;
    private Composite outer;
    private SashForm sash;
    private Composite viewerArea1;
    private Label viewerLabel1;
    private TreeViewer viewer;
    private Composite viewerArea2;
    private Label viewerLabel2;
    private TreeViewer viewer2;
    private FolderLabelDecorator folderDecorator1;
    private FolderLabelDecorator folderDecorator2;
    private FolderLabelProvider styleProvider;
    private FolderLabelProvider styleProvider2;
    private TimeLapseSlider slider;
    private ToolItem upItem;
    private ToolItem homeItem;
    private SashForm changelistSash;
    private TimeLapseChangelistWidget changelistArea;
    private TimeLapseChangelistWidget changelistArea2;
    private FolderTickDecorator decorator;
    private FolderTickFormatter formatter;
    private Color formatterBg = null;
    private IP4Revision revision = null;
    private IP4Revision revision2 = null;
    private IP4Revision[] history;
    private IAnnotateModel.Type type = IAnnotateModel.Type.REVISION;
    private boolean showActions = false;
    private boolean settingInput = false;
    private boolean settingSelection1 = false;
    private boolean settingSelection2 = false;
    private boolean showIncremental = false;
    private RootEntry rootFolder = null;
    private FolderEntry currentFolder = null;
    private Map<String, FileEntry> allFiles;
    private Set<Integer> aheads;
    private String root;

    public Composite getControl() {
        return this.displayArea;
    }

    protected IP4Revision getRevision() {
        return this.revision;
    }

    protected IP4Revision[] getRevisions() {
        return this.history;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FolderTimeLapseInput)) {
            throw new PartInitException("Wrong input type, must be TimeLapseInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.showActions = store.getBoolean("com.perforce.team.ui.timelapse.SHOW_FILE_ACTIONS");
        this.showIncremental = store.getBoolean(SHOW_INCREMENTAL);
        this.formatterBg = new Color((Device)P4UIUtils.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.perforce.team.ui.text.timelapse.TICK_CHANGE_COLOR"));
        P4UIUtils.registerDisposal((Widget)this.getControl(), (Resource)this.formatterBg);
    }

    private IP4Folder getFolder() {
        return ((FolderTimeLapseInput)this.getEditorInput()).getFolder();
    }

    private void startEditorLoad(final Runnable uiCallback) {
        final IP4Folder folder = this.getFolder();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.FolderTimeLapseEditor_LoadingTimelapseViewFor, folder.getActionPath());
            }

            public void run(IProgressMonitor monitor) {
                FolderTimeLapseEditor.this.loadEditor(folder, monitor);
                if (FolderTimeLapseEditor.this.history != null && uiCallback != null) {
                    PerforceUIPlugin.syncExec((Runnable)uiCallback);
                }
            }
        });
    }

    public boolean isLoading() {
        return this.loadingArea == ((StackLayout)this.outer.getLayout()).topControl;
    }

    private IP4ChangelistRevision[] getHistory(IP4Folder folder) {
        if (folder == null) {
            return new IP4ChangelistRevision[0];
        }
        return folder.getCompleteHistory((IProgressMonitor)new NullProgressMonitor());
    }

    protected void loadEditor(IP4Folder folder, IProgressMonitor monitor) {
        this.root = folder.getRemotePath();
        if (this.root == null) {
            this.root = folder.getFirstWhereRemotePath();
            if (this.root != null) {
                folder = folder.getConnection().getFolder(this.root, true);
            }
        }
        Object[] allHistory = this.getHistory(folder);
        monitor.setTaskName(Messages.FolderTimeLapseEditor_LoadingHistory);
        Arrays.sort(allHistory);
        HashMap<String, Integer> haveMap = new HashMap<String, Integer>();
        if (folder != null) {
            try {
                List haves;
                IClient client;
                IP4Connection conn = folder.getConnection();
                if (conn != null && (client = conn.getClient()) != null && (haves = client.haveList(P4FileSpecBuilder.makeFileSpecList((String)folder.getActionPath()))) != null) {
                    for (IFileSpec spec : haves) {
                        int have = spec.getEndRevision();
                        haveMap.put(spec.getDepotPathString(), have);
                    }
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        this.allFiles = new HashMap<String, FileEntry>();
        this.aheads = new HashSet<Integer>();
        this.history = allHistory;
        this.rootFolder = new RootEntry(this.history);
        this.currentFolder = this.rootFolder;
        HashMap<String, FolderEntry> folders = new HashMap<String, FolderEntry>();
        Object[] objectArray = allHistory;
        int n = allHistory.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevisionData[] revisions;
            Object revision = objectArray[n2];
            IFileRevisionData[] iFileRevisionDataArray = revisions = revision.getRevisions();
            int n3 = revisions.length;
            int n4 = 0;
            while (n4 < n3) {
                IFileRevisionData file = iFileRevisionDataArray[n4];
                String path = file.getDepotFileName();
                if (this.root != null && path.startsWith(this.root)) {
                    String shortened = path.substring(this.root.length() + 1);
                    FileEntry fileToAdd = null;
                    if (!this.allFiles.containsKey(path)) {
                        if (shortened.lastIndexOf(47) == -1) {
                            fileToAdd = new FileEntry(file, this.rootFolder, this.rootFolder);
                        } else {
                            String parentPath = shortened.substring(0, shortened.lastIndexOf(47));
                            FolderEntry parent = this.loadFolder(parentPath, folders);
                            fileToAdd = new FileEntry(file, parent, this.rootFolder);
                        }
                        this.allFiles.put(path, fileToAdd);
                    } else {
                        fileToAdd = this.allFiles.get(path);
                    }
                    fileToAdd.add(file);
                    if (haveMap.containsKey(path)) {
                        int have = (Integer)haveMap.get(path);
                        fileToAdd.setHaveRevision(have);
                        if (have < file.getRevision()) {
                            this.aheads.add(file.getChangelistId());
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.rootFolder.complete();
    }

    private FolderEntry loadFolder(String path, Map<String, FolderEntry> folders) {
        FolderEntry folder = null;
        if (folders.containsKey(path)) {
            return folders.get(path);
        }
        if (path.indexOf(47) == -1) {
            if (folders.containsKey(path)) {
                folder = folders.get(path);
            } else {
                folder = new FolderEntry(path, this.rootFolder);
                folder.setRoot(this.rootFolder);
                folders.put(path, folder);
            }
        } else {
            String parentPath = path.substring(0, path.lastIndexOf(47));
            FolderEntry parent = null;
            parent = folders.containsKey(parentPath) ? folders.get(parentPath) : this.loadFolder(parentPath, folders);
            String name = path.substring(parentPath.length() + 1);
            folder = new FolderEntry(name, parent);
            folder.setRoot(this.rootFolder);
            folders.put(path, folder);
        }
        return folder;
    }

    private void displayLoading() {
        ((StackLayout)this.outer.getLayout()).topControl = this.loadingArea;
        this.outer.layout(true, true);
    }

    private void displayEditor() {
        GridLayout maLayout = new GridLayout(1, true);
        maLayout.marginHeight = 0;
        maLayout.marginWidth = 0;
        maLayout.verticalSpacing = 2;
        this.mainArea = new Composite((Composite)this.displayArea, 0);
        this.mainArea.setLayout((Layout)maLayout);
        this.mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.slider = this.createSlider(this.mainArea, this.getFolder());
        this.configureSlider(this.slider);
        this.fillToolbar(this.slider.getToolbar());
        this.createHeader(this.mainArea);
        this.createViewer(this.mainArea);
        this.changelistSash = new SashForm((Composite)this.displayArea, 256);
        GridLayout csLayout = new GridLayout(1, true);
        csLayout.marginHeight = 0;
        csLayout.marginWidth = 0;
        this.changelistSash.setLayout((Layout)csLayout);
        this.changelistSash.setLayoutData((Object)new GridData(4, 4, true, false));
        this.changelistArea = new TimeLapseChangelistWidget((Composite)this.changelistSash);
        this.changelistArea2 = new TimeLapseChangelistWidget((Composite)this.changelistSash);
        this.displayArea.setWeights(SASH_WEIGHTS);
        this.updateSplit();
        boolean showChangelist = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.timelapse.SHOW_CHANGELIST");
        if (showChangelist) {
            this.displayArea.setMaximizedControl(null);
        } else {
            this.displayArea.setMaximizedControl((Control)this.mainArea);
        }
        this.showEditor();
    }

    private void showEditor() {
        ((StackLayout)this.outer.getLayout()).topControl = this.displayArea;
        this.outer.layout(true, true);
    }

    protected TimeLapseSlider getSlider() {
        return this.slider;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private TimeLapseSlider createSlider(Composite parent, IP4Folder folder) {
        TimeLapseSlider slider = new TimeLapseSlider(this.history, new IAnnotateModel.Type[]{IAnnotateModel.Type.CHANGELIST, IAnnotateModel.Type.DATE});
        slider.setDrawDecorations(true);
        slider.createControl(parent);
        slider.setListener(new TimeLapseSlider.IRevisionListener(){

            public void revisionChanged(IP4Revision revision) {
                FolderTimeLapseEditor.this.showRevision(revision);
            }

            public void displayChanged(IAnnotateModel.Type type) {
                FolderTimeLapseEditor.this.updateDisplay(type);
            }
        });
        return slider;
    }

    protected void updateDisplay(IAnnotateModel.Type type) {
        this.type = type;
    }

    protected IAnnotateModel.Type getDisplayType() {
        return this.type;
    }

    public boolean isSettingInput() {
        return this.settingInput;
    }

    private void showRevision(IP4Revision newRevision) {
        if (newRevision != this.revision2) {
            this.settingInput = true;
            try {
                this.revision2 = newRevision;
                int index = Arrays.binarySearch(this.history, this.revision2) - 1;
                this.revision = index > -1 ? this.history[index] : newRevision;
                this.viewerLabel1.setText(MessageFormat.format(Messages.FolderTimeLapseEditor_ChangelistNum, this.revision.getChangelist()));
                this.viewerLabel2.setText(MessageFormat.format(Messages.FolderTimeLapseEditor_ChangelistNum, this.revision2.getChangelist()));
                if (this.displayArea.getMaximizedControl() == null) {
                    this.changelistArea.showRevision(this.revision);
                    this.changelistArea2.showRevision(this.revision2);
                }
                this.styleProvider.setRevision(this.revision, this.root);
                this.folderDecorator1.setRevision(this.revision);
                this.styleProvider2.setRevision(this.revision2, this.root);
                this.folderDecorator2.setRevision(this.revision2);
                ISelection selection = this.viewer.getSelection();
                this.setCurrentFolder(this.currentFolder);
                if (!selection.isEmpty() && !selection.equals(this.viewer.getSelection())) {
                    this.formatter.setFile(null);
                    this.decorator.setFile(null);
                    this.getSlider().redraw();
                    this.getSlider().update();
                }
            }
            finally {
                this.settingInput = false;
            }
        }
    }

    protected void dispose(IEditorInput input) {
    }

    public void dispose() {
        super.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    private void setImage() {
        ImageDescriptor descriptor = this.getEditorInput().getImageDescriptor();
        if (descriptor != null) {
            Image editorImage = descriptor.createImage();
            this.setTitleImage(editorImage);
            P4UIUtils.registerDisposal((Widget)this.displayArea, (Resource)editorImage);
        }
    }

    private void createLoadingArea(Composite parent) {
        this.loadingArea = new Composite(parent, 0);
        ((StackLayout)parent.getLayout()).topControl = this.loadingArea;
        this.loadingArea.setLayout((Layout)new GridLayout(1, true));
        this.loadingArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label loadingLabel = new Label(this.loadingArea, 0);
        loadingLabel.setText(Messages.FolderTimeLapseEditor_LoadingTimelapseView);
        ProgressBar loadingBar = new ProgressBar(this.loadingArea, 258);
        loadingBar.setLayoutData((Object)new GridData(4, 4, true, false));
        loadingBar.setEnabled(true);
    }

    protected void createHeader(Composite parent) {
    }

    public void createPartControl(Composite parent) {
        this.setImage();
        this.setPartName(((FolderTimeLapseInput)this.getEditorInput()).getName());
        this.outer = new Composite(parent, 0);
        StackLayout oLayout = new StackLayout();
        oLayout.marginHeight = 0;
        oLayout.marginWidth = 0;
        this.outer.setLayout((Layout)oLayout);
        this.outer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLoadingArea(this.outer);
        this.displayArea = new SashForm(this.outer, 512);
        this.displayArea.setBackground(this.displayArea.getDisplay().getSystemColor(16));
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.startEditorLoad(new Runnable(){

            @Override
            public void run() {
                if (!FolderTimeLapseEditor.this.displayArea.isDisposed()) {
                    FolderTimeLapseEditor.this.preUpdateEditor();
                    FolderTimeLapseEditor.this.displayEditor();
                    FolderTimeLapseEditor.this.updateEditor();
                    FolderTimeLapseEditor.this.showRevision(FolderTimeLapseEditor.this.history[FolderTimeLapseEditor.this.history.length - 1]);
                }
            }
        });
    }

    private IP4Revision findRevision(IP4Revision revision) {
        if (revision != null) {
            IP4Revision[] revisions = this.getRevisions();
            int i = 0;
            while (i < revisions.length) {
                if (revision.getContentIdentifier().equals(revisions[i].getContentIdentifier())) {
                    return revisions[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected void configureSlider(TimeLapseSlider slider) {
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        this.decorator = new FolderTickDecorator();
        this.formatter = new FolderTickFormatter();
        this.formatter.setColor(this.formatterBg);
        this.formatter.setAheads(this.aheads);
        slider.setFormatter((ITickFormatter)this.formatter);
        slider.setDecorator((ITickDecorator)this.decorator);
    }

    protected void fillToolbar(ToolBar toolbar) {
        final ToolItem changelistItem = new ToolItem(toolbar, 32);
        Image submittedImage = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/submitted.png").createImage();
        P4UIUtils.registerDisposal((Widget)changelistItem, (Resource)submittedImage);
        changelistItem.setToolTipText(Messages.FolderTimeLapseEditor_DisplayRevisionDetails);
        changelistItem.setImage(submittedImage);
        changelistItem.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.timelapse.SHOW_CHANGELIST"));
        changelistItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (changelistItem.getSelection()) {
                    FolderTimeLapseEditor.this.changelistArea.showRevision(FolderTimeLapseEditor.this.getRevision());
                    FolderTimeLapseEditor.this.displayArea.setMaximizedControl(null);
                } else {
                    FolderTimeLapseEditor.this.displayArea.setMaximizedControl((Control)FolderTimeLapseEditor.this.mainArea);
                }
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.timelapse.SHOW_CHANGELIST", changelistItem.getSelection());
            }
        });
        final ToolItem actionsItem = new ToolItem(toolbar, 32);
        Image actionsImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/show_actions.png").createImage();
        P4UIUtils.registerDisposal((Widget)actionsItem, (Resource)actionsImage);
        actionsItem.setToolTipText(Messages.FolderTimeLapseEditor_DisplayActionIcons);
        actionsItem.setImage(actionsImage);
        actionsItem.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.timelapse.SHOW_FILE_ACTIONS"));
        actionsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderTimeLapseEditor.this.showActions = actionsItem.getSelection();
                FolderTimeLapseEditor.this.getSlider().setDrawDecorations(FolderTimeLapseEditor.this.showActions);
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.timelapse.SHOW_FILE_ACTIONS", FolderTimeLapseEditor.this.showActions);
            }
        });
        ToolItem clearItem = new ToolItem(toolbar, 8);
        Image clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        P4UIUtils.registerDisposal((Widget)clearItem, (Resource)clearImage);
        clearItem.setToolTipText(Messages.FolderTimeLapseEditor_ClearSelection);
        clearItem.setImage(clearImage);
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderTimeLapseEditor.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                FolderTimeLapseEditor.this.decorator.setFile(null);
                FolderTimeLapseEditor.this.formatter.setFile(null);
                FolderTimeLapseEditor.this.getSlider().redraw();
                FolderTimeLapseEditor.this.getSlider().update();
            }
        });
        this.homeItem = new ToolItem(toolbar, 8);
        Image homeImage = PerforceUiTextPlugin.getImageDescriptor((String)"icons/home.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.homeItem, (Resource)homeImage);
        this.homeItem.setToolTipText(Messages.FolderTimeLapseEditor_GoToRootFolder);
        this.homeItem.setImage(homeImage);
        this.homeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderTimeLapseEditor.this.setCurrentFolder(FolderTimeLapseEditor.this.rootFolder);
            }
        });
        this.upItem = new ToolItem(toolbar, 8);
        Image upImage = PerforceUiTextPlugin.getImageDescriptor((String)"icons/up.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.upItem, (Resource)upImage);
        this.upItem.setToolTipText(Messages.FolderTimeLapseEditor_GoUpOneLevel);
        this.upItem.setImage(upImage);
        this.upItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object parent;
                if (FolderTimeLapseEditor.this.currentFolder != FolderTimeLapseEditor.this.rootFolder && (parent = FolderTimeLapseEditor.this.currentFolder.getParent(FolderTimeLapseEditor.this.currentFolder)) != null) {
                    FolderTimeLapseEditor.this.setCurrentFolder((FolderEntry)parent);
                }
            }
        });
        final ToolItem splitItem = new ToolItem(toolbar, 32);
        Image splitImage = PerforceUiTextPlugin.getImageDescriptor((String)"icons/split.png").createImage();
        P4UIUtils.registerDisposal((Widget)splitItem, (Resource)splitImage);
        splitItem.setToolTipText(Messages.FolderTimeLapseEditor_IncrementalFolderComparison);
        splitItem.setImage(splitImage);
        splitItem.setSelection(this.showIncremental);
        splitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderTimeLapseEditor.this.showIncremental = splitItem.getSelection();
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(FolderTimeLapseEditor.SHOW_INCREMENTAL, FolderTimeLapseEditor.this.showIncremental);
                FolderTimeLapseEditor.this.updateSplit();
            }
        });
    }

    private void updateSplit() {
        ((GridData)this.viewerLabel1.getLayoutData()).exclude = !this.showIncremental;
        this.viewerLabel1.setVisible(this.showIncremental);
        ((GridData)this.viewerLabel2.getLayoutData()).exclude = !this.showIncremental;
        this.viewerLabel2.setVisible(this.showIncremental);
        if (this.showIncremental) {
            this.sash.setMaximizedControl(null);
            this.changelistSash.setMaximizedControl(null);
        } else {
            this.sash.setMaximizedControl((Control)this.viewerArea2);
            this.changelistSash.setMaximizedControl(this.changelistArea2.getControl());
        }
        this.sash.layout(true, true);
    }

    private void setCurrentFolder(FolderEntry folder) {
        this.currentFolder = folder;
        this.homeItem.setEnabled(this.currentFolder != this.rootFolder);
        this.upItem.setEnabled(this.currentFolder.getParent(this.currentFolder) != null);
        Object[] children = this.currentFolder.getChildren(folder);
        this.viewer.setInput((Object)children);
        this.viewer2.setInput((Object)children);
    }

    protected void createViewer(Composite parent) {
        this.sash = new SashForm(parent, 256);
        GridLayout sLayout = new GridLayout(1, true);
        sLayout.marginHeight = 0;
        sLayout.marginWidth = 0;
        this.sash.setLayout((Layout)sLayout);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerArea1 = new Composite((Composite)this.sash, 0);
        GridLayout va1Layout = new GridLayout(1, true);
        va1Layout.marginHeight = 0;
        va1Layout.marginWidth = 0;
        va1Layout.verticalSpacing = 0;
        this.viewerArea1.setLayout((Layout)va1Layout);
        this.viewerArea1.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerLabel1 = new Label(this.viewerArea1, 0);
        this.viewerLabel1.setLayoutData((Object)new GridData(4, 4, true, false));
        this.viewerLabel1.setText(Messages.FolderTimeLapseEditor_Changelist);
        this.viewer = new TreeViewer(this.viewerArea1, 2820);
        this.viewer.setContentProvider((IContentProvider)new PerforceContentProvider((StructuredViewer)this.viewer, true));
        this.styleProvider = new FolderLabelProvider();
        this.folderDecorator1 = new FolderLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.styleProvider, (ILabelDecorator)this.folderDecorator1, null));
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FolderTimeLapseEditor.this.settingSelection1 = true;
                try {
                    IStructuredSelection selection = (IStructuredSelection)FolderTimeLapseEditor.this.viewer.getSelection();
                    if (!FolderTimeLapseEditor.this.settingSelection2) {
                        FolderTimeLapseEditor.this.viewer2.setSelection((ISelection)selection);
                    }
                    if (selection.size() == 1) {
                        Object first = selection.getFirstElement();
                        if (first instanceof FileEntry) {
                            FolderTimeLapseEditor.this.decorator.setFile((FileEntry)first);
                            FolderTimeLapseEditor.this.formatter.setFile((FileEntry)first);
                        } else {
                            FolderTimeLapseEditor.this.decorator.setFile(null);
                            FolderTimeLapseEditor.this.formatter.setFile(null);
                        }
                        FolderTimeLapseEditor.this.getSlider().redraw();
                        FolderTimeLapseEditor.this.getSlider().update();
                    }
                }
                finally {
                    FolderTimeLapseEditor.this.settingSelection1 = false;
                }
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IEntry) {
                    IFileRevisionData data;
                    IEntry entry = (IEntry)element;
                    if (entry.getFirst() > FolderTimeLapseEditor.this.revision.getChangelist()) {
                        return false;
                    }
                    if (entry instanceof FileEntry && (data = ((FileEntry)entry).getData(FolderTimeLapseEditor.this.revision.getChangelist())) != null && P4File.isActionDelete((FileAction)data.getAction()) && data.getChangelistId() < FolderTimeLapseEditor.this.revision.getChangelist()) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object first;
                IStructuredSelection selection = (IStructuredSelection)FolderTimeLapseEditor.this.viewer.getSelection();
                if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof FolderEntry) {
                    FolderTimeLapseEditor.this.setCurrentFolder((FolderEntry)first);
                }
            }
        });
        this.viewerArea2 = new Composite((Composite)this.sash, 0);
        GridLayout va2Layout = new GridLayout(1, true);
        va2Layout.marginHeight = 0;
        va2Layout.marginWidth = 0;
        va2Layout.verticalSpacing = 0;
        this.viewerArea2.setLayout((Layout)va2Layout);
        this.viewerArea2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerLabel2 = new Label(this.viewerArea2, 0);
        this.viewerLabel2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.viewerLabel2.setText(Messages.FolderTimeLapseEditor_Changelist);
        this.viewer2 = new TreeViewer(this.viewerArea2, 2820);
        this.viewer2.setContentProvider((IContentProvider)new PerforceContentProvider((StructuredViewer)this.viewer2, true));
        this.styleProvider2 = new FolderLabelProvider();
        this.folderDecorator2 = new FolderLabelDecorator();
        this.viewer2.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.styleProvider2, (ILabelDecorator)this.folderDecorator2, null));
        this.viewer2.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer2.setAutoExpandLevel(-1);
        this.viewer2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FolderTimeLapseEditor.this.settingSelection2 = true;
                try {
                    IStructuredSelection selection = (IStructuredSelection)FolderTimeLapseEditor.this.viewer2.getSelection();
                    if (!FolderTimeLapseEditor.this.settingSelection1) {
                        FolderTimeLapseEditor.this.viewer.setSelection((ISelection)selection);
                    }
                    if (selection.size() == 1) {
                        Object first = selection.getFirstElement();
                        if (first instanceof FileEntry) {
                            FolderTimeLapseEditor.this.decorator.setFile((FileEntry)first);
                            FolderTimeLapseEditor.this.formatter.setFile((FileEntry)first);
                        } else {
                            FolderTimeLapseEditor.this.decorator.setFile(null);
                            FolderTimeLapseEditor.this.formatter.setFile(null);
                        }
                        FolderTimeLapseEditor.this.getSlider().redraw();
                        FolderTimeLapseEditor.this.getSlider().update();
                    }
                }
                finally {
                    FolderTimeLapseEditor.this.settingSelection2 = false;
                }
            }
        });
        this.viewer2.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IEntry) {
                    IFileRevisionData data;
                    IEntry entry = (IEntry)element;
                    if (entry.getFirst() > FolderTimeLapseEditor.this.revision2.getChangelist()) {
                        return false;
                    }
                    if (entry instanceof FileEntry && (data = ((FileEntry)entry).getData(FolderTimeLapseEditor.this.revision2.getChangelist())) != null && P4File.isActionDelete((FileAction)data.getAction()) && data.getChangelistId() < FolderTimeLapseEditor.this.revision2.getChangelist()) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.viewer2.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object first;
                IStructuredSelection selection = (IStructuredSelection)FolderTimeLapseEditor.this.viewer2.getSelection();
                if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof FolderEntry) {
                    FolderTimeLapseEditor.this.setCurrentFolder((FolderEntry)first);
                }
            }
        });
        this.sash.setWeights(new int[]{50, 50});
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    protected void preserveSelectionLoad() {
        this.displayLoading();
        this.startEditorLoad(new Runnable(){

            @Override
            public void run() {
                if (!FolderTimeLapseEditor.this.displayArea.isDisposed()) {
                    IP4Revision newRevision = FolderTimeLapseEditor.this.findRevision(FolderTimeLapseEditor.this.getRevision());
                    FolderTimeLapseEditor.this.preUpdateEditor();
                    FolderTimeLapseEditor.this.configureSlider(FolderTimeLapseEditor.this.slider);
                    FolderTimeLapseEditor.this.slider.resetRevisions(FolderTimeLapseEditor.this.history, newRevision);
                    if (newRevision != null) {
                        FolderTimeLapseEditor.this.showRevision(newRevision);
                    } else {
                        FolderTimeLapseEditor.this.showRevision(FolderTimeLapseEditor.this.history[FolderTimeLapseEditor.this.history.length - 1]);
                    }
                    FolderTimeLapseEditor.this.showEditor();
                    FolderTimeLapseEditor.this.updateEditor();
                }
            }
        });
    }

    protected void preUpdateEditor() {
    }

    protected void updateEditor() {
    }
}

