/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.folder.timelapse.FolderEntry;
import com.perforce.team.ui.folder.timelapse.IEntry;
import com.perforce.team.ui.folder.timelapse.RootEntry;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileEntry
implements IWorkbenchAdapter,
Comparable<IWorkbenchAdapter>,
IEntry {
    private SortedMap<Integer, IFileRevisionData> data;
    private int haveRevision = 0;
    private RootEntry root;
    private FolderEntry parent;
    private String path;
    private String name;

    public FileEntry(IFileRevisionData data, FolderEntry parent, RootEntry root) {
        this.root = root;
        this.data = new TreeMap<Integer, IFileRevisionData>();
        this.parent = parent;
        this.path = data.getDepotFileName();
        int index = this.path.lastIndexOf(47);
        if (index >= 0 && index + 1 < this.path.length()) {
            this.name = this.path.substring(index + 1);
        }
        this.add(data);
        this.parent.add(this);
    }

    public void setHaveRevision(int revision) {
        this.haveRevision = revision;
    }

    public int getHaveRevision() {
        return this.haveRevision;
    }

    @Override
    public int getFirst() {
        return ((IFileRevisionData)this.data.get(this.data.firstKey())).getChangelistId();
    }

    public IFileRevisionData getLast() {
        return (IFileRevisionData)this.data.get(this.data.lastKey());
    }

    public IFileRevisionData getData(int changelist) {
        return (IFileRevisionData)this.data.get(changelist);
    }

    public boolean isSynced(int changelist) {
        boolean synced = true;
        IFileRevisionData data = (IFileRevisionData)this.data.get(changelist);
        if (data != null) {
            synced = this.haveRevision >= data.getRevision();
        }
        return synced;
    }

    public void add(IFileRevisionData revision) {
        if (revision != null && this.path.equals(revision.getDepotFileName())) {
            this.parent.updateMoveStatus(this, revision);
            int id = revision.getChangelistId();
            IP4Revision[] revisions = this.getRevisions();
            int i = revisions.length - 1;
            while (i >= 0) {
                int revId = revisions[i].getChangelist();
                if (id > revId) break;
                IFileRevisionData current = (IFileRevisionData)this.data.get(revId);
                if (current == null) {
                    this.data.put(revId, revision);
                } else {
                    if (id <= current.getChangelistId()) break;
                    this.data.put(revId, revision);
                }
                --i;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileEntry) {
            FileEntry other = (FileEntry)obj;
            return this.path.equals(other.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public Object[] getChildren(Object o) {
        return PerforceContentProvider.EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.name);
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    @Override
    public int compareTo(IWorkbenchAdapter o) {
        return this.getLabel(this).compareToIgnoreCase(o.getLabel((Object)o));
    }

    @Override
    public void complete() {
    }

    @Override
    public IP4Revision[] getRevisions() {
        return this.root.getRevisions();
    }

    public String getPath() {
        return this.path;
    }
}

