/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import com.perforce.team.ui.folder.diff.model.FileEntry;
import com.perforce.team.ui.folder.diff.viewer.DiffArea;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LinkCanvas
implements IPropertyChangeListener {
    private Image buffer;
    private DiffArea leftArea;
    private DiffArea rightArea;
    private Tree leftTree;
    private Tree rightTree;
    private TreeItem leftSelected;
    private TreeItem rightSelected;
    private int maxY = -1;
    private Canvas canvas;
    private boolean enabled = true;
    private Map<TreeItem, Pair> settings = new LinkedHashMap<TreeItem, Pair>();
    private FileDiffContainer container;

    public LinkCanvas(Composite parent) {
        this.canvas = new Canvas(parent, 0x20080000);
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LinkCanvas.this.dispose();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point size = LinkCanvas.this.canvas.getSize();
                if (LinkCanvas.this.buffer != null) {
                    Rectangle r = LinkCanvas.this.buffer.getBounds();
                    if (r.width != size.x || r.height != size.y) {
                        LinkCanvas.this.buffer.dispose();
                        LinkCanvas.this.buffer = null;
                    }
                }
                if (LinkCanvas.this.buffer == null) {
                    LinkCanvas.this.buffer = new Image((Device)e.display, size.x, size.y);
                }
                GC gc = new GC((Drawable)LinkCanvas.this.buffer);
                try {
                    gc.setBackground(e.gc.getBackground());
                    gc.fillRectangle(0, 0, size.x, size.y);
                    LinkCanvas.this.paint(gc);
                    e.gc.drawImage(LinkCanvas.this.buffer, 0, 0);
                }
                finally {
                    gc.dispose();
                }
            }
        });
        GridData data = GridDataFactory.swtDefaults().hint(this.getCenterWidth(), -1).grab(false, true).align(1, 4).create();
        this.canvas.setLayoutData((Object)data);
        PerforceUiFolderPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setContainer(FileDiffContainer container) {
        this.container = container;
    }

    private void dispose() {
        PerforceUiFolderPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public Canvas getControl() {
        return this.canvas;
    }

    protected int getCenterWidth() {
        return 34;
    }

    private void paintPair(Pair pair, int leftOffset, int rightOffset, int x1, int x2, GC g) {
        Rectangle leftBounds = pair.left.getBounds();
        Rectangle rightBounds = pair.right.getBounds();
        int y1 = leftBounds.y + leftOffset + 1;
        int y2 = rightBounds.y + rightOffset + 1;
        int h1 = leftBounds.height;
        int h2 = rightBounds.height;
        int control = (x2 - x1) / 2;
        Path path = new Path(g.getDevice());
        try {
            path.moveTo((float)x1, (float)y1);
            path.cubicTo((float)control, (float)y1, (float)control, (float)y2, (float)x2, (float)y2);
            path.lineTo((float)x2, (float)(y2 + h2));
            path.cubicTo((float)control, (float)(y2 + h2), (float)control, (float)(y1 + h1), (float)x1, (float)(y1 + h1));
            path.lineTo((float)x1, (float)y1);
            g.setBackground(pair.getBackground());
            g.fillPath(path);
        }
        finally {
            path.dispose();
        }
    }

    private void paint(GC g) {
        int ro;
        if (!this.enabled) {
            return;
        }
        if (this.settings.isEmpty()) {
            return;
        }
        g.setLineWidth(0);
        int x1 = 0;
        int x2 = this.canvas.getSize().x;
        int leftOffset = this.leftArea.getTreeOffset();
        int rightOffset = this.rightArea.getTreeOffset();
        if (this.maxY == -1) {
            this.updateClipping();
        }
        int lo = leftOffset > 0 ? leftOffset : 0;
        int n = ro = rightOffset > 0 ? rightOffset : 0;
        if (this.maxY != -1) {
            g.setClipping(x1, Math.max(lo, ro), x2, this.maxY);
        }
        lo += this.leftTree.getLocation().y;
        ro += this.rightTree.getLocation().y;
        Pair last = null;
        for (Pair setting : this.settings.values()) {
            this.paintPair(setting, lo, ro, x1, x2, g);
            if (!setting.isSelected()) continue;
            last = setting;
        }
        if (last != null) {
            this.paintPair(last, lo, ro, x1, x2, g);
        }
    }

    private void updateClipping() {
        this.maxY = this.leftTree.getParent().getParent().getSize().y;
    }

    public void setDiffAreas(DiffArea left, DiffArea right) {
        if (this.leftArea != null) {
            return;
        }
        this.leftArea = left;
        this.rightArea = right;
        TreeViewer leftViewer = left.getViewer().getViewer();
        TreeViewer rightViewer = right.getViewer().getViewer();
        this.leftTree = leftViewer.getTree();
        this.rightTree = rightViewer.getTree();
        this.refresh();
        this.leftTree.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LinkCanvas.this.updateClipping();
            }
        });
        TreeListener expansionListener = new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                LinkCanvas.this.refresh();
            }

            public void treeCollapsed(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(false);
                LinkCanvas.this.refresh();
            }
        };
        this.leftTree.addTreeListener(expansionListener);
        this.rightTree.addTreeListener(expansionListener);
        ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinkCanvas.this.updateSelection();
                LinkCanvas.this.redraw();
            }
        };
        leftViewer.addPostSelectionChangedListener(postSelectionListener);
        rightViewer.addPostSelectionChangedListener(postSelectionListener);
    }

    private void updateSelection() {
        TreeItem[] selected = this.leftTree.getSelection();
        this.leftSelected = selected.length == 0 ? null : selected[0];
        selected = this.rightTree.getSelection();
        this.rightSelected = selected.length == 0 ? null : selected[0];
    }

    public void refresh() {
        if (this.leftTree != null) {
            this.settings.clear();
            this.updateItems(this.leftTree.getItems(), this.rightArea.getViewer().getViewer(), true);
            this.updateItems(this.rightTree.getItems(), this.leftArea.getViewer().getViewer(), false);
            this.redraw();
        }
    }

    private void getPair(TreeViewer viewer, TreeItem sourceItem, Object element, ItemSettings setting) {
        if (element == null) {
            return;
        }
        setting.item = (TreeItem)viewer.testFindItem(element);
        if (setting.item != null) {
            if (setting.noPair && element instanceof IP4DiffFile) {
                setting.item = this.getLastItem(setting.item);
            }
        } else if (element instanceof FileDiffElement) {
            setting.noPair = true;
            this.findUniqueDiffPair(viewer, sourceItem, element, setting);
        }
    }

    private ItemSettings getTreeItemPair(TreeItem item) {
        Pair pair;
        if (item != null && (pair = this.settings.get(item)) != null) {
            if (item.getParent() == pair.left.item.getParent()) {
                return pair.right;
            }
            return pair.left;
        }
        return null;
    }

    private void findUniqueDiffPair(TreeViewer viewer, TreeItem item, Object element, ItemSettings setting) {
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            int index = parent.indexOf(item);
            if (index > 0) {
                item = parent.getItem(index - 1);
                ItemSettings pairSetting = this.getTreeItemPair(item);
                if (pairSetting != null) {
                    setting.item = pairSetting.item;
                    if (!pairSetting.noPair) {
                        setting.item = this.getLastItem(setting.item);
                    }
                }
                if (setting.item == null) {
                    element = this.getDataPair(item.getData(), setting);
                    this.getPair(viewer, item, element, setting);
                }
            } else {
                item = parent;
                ItemSettings pairSetting = this.getTreeItemPair(item);
                if (pairSetting != null) {
                    setting.item = pairSetting.item;
                }
                if (setting.item == null && (element = this.getDataPair(item.getData(), setting)) != null) {
                    setting.item = (TreeItem)viewer.testFindItem(element);
                }
            }
        }
    }

    private TreeItem getLastItem(TreeItem parent) {
        if (parent == null) {
            return null;
        }
        TreeItem lastChild = parent;
        int count = parent.getItemCount();
        if (parent.getExpanded() && count > 0) {
            lastChild = this.getLastItem(parent.getItem(count - 1));
        }
        return lastChild;
    }

    private Object getDataPair(Object data, ItemSettings setting) {
        Object pair = null;
        if (data instanceof IP4DiffFile) {
            IP4DiffFile diff = (IP4DiffFile)data;
            pair = ((IP4DiffFile)data).getPair();
            if (pair == null && this.container != null) {
                FileEntry entry = this.container.getEntry(diff);
                pair = entry.getProvider().getUniquePair(entry);
                setting.noPair = true;
            }
        } else if (data instanceof FileDiffElement) {
            pair = data;
        }
        return pair;
    }

    private void updateItems(TreeItem[] items, TreeViewer viewer, boolean sourceItems) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof IP4DiffFile || data instanceof FileDiffElement) {
                Pair match = new Pair(sourceItems);
                ItemSettings setting = sourceItems ? match.right : match.left;
                this.getPair(viewer, item, this.getDataPair(data, setting), setting);
                if (sourceItems) {
                    match.left.item = item;
                } else {
                    match.right.item = item;
                }
                if (match.isValid()) {
                    if (sourceItems) {
                        this.settings.put(match.left.item, match);
                    } else {
                        this.settings.put(match.right.item, match);
                    }
                }
            }
            if (item.getExpanded()) {
                this.updateItems(item.getItems(), viewer, sourceItems);
            }
            ++n2;
        }
    }

    public void redraw() {
        this.canvas.redraw();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("CONTENT_COLOR".equals(event.getProperty()) || "DIFF_CONTENT_COLOR".equals(event.getProperty())) {
            PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (P4UIUtils.okToUse((Widget)LinkCanvas.this.canvas)) {
                        LinkCanvas.this.redraw();
                    }
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static class ItemSettings {
        Rectangle bounds = null;
        boolean noPair = false;
        TreeItem item;

        private ItemSettings() {
        }

        private Rectangle getBounds(TreeItem item) {
            if (this.bounds == null) {
                Rectangle newBounds = item.getBounds();
                if (newBounds.height <= 0 && (item = item.getParentItem()) != null) {
                    newBounds = this.getBounds(item);
                }
                if (this.noPair) {
                    newBounds.y += newBounds.height;
                    newBounds.height = 1;
                }
                this.bounds = newBounds;
            }
            return this.bounds;
        }

        Rectangle getBounds() {
            return this.getBounds(this.item);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ItemSettings) {
                return this.item.getData().equals(((ItemSettings)obj).item.getData());
            }
            return false;
        }

        public int hashCode() {
            if (this.item.getData() != null) {
                return this.item.getData().hashCode();
            }
            return super.hashCode();
        }
    }

    private class Pair {
        boolean source = true;
        ItemSettings left = new ItemSettings();
        ItemSettings right = new ItemSettings();

        public Pair(boolean source) {
            this.source = source;
        }

        public boolean isValid() {
            return this.left.item != null && this.right.item != null && this.left.item.getParent() != this.right.item.getParent();
        }

        public boolean isSelected() {
            if (!this.left.noPair && !this.right.noPair) {
                return LinkCanvas.this.leftSelected == this.left.item && LinkCanvas.this.rightSelected == this.right.item;
            }
            if (this.left.noPair) {
                return LinkCanvas.this.rightSelected == this.right.item;
            }
            if (this.right.noPair) {
                return LinkCanvas.this.leftSelected == this.left.item;
            }
            return false;
        }

        public Color getBackground() {
            if (this.isSelected()) {
                return this.left.item.getDisplay().getSystemColor(26);
            }
            if (this.source) {
                return this.left.item.getBackground(0);
            }
            return this.right.item.getBackground(0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Pair) {
                return this.left.equals(((Pair)obj).left) && this.right.equals(((Pair)obj).right) && super.equals(obj);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            if (this.left != null) {
                hash += this.left.hashCode();
            }
            if (this.right != null) {
                hash += this.right.hashCode() * 31;
            }
            if (hash > 0) {
                return hash;
            }
            return super.hashCode();
        }
    }
}

