/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.actions.DiffCompareAction;
import com.perforce.team.ui.folder.diff.actions.DiffOpenAction;
import com.perforce.team.ui.folder.diff.editor.FileDiffContentProvider;
import com.perforce.team.ui.folder.diff.editor.LinkCanvas;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.folder.diff.editor.Resizer;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.IFileDiffContainerProvider;
import com.perforce.team.ui.folder.diff.model.IFolderDiffListener;
import com.perforce.team.ui.folder.diff.viewer.DiffViewer;
import com.perforce.team.ui.folder.diff.viewer.SourceArea;
import com.perforce.team.ui.folder.diff.viewer.SynchronizedDiffer;
import com.perforce.team.ui.folder.diff.viewer.TargetArea;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FolderDiffPage
extends FormPage
implements IFileDiffContainerProvider {
    private Composite body;
    private Text descriptionText;
    private SourceArea leftArea;
    private LinkCanvas canvas;
    private TargetArea rightArea;
    private Folder.Type type = Folder.Type.FLAT;
    private FileDiffContainer container;
    private IAction flatMode;
    private IAction treeMode;
    private IAction compressedMode;
    private IAction showIdenticalPairs;
    private IAction showContentPairs;
    private IAction showUniquePairs;
    private IAction compareMode;
    private IAction refresh;
    private IAction prefPage;
    private ListenerList listeners;
    private ISchedulingRule rule = P4Runner.createRule();

    public FolderDiffPage(FormEditor editor) {
        super(editor, "folderDiffPage", Messages.FolderDiffPage_Title);
        this.listeners = new ListenerList();
        this.createActions();
    }

    @Override
    public FileDiffContainer getContainer() {
        return this.container;
    }

    @Override
    public void addListener(IFolderDiffListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    @Override
    public void removeListener(IFolderDiffListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.body = managedForm.getForm().getBody();
        this.body.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).margins(2, 2).spacing(0, 2).create());
        FormToolkit toolkit = managedForm.getToolkit();
        this.descriptionText = new Text(this.body, 72);
        toolkit.adapt((Control)this.descriptionText, false, false);
        this.descriptionText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create());
        Composite displayArea = toolkit.createComposite(this.body);
        displayArea.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).spacing(0, 0).create());
        Composite left = toolkit.createComposite(displayArea);
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        left.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        this.canvas = new LinkCanvas(displayArea);
        toolkit.adapt((Control)this.canvas.getControl(), false, false);
        Composite right = toolkit.createComposite(displayArea);
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        right.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        new Resizer(left, (Composite)this.canvas.getControl(), right);
        IFolderDiffInput input = this.getDiffInput();
        this.leftArea = new SourceArea();
        this.leftArea.createControl(left, toolkit, input, input.getLeftConfiguration());
        this.rightArea = new TargetArea();
        this.rightArea.createControl(right, toolkit, input, input.getRightConfiguration());
        this.leftArea.setPair(this.rightArea);
        this.rightArea.setPair(this.leftArea);
        ExpansionAdapter expansionListener = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                FolderDiffPage.this.leftArea.refreshTreeOffset();
                FolderDiffPage.this.rightArea.refreshTreeOffset();
                FolderDiffPage.this.canvas.redraw();
            }
        };
        this.leftArea.getFilter().getSection().addExpansionListener((IExpansionListener)expansionListener);
        this.rightArea.getFilter().getSection().addExpansionListener((IExpansionListener)expansionListener);
        this.rightArea.getSlider().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderDiffPage.this.canvas.redraw();
            }
        });
        FileDiffContentProvider.IDiffListener listener = new FileDiffContentProvider.IDiffListener(){

            @Override
            public void update(IP4DiffFile file) {
                FolderDiffPage.this.canvas.refresh();
                FolderDiffPage.this.rightArea.getSlider().refresh();
            }

            @Override
            public void load(IP4DiffFile file) {
            }
        };
        ((FileDiffContentProvider)this.leftArea.getViewer().getViewer().getContentProvider()).addDiffListener(listener);
        new SynchronizedDiffer(this.leftArea.getViewer().getViewer(), this.rightArea.getViewer().getViewer());
        this.rightArea.getSlider().addScrollListener((Control)this.canvas.getControl());
        this.addMenu(this.leftArea.getViewer());
        this.hookDoubleClick(this.leftArea.getViewer());
        this.addMenu(this.rightArea.getViewer());
        this.hookDoubleClick(this.rightArea.getViewer());
        Folder.Type initialType = null;
        try {
            initialType = Folder.Type.valueOf((String)PerforceUiFolderPlugin.getDefault().getPreferenceStore().getString("COMPARE_DISPLAY_MODE"));
        }
        catch (Exception e) {
            initialType = null;
        }
        this.setType(initialType);
        switch (this.getType()) {
            case FLAT: {
                this.flatMode.setChecked(true);
                break;
            }
            case TREE: {
                this.treeMode.setChecked(true);
                break;
            }
            case COMPRESSED: {
                this.compressedMode.setChecked(true);
                break;
            }
        }
        this.refreshInput();
    }

    public void loadDifferences() {
        this.canvas.setEnabled(false);
        this.canvas.redraw();
        this.leftArea.getViewer().showLoading();
        this.rightArea.getViewer().showLoading();
        final String leftFilterSpec = this.leftArea.getFilter().getFilterSpec();
        final String rightFilterSpec = this.rightArea.getFilter().getFilterSpec();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IFolderDiffInput input = FolderDiffPage.this.getDiffInput();
                FolderDiffPage.this.container = input.generateDiffs(leftFilterSpec, rightFilterSpec, monitor);
                int identical = FolderDiffPage.this.container.getIdenticalCount();
                int different = FolderDiffPage.this.container.getContentCount();
                String differing = different == 1 ? Messages.FolderDiffPage_SingleDifferingFile : MessageFormat.format(Messages.FolderDiffPage_MultipleDifferingFile, different);
                String same = identical == 1 ? Messages.FolderDiffPage_SingleIdenticalFile : MessageFormat.format(Messages.FolderDiffPage_MultipleIdenticalFiles, identical);
                final String description = String.valueOf(differing) + " " + same;
                PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Widget)FolderDiffPage.this.getPartControl())) {
                            FolderDiffPage.this.descriptionText.setText(description);
                            FolderDiffPage.this.leftArea.setContainer(FolderDiffPage.this.container);
                            FolderDiffPage.this.rightArea.setContainer(FolderDiffPage.this.container);
                            FolderDiffPage.this.canvas.setContainer(FolderDiffPage.this.container);
                            FolderDiffPage.this.leftArea.setFilterExpanded(false);
                            FolderDiffPage.this.rightArea.setFilterExpanded(false);
                            FolderDiffPage.this.canvas.setEnabled(true);
                            FolderDiffPage.this.canvas.setDiffAreas(FolderDiffPage.this.leftArea, FolderDiffPage.this.rightArea);
                            FolderDiffPage.this.rightArea.getSlider().scrollToTop();
                            FolderDiffPage.this.resetSlider();
                        }
                    }
                });
                Object[] objectArray = FolderDiffPage.this.listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IFolderDiffListener)listener).diffsGenerated(FolderDiffPage.this.container);
                    ++n2;
                }
            }

            public String toString() {
                return Messages.FolderDiffPage_LoadingDiffs;
            }
        }, (ISchedulingRule)this.rule);
    }

    private IFolderDiffInput getDiffInput() {
        return (IFolderDiffInput)this.getEditorInput();
    }

    private void addMenu(DiffViewer viewer) {
        MenuManager manager = new MenuManager();
        TreeViewer tViewer = viewer.getViewer();
        P4UIUtils.addStandardPerforceMenus((IMenuManager)manager);
        Menu menu = manager.createContextMenu((Control)tViewer.getTree());
        tViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)tViewer);
    }

    private void hookDoubleClick(final DiffViewer viewer) {
        viewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IP4DiffFile diff = FolderDiffPage.this.getSelectedDiff(viewer);
                if (diff != null) {
                    P4Action action = null;
                    action = FolderDiffPage.this.compareMode.isChecked() && diff.getDiff().getStatus() == IFileDiff.Status.CONTENT ? new DiffCompareAction() : new DiffOpenAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)diff));
                    action.run(null);
                }
            }
        });
    }

    private IP4DiffFile getSelectedDiff(DiffViewer viewer) {
        Object first = ((IStructuredSelection)viewer.getViewer().getSelection()).getFirstElement();
        return (IP4DiffFile)P4CoreUtils.convert((Object)first, IP4DiffFile.class);
    }

    public void setType(Folder.Type type) {
        if (type != this.type) {
            this.type = type;
            PerforceUiFolderPlugin.getDefault().getPreferenceStore().setValue("COMPARE_DISPLAY_MODE", this.type.toString());
            this.leftArea.setType(this.type);
            this.rightArea.setType(this.type);
            this.canvas.refresh();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUiFolderPlugin.getDefault().getPreferenceStore();
    }

    private void resetSlider() {
        this.rightArea.resetSlider();
        this.canvas.refresh();
    }

    private void createActions() {
        this.refresh = new Action(Messages.FolderDiffPage_Refresh, PerforceUIPlugin.getDescriptor((String)"normal/diff.png")){

            public void run() {
                FolderDiffPage.this.loadDifferences();
            }
        };
        this.showContentPairs = new Action(Messages.FolderDiffPage_ShowContentPair, 2){

            public void run() {
                boolean checked = this.isChecked();
                FolderDiffPage.this.leftArea.getViewer().showContentPairs(checked);
                FolderDiffPage.this.rightArea.getViewer().showContentPairs(checked);
                FolderDiffPage.this.resetSlider();
                FolderDiffPage.this.getPreferenceStore().setValue("SHOW_CONTENT", checked);
            }
        };
        this.showContentPairs.setChecked(this.getPreferenceStore().getBoolean("SHOW_CONTENT"));
        this.showContentPairs.setImageDescriptor(PerforceUiFolderPlugin.getDescriptor("icons/filter_content.png"));
        this.showUniquePairs = new Action(Messages.FolderDiffPage_ShowUniqueFiles, 2){

            public void run() {
                boolean checked = this.isChecked();
                FolderDiffPage.this.leftArea.getViewer().showUniquePairs(checked);
                FolderDiffPage.this.rightArea.getViewer().showUniquePairs(checked);
                FolderDiffPage.this.resetSlider();
                FolderDiffPage.this.getPreferenceStore().setValue("SHOW_UNIQUE", checked);
            }
        };
        this.showUniquePairs.setChecked(this.getPreferenceStore().getBoolean("SHOW_UNIQUE"));
        this.showUniquePairs.setImageDescriptor(PerforceUiFolderPlugin.getDescriptor("icons/filter_unique.png"));
        this.showIdenticalPairs = new Action(Messages.FolderDiffPage_ShowIdentical, 2){

            public void run() {
                boolean checked = this.isChecked();
                FolderDiffPage.this.leftArea.getViewer().showIdenticalPairs(checked);
                FolderDiffPage.this.rightArea.getViewer().showIdenticalPairs(checked);
                FolderDiffPage.this.getPreferenceStore().setValue("SHOW_IDENTICAL", checked);
            }
        };
        this.showIdenticalPairs.setChecked(this.getPreferenceStore().getBoolean("SHOW_IDENTICAL"));
        this.showIdenticalPairs.setImageDescriptor(PerforceUiFolderPlugin.getDescriptor("icons/filter_identical.png"));
        this.flatMode = new Action(Messages.FolderDiffPage_FlatMode, 8){

            public void run() {
                FolderDiffPage.this.setType(Folder.Type.FLAT);
            }
        };
        this.flatMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/flat_layout.png"));
        this.treeMode = new Action(Messages.FolderDiffPage_TreeMode, 8){

            public void run() {
                FolderDiffPage.this.setType(Folder.Type.TREE);
            }
        };
        this.treeMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/tree_layout.png"));
        this.compressedMode = new Action(Messages.FolderDiffPage_CompressedMode, 8){

            public void run() {
                FolderDiffPage.this.setType(Folder.Type.COMPRESSED);
            }
        };
        this.compressedMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/compressed_folders_layout.png"));
        this.compareMode = new Action(Messages.FolderDiffPage_CompareMode, 2){

            public void run() {
                PerforceUiFolderPlugin.getDefault().getPreferenceStore().setValue("COMPARE_SELECT_MODE", this.isChecked());
            }
        };
        this.compareMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/compare.png"));
        this.compareMode.setChecked(PerforceUiFolderPlugin.getDefault().getPreferenceStore().getBoolean("COMPARE_SELECT_MODE"));
        this.prefPage = new Action(Messages.FolderDiffPage_OpenPreferences, 1){

            public void run() {
                P4UIUtils.openPreferencePage((String)"com.perforce.team.ui.folder.diffPage");
            }
        };
        this.prefPage.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"views/preferences.png"));
    }

    public Folder.Type getType() {
        return this.type;
    }

    private void refreshInput() {
        final IFolderDiffInput input = this.getDiffInput();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                input.refreshInput(monitor);
                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FolderDiffPage.this.leftArea.updateTitle(input.getLeftConfiguration());
                        FolderDiffPage.this.rightArea.updateTitle(input.getRightConfiguration());
                    }
                });
            }

            public String getTitle() {
                return Messages.FolderDiffPage_RefreshingInput;
            }
        }, (ISchedulingRule)this.rule);
    }

    public void fillToolbar(IToolBarManager toolbar) {
        toolbar.add(this.showUniquePairs);
        toolbar.add(this.showContentPairs);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add(this.flatMode);
        toolbar.add(this.treeMode);
        toolbar.add(this.compressedMode);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add(this.compareMode);
        toolbar.add(this.prefPage);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IContributionItem)new ControlContribution("com.perforce.team.ui.folder.diff.editor.refresh"){

            protected Control createControl(Composite parent) {
                Button button = new Button(parent, 0x800000);
                Image image = FolderDiffPage.this.refresh.getImageDescriptor().createImage();
                P4UIUtils.registerDisposal((Widget)button, (Resource)image);
                button.setImage(image);
                button.setToolTipText(FolderDiffPage.this.refresh.getText());
                button.setText(Messages.FolderDiffPage_GenerateDiffs);
                button.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).minSize(-1, image.getBounds().y).create());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FolderDiffPage.this.refresh.run();
                    }
                });
                return button;
            }
        });
    }
}

