/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping.depot;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IMappingVisitor;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.TextContentAssist;
import com.perforce.team.ui.mergequest.wizards.mapping.MappingArea;
import com.perforce.team.ui.mergequest.wizards.mapping.depot.Messages;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import java.text.MessageFormat;
import java.util.TreeSet;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DepotPathArea
extends MappingArea {
    public static final int MIN_DEPOT_PATH_LENGTH = 5;
    private String name = null;
    private String sourcePath = null;
    private String targetPath = null;
    private Composite displayArea;
    private Text nameText;
    private Text sourcePathText;
    private Text targetPathText;

    public DepotPathArea(IBranchGraph graph, IP4Connection connection) {
        super(graph, connection);
    }

    @Override
    public Mapping createMapping() {
        DepotPathMapping mapping = this.graph.createDepotPathMapping(null);
        mapping.setName(this.name);
        mapping.setSourcePath(this.sourcePath);
        mapping.setTargetPath(this.targetPath);
        mapping.setDirection(this.getDirection());
        return mapping;
    }

    @Override
    protected String validateArea() {
        String message = null;
        this.name = this.nameText.getText().trim();
        this.sourcePath = this.sourcePathText.getText().trim();
        this.targetPath = this.targetPathText.getText().trim();
        if (message == null && this.name.length() == 0) {
            message = Messages.DepotPathArea_EnterMappingName;
        }
        if (message == null && this.sourcePath.length() == 0) {
            message = Messages.DepotPathArea_EnterSourcePath;
        }
        if (message == null && this.targetPath.length() == 0) {
            message = Messages.DepotPathArea_EnterTargetPath;
        }
        if (message == null && !this.sourcePath.startsWith("//")) {
            message = Messages.DepotPathArea_SourcePathStartsWith;
        }
        if (message == null && !this.targetPath.startsWith("//")) {
            message = Messages.DepotPathArea_TargetPathStartsWith;
        }
        if (message == null && this.sourcePath.length() < 5) {
            message = Messages.DepotPathArea_ValidSourcePath;
        }
        if (message == null && this.targetPath.length() < 5) {
            message = Messages.DepotPathArea_ValidTargetPath;
        }
        if (message == null && this.checkNameExists(this.name, this.source, true)) {
            message = MessageFormat.format(Messages.DepotPathArea_NameInUse, this.source.getName());
        }
        if (message == null && this.checkNameExists(this.name, this.target, false)) {
            message = MessageFormat.format(Messages.DepotPathArea_NameInUse, this.target.getName());
        }
        if (message == null && this.sourcePath.equals(this.targetPath)) {
            message = Messages.DepotPathArea_PathsCannotBeSame;
        }
        return message;
    }

    private void createNameArea(Composite parent) {
        Composite nameArea = new Composite(parent, 0);
        GridLayout naLayout = new GridLayout(2, false);
        naLayout.marginHeight = 0;
        naLayout.marginWidth = 0;
        nameArea.setLayout((Layout)naLayout);
        nameArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label nameLabel = new Label(nameArea, 16384);
        nameLabel.setText(Messages.DepotPathArea_MappingName);
        this.nameText = new Text(nameArea, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DepotPathArea.this.validate();
            }
        });
    }

    private String getDefaultPath(Branch branch) {
        final String[] defaultPath = new String[1];
        IMappingVisitor visitor = new IMappingVisitor(){

            public boolean visit(Mapping mapping, Branch branch) {
                String candidate;
                String string = candidate = branch.equals((Object)mapping.getSource()) ? ((DepotPathMapping)mapping).getSourcePath() : ((DepotPathMapping)mapping).getTargetPath();
                if (defaultPath[0] == null) {
                    defaultPath[0] = candidate;
                } else if (!defaultPath[0].equals(candidate)) {
                    defaultPath[0] = null;
                    return false;
                }
                return true;
            }
        };
        branch.accept(visitor, "depotPath", true, true);
        return defaultPath[0];
    }

    private void fillDefaults() {
        String defaultSourcePath = null;
        String defaultTargetPath = null;
        String name = null;
        DepotPathMapping depotMapping = (DepotPathMapping)this.mapping;
        if (depotMapping != null) {
            defaultSourcePath = depotMapping.getSourcePath();
            defaultTargetPath = depotMapping.getTargetPath();
            name = depotMapping.getName();
        }
        if (defaultSourcePath == null && this.source != null) {
            defaultSourcePath = this.getDefaultPath(this.source);
        }
        if (defaultTargetPath == null && this.target != null) {
            defaultTargetPath = this.getDefaultPath(this.target);
        }
        if (name == null && this.source != null && this.target != null) {
            String baseName = MessageFormat.format(Messages.DepotPathArea_DefaultName, this.source.getName(), this.target.getName());
            int suffix = 1;
            name = baseName;
            while (this.source.getSourceMappingByName(name) != null || this.target.getTargetMappingByName(name) != null) {
                name = MessageFormat.format(Messages.DepotPathArea_NameCollision, baseName, Integer.toString(suffix));
                ++suffix;
            }
        }
        if (name == null) {
            name = "";
        }
        if (defaultSourcePath == null) {
            defaultSourcePath = "";
        }
        if (defaultTargetPath == null) {
            defaultTargetPath = "";
        }
        this.targetPathText.setText(defaultTargetPath);
        this.sourcePathText.setText(defaultSourcePath);
        this.nameText.setText(name);
        this.nameText.selectAll();
    }

    private void createDepotViewArea(Composite parent) {
        this.createNameArea(parent);
        Group sourceArea = new Group(parent, 0);
        sourceArea.setText(Messages.DepotPathArea_Source);
        GridLayout saLayout = new GridLayout(1, true);
        sourceArea.setLayout((Layout)saLayout);
        sourceArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sourcePathText = this.createPathArea((Composite)sourceArea);
        this.createDirectionArea(parent, 256);
        Group targetArea = new Group(parent, 0);
        targetArea.setText(Messages.DepotPathArea_Target);
        GridLayout taLayout = new GridLayout(1, true);
        targetArea.setLayout((Layout)taLayout);
        targetArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetPathText = this.createPathArea((Composite)targetArea);
        this.createSourceBranchArea((Composite)sourceArea, Messages.DepotPathArea_BranchName);
        this.createTargetBranchArea((Composite)targetArea, Messages.DepotPathArea_BranchName);
        TreeSet<String> depotPaths = new TreeSet<String>();
        Mapping[] mappingArray = this.graph.getMappings();
        int n = mappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray[n2];
            if (mapping instanceof DepotPathMapping) {
                DepotPathMapping depotMapping = (DepotPathMapping)mapping;
                depotPaths.add(depotMapping.getSourcePath());
                depotPaths.add(depotMapping.getTargetPath());
            }
            ++n2;
        }
        String[] assistItems = depotPaths.toArray(new String[depotPaths.size()]);
        if (assistItems.length > 0) {
            DepotPathArea.addContentAssistDecoration((Control)this.sourcePathText);
            DepotPathArea.addContentAssistDecoration((Control)this.targetPathText);
        }
        new TextContentAssist(this.sourcePathText, assistItems);
        new TextContentAssist(this.targetPathText, assistItems);
    }

    private Text createPathArea(Composite parent) {
        Composite sourcePathArea = new Composite(parent, 0);
        GridLayout spaLayout = new GridLayout(3, false);
        spaLayout.marginHeight = 0;
        spaLayout.marginHeight = 0;
        sourcePathArea.setLayout((Layout)spaLayout);
        sourcePathArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label sourcePathLabel = new Label(sourcePathArea, 0);
        sourcePathLabel.setText(Messages.DepotPathArea_DepotPath);
        Text text = new Text(sourcePathArea, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DepotPathArea.this.validate();
            }
        });
        ToolBar sourceBar = new ToolBar(sourcePathArea, 0x800000);
        ToolItem sourceItem = new ToolItem(sourceBar, 8);
        Image image = this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/find.png"));
        sourceItem.setImage(image);
        this.configureBrowseButton(sourceItem, text);
        return text;
    }

    private void configureBrowseButton(ToolItem browse, final Text field) {
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionPath;
                IP4Resource resource;
                if (DepotPathArea.this.connection == null) {
                    return;
                }
                ResourceBrowserDialog dialog = new ResourceBrowserDialog(field.getShell(), DepotPathArea.this.connection.members());
                if (dialog.open() == 0 && (resource = dialog.getSelectedResource()) != null && (actionPath = resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                    field.setText(actionPath);
                }
            }
        });
    }

    @Override
    public void createControl(Composite parent, IWizardContainer container) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DepotPathArea.this.resources.dispose();
            }
        });
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        daLayout.verticalSpacing = 2;
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.createDepotViewArea(this.displayArea);
        this.fillDefaults();
    }
}

