/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping.branch;

import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.NewBranchAction;
import com.perforce.team.ui.branches.SelectBranchDialog;
import com.perforce.team.ui.mergequest.wizards.mapping.MappingArea;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.BranchAssistant;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class BranchArea
extends MappingArea {
    private Composite branchArea;
    private ITextViewer branchText;
    private BranchAssistant branchNameAssist;
    private ISourceViewer sourceViewer;
    private ISourceViewer targetViewer;
    private String name = null;
    private boolean inSesssion = false;
    private ISchedulingRule loadRule = P4Runner.createRule();

    public BranchArea(IBranchGraph graph, IP4Connection connection) {
        super(graph, connection);
    }

    @Override
    public String validateArea() {
        String message = null;
        this.name = this.branchText.getDocument().get().trim();
        if (message == null && this.name.length() == 0) {
            message = Messages.BranchArea_EnterSpecName;
        }
        return message;
    }

    public BranchAssistant getAssistant() {
        return this.branchNameAssist;
    }

    @Override
    public void createControl(Composite parent, IWizardContainer container) {
        this.branchArea = new Composite(parent, 0);
        GridLayout bvaLayout = new GridLayout(4, false);
        bvaLayout.marginHeight = 0;
        bvaLayout.marginWidth = 0;
        this.branchArea.setLayout((Layout)bvaLayout);
        this.branchArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.branchArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BranchArea.this.resources.dispose();
            }
        });
        this.createBranchViewArea(this.branchArea, container);
        this.branchText.getTextWidget().selectAll();
        this.branchText.getTextWidget().setFocus();
    }

    private SourceViewer createPathArea(Composite parent, String label) {
        Composite targetPaths = new Composite(parent, 0);
        GridLayout tpLayout = new GridLayout(1, true);
        tpLayout.marginHeight = 0;
        tpLayout.marginWidth = 0;
        tpLayout.verticalSpacing = 0;
        targetPaths.setLayout((Layout)tpLayout);
        targetPaths.setLayoutData((Object)new GridData(4, 4, true, true));
        Label targetPathLabel = new Label(targetPaths, 0);
        targetPathLabel.setText(label);
        targetPathLabel.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        final Color alternate = new Color((Device)parent.getDisplay(), new RGB(232, 242, 254));
        P4UIUtils.registerDisposal((Widget)parent, (Resource)alternate);
        final SourceViewer targetViewer = new SourceViewer(targetPaths, null, 778);
        targetViewer.setDocument((IDocument)new Document());
        targetViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        targetViewer.getTextWidget().addLineBackgroundListener(new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                Color background = null;
                try {
                    int lineNumber = targetViewer.getDocument().getLineOfOffset(event.lineOffset);
                    if (lineNumber % 2 != 0) {
                        background = alternate;
                    }
                }
                catch (BadLocationException badLocationException) {}
                event.lineBackground = background;
            }
        });
        targetViewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                if (event.lineText != null && event.lineText.length() > 0 && event.lineText.charAt(0) == '-') {
                    StyleRange range = new StyleRange(event.lineOffset, event.lineText.length(), event.display.getSystemColor(4), null);
                    event.styles = new StyleRange[]{range};
                }
            }
        });
        GridData tvData = new GridData(4, 4, true, true);
        tvData.verticalIndent = 2;
        tvData.heightHint = P4UIUtils.computePixelHeight((Font)targetViewer.getTextWidget().getFont(), (int)10);
        targetViewer.getTextWidget().setLayoutData((Object)tvData);
        return targetViewer;
    }

    private void createBranchViewArea(Composite parent, final IWizardContainer container) {
        Label nameLabel = new Label(parent, 16384);
        nameLabel.setText(Messages.BranchArea_BranchSpecName);
        this.branchText = new TextViewer(parent, 2052);
        BranchArea.addContentAssistDecoration((Control)this.branchText.getTextWidget());
        this.branchText.setDocument((IDocument)new Document());
        GridData btData = new GridData(4, 4, true, false);
        this.branchText.getTextWidget().setLayoutData((Object)btData);
        this.branchText.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                BranchArea.this.validate();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.branchText.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (!BranchArea.this.inSesssion && Character.isWhitespace(event.character)) {
                    event.doit = false;
                }
            }
        });
        this.branchNameAssist = new BranchAssistant(this.resources, this.connection, new Runnable(){

            @Override
            public void run() {
                BranchArea.this.loadView(BranchArea.this.branchText.getDocument().get());
            }
        });
        this.branchNameAssist.addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                BranchArea.this.inSesssion = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                BranchArea.this.inSesssion = false;
            }
        });
        this.branchNameAssist.init();
        this.branchNameAssist.install(this.branchText);
        ToolBar branchBar = new ToolBar(parent, 0x800040);
        ToolItem refreshButton = new ToolItem(branchBar, 8);
        refreshButton.setImage(this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/refresh.png")));
        refreshButton.setToolTipText(Messages.BranchArea_LoadViewToolTip);
        final ToolItem browseButton = new ToolItem(branchBar, 8);
        browseButton.setImage(this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/find.png")));
        browseButton.setToolTipText(Messages.BranchArea_Browse);
        ToolItem newButton = new ToolItem(branchBar, 8);
        newButton.setImage(this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/add.png")));
        newButton.setToolTipText(Messages.BranchArea_New);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final IP4Branch[] created = new IP4Branch[1];
                    container.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            NewBranchAction newAction = new NewBranchAction();
                            newAction.setAsync(false);
                            newAction.setMonitor(monitor);
                            newAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)BranchArea.this.connection));
                            newAction.run(null);
                            created[0] = newAction.getCreatedBranch();
                        }
                    });
                    if (created[0] != null) {
                        BranchArea.this.branchText.getDocument().set(created[0].getName());
                        BranchArea.this.setView(created[0]);
                    }
                }
                catch (InvocationTargetException e1) {
                    PerforceProviderPlugin.logError((Throwable)e1);
                }
                catch (InterruptedException e1) {
                    PerforceProviderPlugin.logError((Throwable)e1);
                }
            }
        });
        Composite paths = new Composite(parent, 0);
        GridLayout pLayout = new GridLayout(3, false);
        pLayout.marginWidth = 0;
        pLayout.marginHeight = 0;
        pLayout.horizontalSpacing = 1;
        paths.setLayout((Layout)pLayout);
        GridData pData = new GridData(4, 4, true, true);
        pData.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        paths.setLayoutData((Object)pData);
        Group sourceArea = new Group(paths, 0);
        sourceArea.setText(Messages.BranchArea_Source);
        GridLayout saLayout = new GridLayout(1, true);
        saLayout.marginHeight = 2;
        saLayout.marginWidth = 2;
        sourceArea.setLayout((Layout)saLayout);
        sourceArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sourceViewer = this.createPathArea((Composite)sourceArea, Messages.BranchArea_DepotPaths);
        this.createDirectionArea(paths, 512);
        Group targetArea = new Group(paths, 2048);
        targetArea.setText(Messages.BranchArea_Target);
        GridLayout taLayout = new GridLayout(1, true);
        taLayout.marginHeight = 2;
        taLayout.marginWidth = 2;
        targetArea.setLayout((Layout)taLayout);
        targetArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetViewer = this.createPathArea((Composite)targetArea, Messages.BranchArea_DepotPaths);
        this.createSourceBranchArea((Composite)sourceArea, Messages.BranchArea_BranchName);
        this.createTargetBranchArea((Composite)targetArea, Messages.BranchArea_BranchName);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchArea.this.loadView(BranchArea.this.branchText.getDocument().get());
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Branch selected;
                SelectBranchDialog dialog = new SelectBranchDialog(browseButton.getParent().getShell(), BranchArea.this.connection);
                if (dialog.open() == 0 && (selected = dialog.getSelected()) != null && selected.getName() != null) {
                    BranchArea.this.branchText.getDocument().set(selected.getName());
                    BranchArea.this.validate();
                    BranchArea.this.setView(selected);
                }
            }
        });
        this.loadCurrentMapping();
    }

    protected void loadCurrentMapping() {
        String name;
        if (this.mapping != null && (name = this.mapping.getName()) != null && name.length() > 0) {
            this.branchText.getDocument().set(name);
            this.loadView(name);
        }
    }

    private void loadView(final String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.BranchArea_LoadingSpec, name);
            }

            public void run(IProgressMonitor monitor) {
                final IP4Branch branch = BranchArea.this.connection.getBranch(name);
                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Widget)BranchArea.this.branchArea)) {
                            BranchArea.this.setView(branch);
                        }
                    }
                });
            }
        }, (ISchedulingRule)this.loadRule);
    }

    private void setView(IP4Branch branch) {
        if (branch != null && branch.getName() != null && branch.getUpdateTime() != null) {
            StringBuilder source = new StringBuilder();
            StringBuilder target = new StringBuilder();
            ViewMap mappings = branch.getView();
            if (mappings != null) {
                for (IBranchMapping mapping : mappings) {
                    if (mapping.getType() == IMapEntry.EntryType.EXCLUDE) {
                        source.append('-');
                        target.append('-');
                    }
                    source.append(mapping.getLeft(true));
                    source.append('\n');
                    target.append(mapping.getRight(true));
                    target.append('\n');
                }
            }
            this.sourceViewer.getDocument().set(source.toString());
            this.targetViewer.getDocument().set(target.toString());
        } else {
            this.sourceViewer.getDocument().set("");
            this.targetViewer.getDocument().set("");
        }
    }

    public Composite getControl() {
        return this.branchArea;
    }

    @Override
    public Mapping createMapping() {
        BranchSpecMapping mapping = this.graph.createBranchSpecMapping(null);
        mapping.setName(this.name);
        mapping.setDirection(this.getDirection());
        return mapping;
    }
}

