/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.mergequest.BranchGraphUtils;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.BranchNameArea;
import com.perforce.team.ui.mergequest.wizards.mapping.IMappingArea;
import com.perforce.team.ui.mergequest.wizards.mapping.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class MappingArea
extends BaseErrorProvider
implements IMappingArea {
    protected IBranchGraph graph;
    protected IP4Connection connection;
    protected Branch source;
    protected Branch target;
    protected BranchDescriptor sourceDescriptor = null;
    protected BranchDescriptor targetDescriptor = null;
    protected BranchNameArea sourceArea = null;
    protected BranchNameArea targetArea = null;
    protected Mapping mapping;
    protected Mapping.Direction direction = Mapping.Direction.BOTH;
    protected SharedResources resources = new SharedResources();

    public static void addContentAssistDecoration(Control control) {
        BranchGraphUtils.addContentAssistDecoration(control);
    }

    public MappingArea(IBranchGraph graph, IP4Connection connection) {
        this.graph = graph;
        this.connection = connection;
    }

    @Override
    public void setExistingMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    protected boolean checkNameExists(String name, Branch branch, boolean source) {
        boolean exists = false;
        if (name != null && branch != null) {
            Mapping found = null;
            found = source ? branch.getSourceMappingByName(name) : branch.getTargetMappingByName(name);
            if (found != null) {
                exists = this.mapping == null ? true : !found.equals((Object)this.mapping);
            }
        }
        return exists;
    }

    protected abstract String validateArea();

    @Override
    public abstract Mapping createMapping();

    public final void validate() {
        String message = this.validateArea();
        if (message == null && this.source == null) {
            if (this.sourceDescriptor.getName().length() == 0) {
                message = Messages.MappingArea_EnterSourceName;
            } else if (BranchType.UNKNOWN.equals((Object)this.sourceDescriptor.getType())) {
                message = Messages.MappingArea_SelectSourceBranchType;
            }
        }
        if (message == null && this.target == null) {
            if (this.targetDescriptor.getName().length() == 0) {
                message = Messages.MappingArea_EnterTargetName;
            } else if (BranchType.UNKNOWN.equals((Object)this.targetDescriptor.getType())) {
                message = Messages.MappingArea_SelectTargetBranchType;
            }
        }
        if (message == null && this.sourceDescriptor.getName().equals(this.targetDescriptor.getName())) {
            message = Messages.MappingArea_SourceAndTargetMustDiffer;
        }
        this.errorMessage = message;
        super.validate();
    }

    @Override
    public void setSource(Branch source) {
        this.source = source;
    }

    @Override
    public void setTarget(Branch target) {
        this.target = target;
    }

    protected void createSourceBranchArea(Composite parent, String label) {
        this.sourceArea = this.createBranchArea(parent, label, this.source);
        this.sourceDescriptor = this.sourceArea.getDescriptor();
    }

    protected void createTargetBranchArea(Composite parent, String label) {
        this.targetArea = this.createBranchArea(parent, label, this.target);
        this.targetDescriptor = this.targetArea.getDescriptor();
    }

    protected BranchNameArea createBranchArea(Composite parent, String label, Branch branch) {
        BranchNameArea nameArea = new BranchNameArea(this.resources, this.graph, this);
        nameArea.createControl(parent, label, branch);
        nameArea.initContentAssist();
        if (this.mapping != null) {
            nameArea.setEditable(false);
        }
        return nameArea;
    }

    protected Control createDirectionArea(Composite parent, int style) {
        ToolBar toolbar = new ToolBar(parent, 0x800000 | style);
        final ToolItem sourceToTargetItem = new ToolItem(toolbar, 16);
        sourceToTargetItem.setToolTipText(Messages.MappingArea_SourceToTarget);
        final ToolItem biItem = new ToolItem(toolbar, 16);
        biItem.setToolTipText(Messages.MappingArea_BothDirections);
        final ToolItem targetToSourceItem = new ToolItem(toolbar, 16);
        targetToSourceItem.setToolTipText(Messages.MappingArea_TargetToSource);
        if ((style & 0x200) != 0) {
            sourceToTargetItem.setImage(this.resources.getImage("icons/arrow_right.png"));
            targetToSourceItem.setImage(this.resources.getImage("icons/arrow_left.png"));
            biItem.setImage(this.resources.getImage("icons/arrow_both.png"));
            toolbar.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        } else {
            sourceToTargetItem.setImage(this.resources.getImage("icons/arrow_down.png"));
            targetToSourceItem.setImage(this.resources.getImage("icons/arrow_up.png"));
            biItem.setImage(this.resources.getImage("icons/arrow_both_ns.png"));
            toolbar.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        }
        if (this.mapping != null) {
            this.direction = this.mapping.getDirection();
            switch (this.direction) {
                case SOURCE: {
                    targetToSourceItem.setSelection(true);
                    break;
                }
                case TARGET: {
                    sourceToTargetItem.setSelection(true);
                    break;
                }
                case BOTH: {
                    biItem.setSelection(true);
                    break;
                }
            }
        } else {
            biItem.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (sourceToTargetItem.getSelection()) {
                    MappingArea.this.direction = Mapping.Direction.TARGET;
                } else if (targetToSourceItem.getSelection()) {
                    MappingArea.this.direction = Mapping.Direction.SOURCE;
                } else if (biItem.getSelection()) {
                    MappingArea.this.direction = Mapping.Direction.BOTH;
                }
            }
        };
        sourceToTargetItem.addSelectionListener((SelectionListener)selectionListener);
        biItem.addSelectionListener((SelectionListener)selectionListener);
        targetToSourceItem.addSelectionListener((SelectionListener)selectionListener);
        return toolbar;
    }

    @Override
    public BranchDescriptor getSourceDescriptor() {
        return this.sourceDescriptor;
    }

    @Override
    public BranchDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    @Override
    public Mapping.Direction getDirection() {
        return this.direction;
    }

    @Override
    public Branch getSourceSelection() {
        return this.sourceArea != null ? this.sourceArea.getSelection() : null;
    }

    @Override
    public Branch getTargetSelection() {
        return this.targetArea != null ? this.targetArea.getSelection() : null;
    }

    @Override
    public BranchNameArea getSourceArea() {
        return this.sourceArea;
    }

    @Override
    public BranchNameArea getTargetArea() {
        return this.targetArea;
    }
}

