/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.tooltip;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.tooltip.BaseToolTip;
import com.perforce.team.ui.mergequest.tooltip.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MappingToolTip
extends BaseToolTip {
    private Mapping mapping = null;

    public MappingToolTip(Control control, Mapping mapping) {
        super(control);
        this.mapping = mapping;
    }

    @Override
    protected void createInnerContent(Composite parent) {
        Branch target;
        CLabel mappingLabel = new CLabel(parent, 0);
        mappingLabel.setText(this.mapping.getName());
        StringBuilder sourceText = new StringBuilder();
        StringBuilder targetText = new StringBuilder();
        Branch source = this.mapping.getSource();
        if (source != null) {
            sourceText.append(MessageFormat.format(Messages.MappingToolTip_Source, this.mapping.getSource().getName()));
        }
        if ((target = this.mapping.getTarget()) != null) {
            targetText.append(MessageFormat.format(Messages.MappingToolTip_Target, this.mapping.getTarget().getName()));
        }
        if (this.mapping instanceof DepotPathMapping) {
            DepotPathMapping dMapping = (DepotPathMapping)this.mapping;
            sourceText.append('\n').append(String.valueOf(Messages.MappingToolTip_SourcePath) + dMapping.getSourcePath());
            targetText.append('\n').append(String.valueOf(Messages.MappingToolTip_TargetPath) + dMapping.getTargetPath());
        }
        if (sourceText.length() > 0) {
            CLabel sourceLabel = new CLabel(parent, 0);
            sourceLabel.setText(sourceText.toString());
        }
        if (targetText.length() > 0) {
            CLabel targetLabel = new CLabel(parent, 0);
            targetLabel.setText(targetText.toString());
        }
    }
}

