/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.tooltip;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.ui.mergequest.tooltip.BaseToolTip;
import com.perforce.team.ui.mergequest.tooltip.Messages;
import java.text.MessageFormat;
import java.util.TreeSet;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BranchToolTip
extends BaseToolTip {
    private Branch branch;

    public BranchToolTip(Control control, Branch branch) {
        super(control);
        this.branch = branch;
    }

    @Override
    protected void createInnerContent(Composite parent) {
        CLabel countLabel;
        CLabel label = new CLabel(parent, 0);
        label.setText(this.branch.getName());
        int count = this.branch.getMappingCount();
        if (count != 1) {
            countLabel = new CLabel(parent, 0);
            countLabel.setText(MessageFormat.format(Messages.BranchToolTip_MultiConnectedMappings, count));
        } else {
            countLabel = new CLabel(parent, 0);
            countLabel.setText(Messages.BranchToolTip_SingleConnectedMapping);
        }
        if (count > 0) {
            Mapping mapping;
            StringBuilder incoming = new StringBuilder(Messages.BranchToolTip_IncomingIntegrations);
            StringBuilder outgoing = new StringBuilder(Messages.BranchToolTip_OutgoingIntegrations);
            TreeSet<String> outgoingNames = new TreeSet<String>();
            TreeSet<String> incomingNames = new TreeSet<String>();
            Mapping[] mappingArray = this.branch.getTargetMappings();
            int n = mappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                mapping = mappingArray[n2];
                Branch source = mapping.getSource();
                if (source != null) {
                    if (mapping.getDirection() != Mapping.Direction.TARGET && mapping.getSourceChange() == MappingDescriptor.ChangeType.VISIBLE_CHANGES) {
                        outgoingNames.add(source.getName());
                    }
                    if (mapping.getDirection() != Mapping.Direction.SOURCE && mapping.getTargetChange() == MappingDescriptor.ChangeType.VISIBLE_CHANGES) {
                        incomingNames.add(source.getName());
                    }
                }
                ++n2;
            }
            mappingArray = this.branch.getSourceMappings();
            n = mappingArray.length;
            n2 = 0;
            while (n2 < n) {
                mapping = mappingArray[n2];
                Branch target = mapping.getTarget();
                if (target != null) {
                    if (mapping.getDirection() != Mapping.Direction.TARGET && mapping.getSourceChange() == MappingDescriptor.ChangeType.VISIBLE_CHANGES) {
                        incomingNames.add(target.getName());
                    }
                    if (mapping.getDirection() != Mapping.Direction.SOURCE && mapping.getTargetChange() == MappingDescriptor.ChangeType.VISIBLE_CHANGES) {
                        outgoingNames.add(target.getName());
                    }
                }
                ++n2;
            }
            if (incomingNames.isEmpty()) {
                incoming.append('\n').append(Messages.BranchToolTip_None);
            } else {
                for (String name : incomingNames) {
                    incoming.append('\n').append(name);
                }
            }
            if (outgoingNames.isEmpty()) {
                outgoing.append('\n').append(Messages.BranchToolTip_None);
            } else {
                for (String name : outgoingNames) {
                    outgoing.append('\n').append(name);
                }
            }
            new CLabel(parent, 0).setText(incoming.toString());
            new CLabel(parent, 0).setText(outgoing.toString());
        }
    }
}

