/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.policies;

import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.commands.BendpointCommand;
import com.perforce.team.ui.mergequest.commands.BendpointCreateCommand;
import com.perforce.team.ui.mergequest.commands.BendpointDeleteCommand;
import com.perforce.team.ui.mergequest.commands.BendpointMoveCommand;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;

public class MappingBendpointEditPolicy
extends BendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        BendpointCreateCommand command = new BendpointCreateCommand();
        this.setCommandDimensions(request, command);
        this.setCommandLocation(request, command);
        return command;
    }

    private void setCommandDimensions(BendpointRequest request, BendpointCommand command) {
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        Point source = this.getConnection().getSourceAnchor().getReferencePoint();
        Point target = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)source);
        conn.translateToRelative((Translatable)target);
        command.setDimensions(p.getDifference(source), p.getDifference(target));
    }

    private void setCommandLocation(BendpointRequest request, BendpointCommand command) {
        command.setMapping((Mapping)request.getSource().getModel());
        command.setIndex(request.getIndex());
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        BendpointDeleteCommand command = new BendpointDeleteCommand();
        this.setCommandLocation(request, command);
        return command;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        BendpointMoveCommand command = new BendpointMoveCommand();
        this.setCommandDimensions(request, command);
        this.setCommandLocation(request, command);
        return command;
    }
}

