/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.parts;

import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.actions.MappingEditAction;
import com.perforce.team.ui.mergequest.figures.MappingFigure;
import com.perforce.team.ui.mergequest.figures.theme.CompositeFigureThemeHelper;
import com.perforce.team.ui.mergequest.figures.theme.FigureThemeHelper;
import com.perforce.team.ui.mergequest.figures.theme.ThemeHelper;
import com.perforce.team.ui.mergequest.figures.theme.ThemeListenerAdapter;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.parts.ToolTipHelper;
import com.perforce.team.ui.mergequest.policies.MappingBendpointEditPolicy;
import com.perforce.team.ui.mergequest.policies.MappingEditPolicy;
import com.perforce.team.ui.mergequest.policies.MappingSelectionEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;

public class MappingEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private SharedResources images;
    private ToolTipHelper tooltipHelper;
    private MappingColorProvider colorProvider;
    private FigureThemeHelper mappingThemeHelper;
    private CompositeFigureThemeHelper countThemeHelper;

    public MappingEditPart(SharedResources images) {
        this.images = images;
        this.tooltipHelper = new ToolTipHelper((AbstractGraphicalEditPart)this);
        this.mappingThemeHelper = new FigureThemeHelper();
        this.mappingThemeHelper.setFontKey("com.perforce.team.ui.mergequest.font.mapping.font");
        this.mappingThemeHelper.setBackgroundKey("com.perforce.team.ui.mergequest.background.mapping");
        this.countThemeHelper = this.createCountThemeHelper();
        this.colorProvider = new MappingColorProvider();
    }

    private CompositeFigureThemeHelper createCountThemeHelper() {
        String prefix = "mapping.count";
        CompositeFigureThemeHelper helper = new CompositeFigureThemeHelper();
        helper.setBackgroundKey("com.perforce.team.ui.mergequest.background." + prefix);
        helper.setOutlineKey("com.perforce.team.ui.mergequest.outline." + prefix);
        helper.setFontKey("com.perforce.team.ui.mergequest.font." + prefix);
        return helper;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getMapping().addPropertyListener((PropertyChangeListener)this);
            this.tooltipHelper.activate();
            this.mappingThemeHelper.activate();
            this.countThemeHelper.activate();
            this.colorProvider.activate();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getMapping().removePropertyListener((PropertyChangeListener)this);
            this.tooltipHelper.deactivate();
            this.mappingThemeHelper.deactivate();
            this.colorProvider.deactivate();
            this.countThemeHelper.deactivate();
            super.deactivate();
        }
    }

    public Mapping getMapping() {
        return (Mapping)this.getModel();
    }

    public Object getAdapter(Class key) {
        if (key == Mapping.class || key == IBranchGraphElement.class) {
            return this.getMapping();
        }
        return super.getAdapter(key);
    }

    protected IFigure createFigure() {
        Mapping mapping = this.getMapping();
        MappingFigure figure = new MappingFigure(mapping, this.images);
        figure.setOutlineMappingLabel(true);
        figure.setColorProvider(this.colorProvider);
        this.mappingThemeHelper.setFigure((IFigure)figure);
        this.countThemeHelper.setFigures(new IFigure[]{figure.getSourceCountFigure(), figure.getTargetCountFigure()});
        figure.updateStatus(mapping);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MappingSelectionEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new MappingEditPolicy(this.getMapping()));
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new MappingBendpointEditPolicy());
    }

    private MappingFigure getMappingFigure() {
        return (MappingFigure)this.getFigure();
    }

    protected void refreshBendpoints() {
        Mapping.Joint[] joints = this.getMapping().getJoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int count = 0;
        Mapping.Joint[] jointArray = joints;
        int n = joints.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping.Joint joint = jointArray[n2];
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(new Dimension(joint.getX1(), joint.getY1()), new Dimension(joint.getX2(), joint.getY2()));
            rbp.setWeight((float)(count + 1) / ((float)joints.length + 1.0f));
            figureConstraint.add(rbp);
            ++count;
            ++n2;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    protected void refreshVisuals() {
        if (this.isActive()) {
            if (PerforceUIPlugin.isUIThread()) {
                this.getMappingFigure().updateStatus(this.getMapping());
                this.refreshSourceAnchor();
                this.refreshTargetAnchor();
                this.refreshBendpoints();
            } else {
                PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MappingEditPart.this.refreshVisuals();
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            MappingEditAction edit = new MappingEditAction(this.getMapping());
            edit.run();
        } else {
            super.performRequest(req);
        }
    }

    private class MappingColorProvider
    implements IColorProvider {
        private ThemeHelper enabledHelper = new ThemeHelper();
        private ThemeHelper disabledHelper;
        private Color enabledForeground = null;
        private Color disabledForeground = null;

        public MappingColorProvider() {
            this.enabledHelper.setListener(new ThemeListenerAdapter(){

                @Override
                public void setForegroundColor(Color color) {
                    MappingColorProvider.this.enabledForeground = color;
                    MappingEditPart.this.refreshVisuals();
                }
            });
            this.enabledHelper.setForegroundKey("com.perforce.team.ui.mergequest.foreground.mapping.enabled");
            this.disabledHelper = new ThemeHelper();
            this.disabledHelper.setForegroundKey("com.perforce.team.ui.mergequest.foreground.mapping.disabled");
            this.disabledHelper.setListener(new ThemeListenerAdapter(){

                @Override
                public void setForegroundColor(Color color) {
                    MappingColorProvider.this.disabledForeground = color;
                    MappingEditPart.this.refreshVisuals();
                }
            });
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof MappingDescriptor.ChangeType) {
                if (MappingDescriptor.ChangeType.VISIBLE_CHANGES == element) {
                    return this.enabledForeground;
                }
                return this.disabledForeground;
            }
            return null;
        }

        public void activate() {
            this.enabledHelper.activate();
            this.disabledHelper.activate();
        }

        public void deactivate() {
            this.enabledHelper.deactivate();
            this.disabledHelper.deactivate();
        }
    }
}

