/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures.theme;

import com.perforce.team.ui.mergequest.figures.theme.IThemeListener;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class ThemeHelper
implements IPropertyChangeListener {
    public static final String BG_PREFIX = "com.perforce.team.ui.mergequest.background.";
    public static final String FG_PREFIX = "com.perforce.team.ui.mergequest.foreground.";
    public static final String FONT_PREFIX = "com.perforce.team.ui.mergequest.font.";
    public static final String OUTLINE_PREFIX = "com.perforce.team.ui.mergequest.outline.";
    private IThemeListener listener;
    private Color defaultForeground;
    private Color defaultBackground;
    private Color defaultOutline;
    private Font defaultFont;
    private String foreground;
    private String background;
    private String font;
    private String outline;
    private Runnable changeCallback = null;

    public void setListener(IThemeListener listener) {
        this.listener = listener;
    }

    public void setForegroundKey(String foreground) {
        this.foreground = foreground;
    }

    public void setFontKey(String font) {
        this.font = font;
    }

    public void setBackgroundKey(String background) {
        this.background = background;
    }

    public void setOutlineKey(String outline) {
        this.outline = outline;
    }

    private IThemeManager getThemeManager() {
        return PlatformUI.getWorkbench().getThemeManager();
    }

    public void synchronize() {
        ITheme current = this.getThemeManager().getCurrentTheme();
        ColorRegistry registry = current.getColorRegistry();
        if (this.listener != null) {
            if (this.background != null) {
                Color newBackground = registry.get(this.background);
                if (newBackground == null) {
                    newBackground = this.defaultBackground;
                }
                this.listener.setBackgroundColor(newBackground);
            }
            if (this.foreground != null) {
                Color newForeground = registry.get(this.foreground);
                if (newForeground == null) {
                    newForeground = this.defaultForeground;
                }
                this.listener.setForegroundColor(newForeground);
            }
            if (this.font != null) {
                Font newFont = current.getFontRegistry().get(this.font);
                if (newFont == null) {
                    newFont = this.defaultFont;
                }
                this.listener.setFont(newFont);
            }
            if (this.outline != null) {
                Color newOutline = registry.get(this.outline);
                if (newOutline == null) {
                    newOutline = this.defaultOutline;
                }
                this.listener.setOutlineColor(newOutline);
            }
            if (this.changeCallback != null) {
                this.changeCallback.run();
            }
        }
    }

    public void activate() {
        this.activate(null);
    }

    public void activate(Runnable callback) {
        this.changeCallback = callback;
        this.getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        this.synchronize();
    }

    public void deactivate() {
        this.getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null) {
            return;
        }
        if ("CHANGE_CURRENT_THEME".equals(property) || property.equals(this.foreground) || property.equals(this.background) || property.equals(this.font) || property.equals(this.outline)) {
            this.synchronize();
        }
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    public Color getDefaultOutline() {
        return this.defaultOutline;
    }

    public void setDefaultOutline(Color defaultOutline) {
        this.defaultOutline = defaultOutline;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }
}

