/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.figures.ChangeCountFigure;
import com.perforce.team.ui.mergequest.figures.MappingEndpointLocator;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.RoutingAnimator;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.gef.SharedCursors;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class MappingFigure
extends PolylineConnection {
    public static final int INDICATOR_OFFSET = 25;
    public static final int COUNT_OFFSET = 40;
    public static final int INACTIVE_LINE_WIDTH = 2;
    public static final int ACTIVE_LINE_WIDTH = 4;
    private SharedResources resources;
    private ChangeCountFigure sourceCountLabel;
    private RotatableDecoration sourceDecoration;
    private ChangeCountFigure targetCountLabel;
    private RotatableDecoration targetDecoration;
    private RoundedRectangle mappingLabel;
    private IColorProvider colorProvider;

    public MappingFigure(Mapping mapping, SharedResources resources) {
        this.resources = resources;
        this.setLineWidth(2);
        this.setAntialias(1);
        this.setCursor(SharedCursors.HAND);
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.white);
        this.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
        this.sourceCountLabel = new ChangeCountFigure(this.resources);
        this.add(this.sourceCountLabel, this.createEndpointLocator(40, 2));
        this.targetCountLabel = new ChangeCountFigure(this.resources);
        this.add(this.targetCountLabel, this.createEndpointLocator(40, 3));
        if (mapping instanceof DepotPathMapping) {
            this.addMappingTypeLabel(resources.getImage("icons/depotPath.png"));
        } else if (mapping instanceof BranchSpecMapping) {
            this.addMappingTypeLabel(resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/branch.png")));
        }
        this.sourceDecoration = this.createDecoration();
        this.targetDecoration = this.createDecoration();
        this.setSourceDecoration(this.sourceDecoration);
        this.setTargetDecoration(this.targetDecoration);
    }

    public void select() {
        this.setLineWidth(4);
    }

    public void deselect() {
        this.setLineWidth(2);
    }

    private Locator createEndpointLocator(int offset, int alignment) {
        return this.createEndpointLocator(offset, offset, alignment);
    }

    private Locator createEndpointLocator(int x, int y, int alignment) {
        MappingEndpointLocator locator = new MappingEndpointLocator((Connection)this, alignment);
        locator.setOffsets(x, y);
        return locator;
    }

    public void setColorProvider(IColorProvider provider) {
        this.colorProvider = provider;
    }

    public void setOutlineMappingLabel(boolean outline) {
        this.mappingLabel.setOutline(outline);
    }

    private void addMappingTypeLabel(Image image) {
        this.mappingLabel = new RoundedRectangle();
        this.mappingLabel.setOpaque(true);
        Label label = new Label(image);
        this.mappingLabel.setBorder((Border)new MarginBorder(1));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.mappingLabel.setLayoutManager((LayoutManager)layout);
        this.mappingLabel.add((IFigure)label);
        this.add((IFigure)this.mappingLabel, new ConnectionLocator((Connection)this, 4));
    }

    private RotatableDecoration createDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setLineWidth(this.getLineWidth());
        return decoration;
    }

    public void updateStatus(Mapping mapping) {
        MappingDescriptor.ChangeType sourceType = mapping.getSourceChange();
        MappingDescriptor.ChangeType targetType = mapping.getTargetChange();
        int lineStyle = 1;
        Mapping.Direction direction = mapping.getDirection();
        boolean source = direction == Mapping.Direction.BOTH || direction == Mapping.Direction.SOURCE;
        boolean target = direction == Mapping.Direction.BOTH || direction == Mapping.Direction.TARGET;
        MappingDescriptor.ChangeType type = MappingDescriptor.ChangeType.NO_CHANGES;
        if (source && sourceType == MappingDescriptor.ChangeType.NO_PERMISSION || target && targetType == MappingDescriptor.ChangeType.NO_PERMISSION) {
            lineStyle = 2;
            type = MappingDescriptor.ChangeType.NO_PERMISSION;
        }
        if (source && sourceType == MappingDescriptor.ChangeType.VISIBLE_CHANGES || target && targetType == MappingDescriptor.ChangeType.VISIBLE_CHANGES) {
            lineStyle = 1;
            type = MappingDescriptor.ChangeType.VISIBLE_CHANGES;
        }
        if (this.colorProvider != null) {
            Color foreground = this.colorProvider.getForeground((Object)type);
            this.setForegroundColor(foreground);
            this.sourceCountLabel.setForegroundColor(this.colorProvider.getForeground((Object)sourceType));
            this.targetCountLabel.setForegroundColor(this.colorProvider.getForeground((Object)targetType));
        }
        this.setLineStyle(lineStyle);
        this.sourceCountLabel.setVisible(source);
        this.sourceDecoration.setVisible(source);
        this.targetCountLabel.setVisible(target);
        this.targetDecoration.setVisible(target);
        this.sourceCountLabel.updateChanges(sourceType, mapping.getTargetToSourceCount());
        this.targetCountLabel.updateChanges(targetType, mapping.getSourceToTargetCount());
    }

    public IFigure getSourceCountFigure() {
        return this.sourceCountLabel;
    }

    public IFigure getTargetCountFigure() {
        return this.targetCountLabel;
    }
}

