/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class MappingEndpointLocator
extends ConnectionLocator {
    private int xOffset = 20;
    private int yOffset = 20;

    public MappingEndpointLocator(Connection connection) {
        super(connection);
    }

    public MappingEndpointLocator(Connection connection, int alignment) {
        super(connection, alignment);
    }

    protected Point getTargetPoint(Point p1, Point p2, boolean useDistance) {
        double angle = this.computeAngle(p1, p2);
        Point point = this.convert(p1, p2, Math.cos(angle), Math.sin(angle), useDistance);
        point.negate().translate(p2);
        return point;
    }

    protected Point getSourcePoint(Point p1, Point p2, boolean useDistance) {
        double angle = this.computeAngle(p1, p2);
        angle = 1.5707963267948966 - angle;
        Point point = this.convert(p1, p2, Math.sin(angle), Math.cos(angle), useDistance);
        point.translate(p1);
        return point;
    }

    protected double computeAngle(Point p1, Point p2) {
        double opp = Math.abs(p1.y - p2.y);
        double adj = Math.abs(p2.x - p1.x);
        double angle = 0.0;
        angle = adj != 0.0 ? Math.atan(opp / adj) : 1.5707963267948966;
        return angle;
    }

    protected Point convert(Point p1, Point p2, double xConversion, double yConversion, boolean useDistance) {
        int segments = useDistance ? 4 : 2;
        int apart = (int)(Math.abs(p1.getDistance(p2)) / (double)segments);
        double tx = (double)Math.min(this.xOffset, apart) * xConversion;
        double ty = (double)Math.min(this.yOffset, apart) * yConversion;
        if (p1.x > p2.x) {
            tx *= -1.0;
        }
        if (p1.y > p2.y) {
            ty *= -1.0;
        }
        return new Point(tx, ty);
    }

    protected Point getLocation(PointList points) {
        int alignment = this.getAlignment();
        Point p1 = points.getFirstPoint();
        Point p2 = points.getLastPoint();
        Point point = null;
        if (alignment == 3) {
            boolean useDistance = true;
            if (points.size() >= 3) {
                p1 = points.getPoint(points.size() - 2);
                useDistance = false;
            }
            point = this.getTargetPoint(p1, p2, useDistance);
        } else if (alignment == 2) {
            boolean useDistance = true;
            if (points.size() >= 3) {
                p2 = points.getPoint(1);
                useDistance = false;
            }
            point = this.getSourcePoint(p1, p2, useDistance);
        } else {
            point = super.getLocation(points);
        }
        return point;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setOffsets(int xOffset, int yOffset) {
        this.setXOffset(xOffset);
        this.setYOffset(yOffset);
    }
}

