/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.actions.MappingDisplayAction;
import com.perforce.team.ui.mergequest.actions.MappingIntegrateAction;
import com.perforce.team.ui.mergequest.editor.GraphContext;
import com.perforce.team.ui.mergequest.figures.LinkFigure;
import com.perforce.team.ui.mergequest.figures.Messages;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.RGB;

public class CalloutFigure
extends RoundedRectangle {
    public CalloutFigure(GraphContext context, Mapping mapping, SharedResources images) {
        this.setBorder((Border)new MarginBorder(1));
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new GridLayout(2, false));
        this.createHeader(mapping, images);
        this.createLinks(context, mapping, images);
    }

    private void createHeader(Mapping mapping, SharedResources images) {
        GridData data = new GridData(1, 4, true, false);
        data.horizontalSpan = 3;
        data.horizontalIndent = 21;
        if (mapping instanceof DepotPathMapping) {
            this.add((IFigure)new Label(images.getImage("icons/depotPath.png")));
            DepotPathMapping dpm = (DepotPathMapping)mapping;
            Label source = new Label(String.valueOf(Messages.CalloutFigure_SourcePath) + dpm.getSourcePath());
            this.add((IFigure)source);
            Label target = new Label(String.valueOf(Messages.CalloutFigure_TargetPath) + dpm.getTargetPath());
            this.add((IFigure)target);
            this.getLayoutManager().setConstraint((IFigure)target, (Object)data);
        } else if (mapping instanceof BranchSpecMapping) {
            this.add((IFigure)new Label(images.getImage(PerforceUIPlugin.getDescriptor((String)"normal/branch.png"))));
            Label name = new Label(String.valueOf(Messages.CalloutFigure_SpecName) + mapping.getName());
            this.add((IFigure)name);
        }
    }

    private void createLinks(GraphContext context, Mapping mapping, SharedResources images) {
        LinkFigure integTarget = this.createBulletLink(images);
        integTarget.setText(String.valueOf(Messages.CalloutFigure_IntegrateTo) + mapping.getTarget().getName());
        integTarget.setAction((IAction)new MappingIntegrateAction(mapping));
        this.add((IFigure)new Label());
        this.add((IFigure)integTarget);
        LinkFigure integSource = this.createBulletLink(images);
        integSource.setText(String.valueOf(Messages.CalloutFigure_IntegrateTo) + mapping.getSource().getName());
        integSource.setAction((IAction)new MappingIntegrateAction(mapping, true));
        this.add((IFigure)new Label(""));
        this.add((IFigure)integSource);
        LinkFigure viewChanges = this.createBulletLink(images);
        viewChanges.setText(Messages.CalloutFigure_ShowChangelists);
        viewChanges.setAction((IAction)new MappingDisplayAction(context, mapping));
        this.add((IFigure)new Label());
        this.add((IFigure)viewChanges);
    }

    private LinkFigure createBulletLink(SharedResources images) {
        LinkFigure link = new LinkFigure();
        link.setForegroundColor(images.getColor(new RGB(0, 51, 153)));
        link.setIcon(images.getImage("icons/bullet.png"));
        link.setIconTextGap(0);
        this.add((IFigure)link);
        return link;
    }

    protected void outlineShape(Graphics graphics) {
        graphics.setForegroundColor(P4UIUtils.getDisplay().getSystemColor(16));
        super.outlineShape(graphics);
    }
}

