/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.outline;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.editor.outline.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class MappingProxy
extends WorkbenchAdapter
implements IAdaptable {
    private Branch parent;
    private Mapping mapping;
    private IWorkbenchAdapter wrapped;

    public static MappingProxy[] generateProxies(Mapping mapping) {
        MappingProxy[] proxies = null;
        if (mapping != null) {
            Branch source = mapping.getSource();
            Branch target = mapping.getTarget();
            if (source != null && target != null) {
                proxies = new MappingProxy[]{new MappingProxy(source, mapping), new MappingProxy(target, mapping)};
            } else if (source != null) {
                proxies = new MappingProxy[]{new MappingProxy(source, mapping)};
            } else if (target != null) {
                proxies = new MappingProxy[]{new MappingProxy(target, mapping)};
            }
        }
        if (proxies == null) {
            proxies = new MappingProxy[]{};
        }
        return proxies;
    }

    public static void addProxies(Mapping mapping, Collection<Object> collection) {
        if (collection != null) {
            MappingProxy[] mappingProxyArray = MappingProxy.generateProxies(mapping);
            int n = mappingProxyArray.length;
            int n2 = 0;
            while (n2 < n) {
                MappingProxy proxy = mappingProxyArray[n2];
                collection.add((Object)proxy);
                ++n2;
            }
        }
    }

    public MappingProxy(Branch parent, Mapping mapping) {
        this.parent = parent;
        this.mapping = mapping;
        this.wrapped = (IWorkbenchAdapter)P4CoreUtils.convert((Object)mapping, IWorkbenchAdapter.class);
    }

    public boolean isSource() {
        return this.parent != null && this.parent.equals((Object)this.mapping.getSource());
    }

    public boolean isTarget() {
        return this.parent != null && this.parent.equals((Object)this.mapping.getTarget());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.wrapped != null) {
            return this.wrapped.getImageDescriptor((Object)this.mapping);
        }
        return super.getImageDescriptor(object);
    }

    public Object[] getChildren(Object object) {
        if (this.wrapped != null) {
            return this.wrapped.getChildren((Object)this.mapping);
        }
        return super.getChildren(object);
    }

    public String getLabel(Object object) {
        String label = "";
        Branch source = this.mapping.getSource();
        Branch target = this.mapping.getTarget();
        if (source != null && target != null) {
            if (this.parent.equals((Object)source)) {
                label = MessageFormat.format(Messages.MappingProxy_To, target.getName());
            } else if (this.parent.equals((Object)target)) {
                label = MessageFormat.format(Messages.MappingProxy_From, source.getName());
            }
        }
        return label;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Branch getBranch() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MappingProxy) {
            MappingProxy proxy = (MappingProxy)((Object)obj);
            return this.parent.equals((Object)proxy.parent) && this.mapping.equals((Object)proxy.mapping);
        }
        return false;
    }

    public int hashCode() {
        return this.mapping.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (Mapping.class == adapter || IBranchGraphElement.class == adapter) {
            return this.mapping;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

