/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor.outline;

import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.editor.outline.MappingProxy;
import com.perforce.team.ui.mergequest.editor.outline.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.WorkbenchAdapter;

public class BranchMappingContentProvider
extends PerforceContentProvider {
    private ISchedulingRule viewRule = P4Runner.createRule();
    private IP4Connection connection;
    private Map<Mapping, ViewLine[]> mappings = new HashMap<Mapping, ViewLine[]>();

    public BranchMappingContentProvider(IP4Connection connection, StructuredViewer viewer) {
        super(viewer, true);
        this.connection = connection;
    }

    private void loadBranch(final MappingProxy proxy) {
        if (proxy.getMapping() instanceof BranchSpecMapping) {
            final BranchSpecMapping mapping = (BranchSpecMapping)proxy.getMapping();
            final IP4Branch branch = mapping.generateBranch(this.connection);
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return MessageFormat.format(Messages.BranchMappingContentProvider_LoadingSpec, mapping.getName());
                }

                public void run(IProgressMonitor monitor) {
                    branch.refresh();
                    ViewMap entries = branch.getView();
                    ArrayList<ViewLine> view = new ArrayList<ViewLine>();
                    if (entries != null) {
                        for (IBranchMapping entry : entries) {
                            view.add(new ViewLine(entry));
                        }
                    }
                    BranchMappingContentProvider.this.mappings.put(mapping, view.toArray(new ViewLine[view.size()]));
                    PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (P4UIUtils.okToUse((Viewer)BranchMappingContentProvider.this.viewer)) {
                                BranchMappingContentProvider.this.viewer.refresh((Object)proxy);
                            }
                        }
                    });
                }
            }, (ISchedulingRule)this.viewRule);
        }
    }

    private Object[] getProxyChildren(MappingProxy proxy) {
        if (proxy.getMapping() instanceof BranchSpecMapping) {
            if (!this.mappings.containsKey(proxy.getMapping())) {
                this.loadBranch(proxy);
                return new Object[]{new PerforceContentProvider.Loading()};
            }
            return (Object[])this.mappings.get(proxy.getMapping());
        }
        return proxy.getChildren((Object)proxy);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MappingProxy) {
            return this.getProxyChildren((MappingProxy)((Object)parentElement));
        }
        if (parentElement instanceof Branch) {
            Object[] children = super.getChildren(parentElement);
            Branch branch = (Branch)parentElement;
            Object[] converted = new Object[children.length];
            int i = 0;
            while (i < children.length) {
                converted[i] = children[i] instanceof Mapping ? new MappingProxy(branch, (Mapping)children[i]) : children[i];
                ++i;
            }
            return converted;
        }
        return super.getChildren(parentElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MappingProxy && ((MappingProxy)((Object)element)).getMapping() instanceof BranchSpecMapping) {
            return true;
        }
        return super.hasChildren(element);
    }

    public void dispose() {
        this.mappings.clear();
        super.dispose();
    }

    public static class ViewLine
    extends WorkbenchAdapter {
        private IBranchMapping line;

        public ViewLine(IBranchMapping line) {
            this.line = line;
        }

        public IBranchMapping getLine() {
            return this.line;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IMapEntry.EntryType type = this.line.getType();
            if (type != null) {
                switch (type) {
                    case EXCLUDE: {
                        return PerforceUIPlugin.getDescriptor((String)"normal/view_line_exclude.png");
                    }
                    case OVERLAY: {
                        return PerforceUIPlugin.getDescriptor((String)"normal/view_line_overlay.png");
                    }
                }
            }
            return PerforceUIPlugin.getDescriptor((String)"normal/view_line.png");
        }

        public String getLabel(Object object) {
            return this.line.toString("   ", true);
        }
    }
}

