/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.editor;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.P4BranchGraphCorePlugin;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.EditBranchAction;
import com.perforce.team.ui.mergequest.BranchWorkbenchAdapter;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.actions.BranchIntegrateAction;
import com.perforce.team.ui.mergequest.actions.MappingCreateAction;
import com.perforce.team.ui.mergequest.actions.MappingEditAction;
import com.perforce.team.ui.mergequest.actions.MappingIntegrateAction;
import com.perforce.team.ui.mergequest.actions.ShowTasksAction;
import com.perforce.team.ui.mergequest.commands.BranchCreateCommand;
import com.perforce.team.ui.mergequest.commands.BranchEditCommand;
import com.perforce.team.ui.mergequest.commands.CommandAction;
import com.perforce.team.ui.mergequest.commands.MappingCreateCommand;
import com.perforce.team.ui.mergequest.editor.Messages;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public class GraphContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry registry;
    private IBranchGraph graph;
    private Rectangle location = new Rectangle(100, 100, 0, 0);

    public GraphContextMenuProvider(IBranchGraph graph, SharedResources resources, EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.graph = graph;
        this.registry = registry;
        Control control = viewer.getControl();
        if (control != null) {
            control.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    ((GraphContextMenuProvider)GraphContextMenuProvider.this).location.x = e.x;
                    ((GraphContextMenuProvider)GraphContextMenuProvider.this).location.y = e.y;
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
    }

    private void addRemoveAction(IMenuManager menu) {
        IAction remove = this.registry.getAction((Object)ActionFactory.DELETE.getId());
        if (remove != null) {
            menu.appendToGroup("org.eclipse.gef.group.edit", remove);
        }
    }

    private IAction createBranchAction(BranchType type) {
        BranchCreateCommand command = new BranchCreateCommand(type, this.graph, this.location);
        CommandAction createBranch = new CommandAction(command, this.getViewer());
        createBranch.setImageDescriptor(BranchWorkbenchAdapter.getTypeDescriptor(type.getType()));
        createBranch.setText(MessageFormat.format(Messages.GraphContextMenuProvider_AddBranch, type.getType()));
        return createBranch;
    }

    private void addEmptySelectionActions(IMenuManager menu) {
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)new Separator());
        for (BranchType type : P4BranchGraphCorePlugin.getDefault().getBranchRegistry()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", this.createBranchAction(type));
        }
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)new Separator());
        Branch[] branches = this.graph.getBranches();
        CommandAction createMapping = new CommandAction(new MappingCreateCommand(this.graph, "branchSpec"), this.getViewer());
        createMapping.setEnabled(branches.length > 0);
        createMapping.setText(Messages.GraphContextMenuProvider_AddBranchSpecMapping);
        createMapping.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/branch.png"));
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)createMapping);
        createMapping = new CommandAction(new MappingCreateCommand(this.graph, "depotPath"), this.getViewer());
        createMapping.setText(Messages.GraphContextMenuProvider_AddDepotPathMapping);
        createMapping.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/depotPath.png"));
        createMapping.setEnabled(branches.length > 0);
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)createMapping);
    }

    public void buildContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.edit"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.undo"));
        menu.add((IContributionItem)new Separator("additions"));
        List parts = this.getViewer().getSelectedEditParts();
        if (parts.size() == 1) {
            Object part = parts.get(0);
            this.addBranchActions(part, menu);
            this.addMappingActions(part, menu);
        } else if (parts.size() > 1) {
            this.addRemoveAction(menu);
        } else if (parts.size() == 0) {
            this.addEmptySelectionActions(menu);
        }
        IAction action = this.registry.getAction((Object)ActionFactory.UNDO.getId());
        if (action != null) {
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
        }
        if ((action = this.registry.getAction((Object)ActionFactory.REDO.getId())) != null) {
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
        }
    }

    private void addDirectionMenu(final Mapping mapping, IMenuManager menu) {
        Branch source = mapping.getSource();
        Branch target = mapping.getTarget();
        String sourceName = source != null ? source.getName() : "";
        String targetName = target != null ? target.getName() : "";
        MenuManager direction = new MenuManager(Messages.GraphContextMenuProvider_ChangeDirection, null, "changeDirection");
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)direction);
        Action sourceToTargetAction = new Action(MessageFormat.format(Messages.GraphContextMenuProvider_BranchToBranch, sourceName, targetName), 2){

            public void run() {
                mapping.setDirection(Mapping.Direction.TARGET);
            }
        };
        sourceToTargetAction.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/arrow_right.png"));
        direction.add((IAction)sourceToTargetAction);
        Action bothAction = new Action(Messages.GraphContextMenuProvider_BothDirections, 2){

            public void run() {
                mapping.setDirection(Mapping.Direction.BOTH);
            }
        };
        bothAction.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/arrow_both.png"));
        direction.add((IAction)bothAction);
        Action targetToSourceAction = new Action(MessageFormat.format(Messages.GraphContextMenuProvider_BranchToBranch, targetName, sourceName), 2){

            public void run() {
                mapping.setDirection(Mapping.Direction.SOURCE);
            }
        };
        targetToSourceAction.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/arrow_left.png"));
        direction.add((IAction)targetToSourceAction);
        switch (mapping.getDirection()) {
            case SOURCE: {
                targetToSourceAction.setChecked(true);
                break;
            }
            case TARGET: {
                sourceToTargetAction.setChecked(true);
                break;
            }
            default: {
                bothAction.setChecked(true);
            }
        }
    }

    private void addMappingActions(Object editPart, IMenuManager menu) {
        Mapping mapping = (Mapping)P4CoreUtils.convert((Object)editPart, Mapping.class);
        if (mapping != null) {
            MappingEditAction editAction = new MappingEditAction(mapping);
            editAction.setText(Messages.GraphContextMenuProvider_EditConnector);
            editAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/edit.png"));
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)editAction);
            Action showTasks = new Action(){

                public void run() {
                    ShowTasksAction show = new ShowTasksAction();
                    show.runAction();
                }
            };
            showTasks.setText(Messages.GraphContextMenuProvider_ShowTasks);
            showTasks.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/integration_tasks.png"));
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)showTasks);
            Mapping.Direction direction = mapping.getDirection();
            if (direction == Mapping.Direction.TARGET || direction == Mapping.Direction.BOTH) {
                MappingIntegrateAction toAction = new MappingIntegrateAction(mapping, false);
                toAction.setText(MessageFormat.format(Messages.GraphContextMenuProvider_IntegrateToBranch, mapping.getTarget().getName()));
                toAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/integrate.png"));
                menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)toAction);
            }
            if (direction == Mapping.Direction.SOURCE || direction == Mapping.Direction.BOTH) {
                MappingIntegrateAction fromAction = new MappingIntegrateAction(mapping, true);
                fromAction.setText(MessageFormat.format(Messages.GraphContextMenuProvider_IntegrateToBranch, mapping.getSource().getName()));
                fromAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/integrate.png"));
                menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)fromAction);
            }
            this.addDirectionMenu(mapping, menu);
            if (mapping instanceof BranchSpecMapping) {
                this.addBranchSpecMappingActions((BranchSpecMapping)mapping, menu);
            }
            this.addRemoveAction(menu);
        }
    }

    private void addBranchSpecMappingActions(final BranchSpecMapping mapping, IMenuManager menu) {
        IP4Connection connection;
        IBranchGraph graph = mapping.getGraph();
        if (graph != null && (connection = graph.getConnection()) != null) {
            Action editSpec = new Action(Messages.GraphContextMenuProvider_EditBranchSpec){

                public void run() {
                    EditBranchAction edit = new EditBranchAction();
                    edit.selectionChanged(null, (ISelection)new StructuredSelection((Object)mapping.generateBranch(connection)));
                    edit.run(null);
                }
            };
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)editSpec);
        }
    }

    private void addBranchActions(Object editPart, IMenuManager menu) {
        Branch branch = (Branch)P4CoreUtils.convert((Object)editPart, Branch.class);
        if (branch != null) {
            Mapping mapping;
            CommandAction editAction = new CommandAction(new BranchEditCommand(branch), this.getViewer());
            editAction.setText(Messages.GraphContextMenuProvider_EditBranch);
            editAction.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/edit.png"));
            menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)editAction);
            MenuManager integrateFrom = new MenuManager(Messages.GraphContextMenuProvider_IntegrateFrom, PerforceUIPlugin.getDescriptor((String)"normal/integrate.png"), "integrateFrom");
            menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)integrateFrom);
            MenuManager integrateTo = new MenuManager(Messages.GraphContextMenuProvider_IntegrateTo, PerforceUIPlugin.getDescriptor((String)"normal/integrate.png"), "integrateTo");
            menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)integrateTo);
            Mapping[] mappingArray = branch.getSourceMappings();
            int n = mappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                mapping = mappingArray[n2];
                integrateTo.add((IAction)new BranchIntegrateAction(mapping, false, false));
                ++n2;
            }
            mappingArray = branch.getTargetMappings();
            n = mappingArray.length;
            n2 = 0;
            while (n2 < n) {
                mapping = mappingArray[n2];
                if (mapping.getDirection() == Mapping.Direction.BOTH || mapping.getDirection() == Mapping.Direction.TARGET) {
                    integrateFrom.add((IAction)new BranchIntegrateAction(mapping, true, true));
                }
                if (mapping.getDirection() == Mapping.Direction.BOTH || mapping.getDirection() == Mapping.Direction.SOURCE) {
                    integrateTo.add((IAction)new BranchIntegrateAction(mapping, false, true));
                }
                ++n2;
            }
            this.addRemoveAction(menu);
            this.addNewMappingActions(branch, menu);
        }
    }

    private void addNewMappingActions(Branch branch, IMenuManager menu) {
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)new Separator());
        MenuManager addMapping = new MenuManager(Messages.GraphContextMenuProvider_AddBranchSpecMapping, PerforceUIPlugin.getDescriptor((String)"normal/branch.png"), "addBranchSpecMapping");
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)addMapping);
        MappingCreateAction createFrom = new MappingCreateAction(this.graph, "branchSpec");
        createFrom.setText(MessageFormat.format(Messages.GraphContextMenuProvider_From, branch.getName()));
        createFrom.setInitialSource(branch);
        addMapping.add((IAction)createFrom);
        MappingCreateAction createTo = new MappingCreateAction(this.graph, "branchSpec");
        createTo.setText(MessageFormat.format(Messages.GraphContextMenuProvider_To, branch.getName()));
        createTo.setInitialTarget(branch);
        addMapping.add((IAction)createTo);
        addMapping = new MenuManager(Messages.GraphContextMenuProvider_AddDepotPathMapping, P4BranchGraphPlugin.getImageDescriptor("icons/depotPath.png"), "addDepotPathMapping");
        menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)addMapping);
        createFrom = new MappingCreateAction(this.graph, "depotPath");
        createFrom.setText(MessageFormat.format(Messages.GraphContextMenuProvider_From, branch.getName()));
        createFrom.setInitialSource(branch);
        addMapping.add((IAction)createFrom);
        createTo = new MappingCreateAction(this.graph, "depotPath");
        createTo.setText(MessageFormat.format(Messages.GraphContextMenuProvider_To, branch.getName()));
        createTo.setInitialTarget(branch);
        addMapping.add((IAction)createTo);
    }
}

