/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.descriptors;

import com.perforce.team.core.extensions.ExtensionPointRegistry;
import com.perforce.team.ui.mergequest.descriptors.ElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DescriptorRegistry
extends ExtensionPointRegistry {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String ICON_ATTRIBUTE = "icon";
    public static final String IMPORTANT_ATTRIBUTE = "important";
    public static final String CREATE_DESCRIPTION_ATTRIBUTE = "createDescription";
    private String name;
    private Map<String, ElementDescriptor> descriptors = new HashMap<String, ElementDescriptor>();

    public DescriptorRegistry(String extensionPointId, String elementName) {
        this.name = elementName;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        ArrayList<IConfigurationElement> matching = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (elementName.equals(element.getAttribute(NAME_ATTRIBUTE))) {
                matching.add(element);
            }
            ++n2;
        }
        if (!matching.isEmpty()) {
            this.buildDescriptors(matching);
        }
    }

    public String getName() {
        return this.name;
    }

    public ElementDescriptor[] getDescriptors() {
        return this.descriptors.values().toArray(new ElementDescriptor[this.descriptors.size()]);
    }

    public ElementDescriptor getDescriptor(String type) {
        ElementDescriptor descriptor = null;
        if (type != null) {
            descriptor = this.descriptors.get(type);
        }
        return descriptor;
    }

    protected void buildDescriptors(Collection<IConfigurationElement> elements) {
        for (IConfigurationElement element : elements) {
            String type = element.getAttribute(TYPE_ATTRIBUTE);
            String icon = element.getAttribute(ICON_ATTRIBUTE);
            IConfigurationElement[] description = element.getChildren(CREATE_DESCRIPTION_ATTRIBUTE);
            if (type == null || icon == null || description.length != 1) continue;
            ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)icon);
            ElementDescriptor descriptor = new ElementDescriptor(this.name, type, image, description[0].getValue(), this.getBoolean(element.getAttribute(IMPORTANT_ATTRIBUTE)));
            if (this.descriptors.containsKey(type)) continue;
            this.descriptors.put(type, descriptor);
        }
    }
}

