/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.WorkbenchAdapter;

public class MappingWorkbenchAdapter
extends WorkbenchAdapter {
    public Object[] getChildren(Object o) {
        if (o instanceof DepotPathMapping) {
            DepotPathMapping mapping = (DepotPathMapping)o;
            Branch sBranch = mapping.getSource();
            Branch tBranch = mapping.getTarget();
            if (sBranch != null && tBranch != null) {
                DepotPath source = new DepotPath((Mapping)mapping, sBranch.getName(), mapping.getSourcePath());
                DepotPath target = new DepotPath((Mapping)mapping, tBranch.getName(), mapping.getTargetPath());
                return new DepotPath[]{source, target};
            }
        }
        return super.getChildren(o);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        String type = ((Mapping)object).getType();
        if ("branchSpec".equals(type)) {
            return PerforceUIPlugin.getDescriptor((String)"normal/branch.png");
        }
        if ("depotPath".equals(type)) {
            return P4BranchGraphPlugin.getImageDescriptor("icons/depotPath.png");
        }
        return super.getImageDescriptor(object);
    }

    public String getLabel(Object o) {
        Mapping mapping = (Mapping)o;
        return mapping.getName();
    }

    public Object getParent(Object o) {
        return ((Mapping)o).getGraph();
    }

    public static class DepotPath
    extends WorkbenchAdapter {
        private Mapping parent;
        private String path;
        private String name;

        public DepotPath(Mapping parent, String name, String path) {
            this.parent = parent;
            this.name = name;
            this.path = path;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return PerforceUIPlugin.getDescriptor((String)"normal/view_line.png");
        }

        public String getLabel(Object object) {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public Object getParent(Object object) {
            return this.parent;
        }
    }
}

