/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.mergequest.wizards.mapping.Messages;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import java.text.MessageFormat;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public final class BranchGraphUtils {
    public static void configureDepotBrowseButton(final IP4Connection connection, ToolItem browse, final Control field) {
        if (connection == null || browse == null || field == null) {
            return;
        }
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionPath;
                IP4Resource resource;
                ResourceBrowserDialog dialog = new ResourceBrowserDialog(field.getShell(), connection.members());
                if (dialog.open() == 0 && (resource = dialog.getSelectedResource()) != null && (actionPath = resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                    if (field instanceof Combo) {
                        ((Combo)field).setText(actionPath);
                    } else if (field instanceof Text) {
                        ((Text)field).setText(actionPath);
                    }
                }
            }
        });
    }

    public static void addContentAssistDecoration(Control control) {
        ControlDecoration decoration = new ControlDecoration(control, 16512);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fieldDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        if (fieldDecoration != null) {
            String commandValue;
            decoration.setDescriptionText(fieldDecoration.getDescription());
            decoration.setImage(fieldDecoration.getImage());
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            if (bindingService != null && (commandValue = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals")) != null && commandValue.length() > 0) {
                decoration.setDescriptionText(MessageFormat.format(Messages.MappingArea_ContentAssistAvailable, commandValue));
            }
        }
    }
}

