/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JobCache {
    public static final int CACHE_SIZE = 256;
    private Map<IP4Connection, LimitMap<String, IP4Job>> allJobs = new HashMap<IP4Connection, LimitMap<String, IP4Job>>();

    public void add(IP4Job job) {
        if (job != null) {
            IP4Connection connection = job.getConnection();
            String id = job.getId();
            LimitMap<String, Object> jobs = this.allJobs.get(connection);
            if (jobs == null) {
                jobs = new LimitMap();
                this.allJobs.put(connection, jobs);
            }
            jobs.put(id, job);
        }
    }

    public IP4Job get(String id, IP4Connection connection) {
        LimitMap<String, IP4Job> jobs;
        IP4Job job = null;
        if (id != null && connection != null && (jobs = this.allJobs.get(connection)) != null) {
            job = (IP4Job)jobs.get(id);
        }
        return job;
    }

    public void clear() {
        this.allJobs.clear();
    }

    private static class LimitMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 6187696521678349632L;

        private LimitMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 256;
        }
    }
}

