/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceContentProvider;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

class PendingViewContentProvider
extends PerforceContentProvider
implements ILazyTreeContentProvider {
    public PendingViewContentProvider(StructuredViewer viewer) {
        super(viewer, true);
    }

    @Override
    protected IP4Resource[] getMembers(IP4Container container) {
        IP4Resource[] members = container instanceof IP4PendingChangelist ? ((IP4PendingChangelist)container).getAllMembers() : super.getMembers(container);
        return members;
    }

    @Override
    public void updateChildCount(Object element, int currentChildCount) {
        if (this.viewer instanceof TreeViewer) {
            Tracing.printTrace((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":updateChildCount"), (String)MessageFormat.format("Element={0}", element));
            if (element instanceof IP4Changelist) {
                if (!((IP4Changelist)element).needsRefresh()) {
                    IP4Resource[] members = this.getMembers((IP4Container)((IP4Changelist)element));
                    Tracing.printTrace((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":updateChildCount"), (String)MessageFormat.format("Element=IP4Container[{0}], NoRefresh, children={1}", element, members.length));
                    if (currentChildCount != members.length) {
                        ((TreeViewer)this.viewer).setChildCount(element, members.length);
                    }
                } else {
                    Tracing.printTrace((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":updateChildCount"), (String)MessageFormat.format("Element=IP4Container[{0}], Refresh, children={1}", element, 1));
                    ((TreeViewer)this.viewer).setChildCount(element, 1);
                }
            } else if (element instanceof PerforceContentProvider.Loading) {
                Tracing.printTrace((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":updateChildCount"), (String)"Element=Loading");
                ((TreeViewer)this.viewer).setChildCount(element, 0);
            } else if (element == this.roots) {
                Tracing.printTrace((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":updateChildCount"), (String)MessageFormat.format("Element=roots{0}, NoRefresh", this.roots.length > 1000 ? Arrays.toString(new int[]{this.roots.length}) : Arrays.toString(this.roots)));
                if (currentChildCount != this.roots.length) {
                    ((TreeViewer)this.viewer).setChildCount(element, this.roots.length);
                }
            } else {
                ((TreeViewer)this.viewer).setChildCount(element, 0);
            }
        }
    }

    @Override
    protected void updateContainerNode(TreeViewer viewer, IP4Container container, int index) {
        IP4Resource[] members = this.getMembers(container);
        viewer.setChildCount((Object)container, members.length);
        viewer.refresh((Object)container);
    }
}

