/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.views.DragData;
import com.perforce.team.ui.views.JobViewControl;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class JobsDropAdapter
extends ViewerDropAdapter {
    private JobViewControl view;
    private TransferData currentTransfer;

    public JobsDropAdapter(JobViewControl view) {
        super((Viewer)view.getTableViewer());
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doResourceDrop((IResource[])data);
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doFileDrop((String[])data);
        }
        if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            ArrayList<IResource> resources = new ArrayList<IResource>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IResource) {
                    resources.add((IResource)object);
                } else if (object instanceof IAdaptable && (object = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
                    resources.add((IResource)object);
                }
                ++n2;
            }
            return this.doResourceDrop(resources.toArray(new IResource[0]));
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        return LocalSelectionTransfer.getTransfer().isSupportedType(this.currentTransfer);
    }

    public boolean doFileDrop(String[] files) {
        String path;
        IP4Resource[] depots;
        if (files == null || files.length != 1 || DragData.getConnection() == null) {
            return false;
        }
        IP4Connection con = DragData.getConnection();
        DragData.clear();
        IP4Resource resource = con.getResource(files[0]);
        if (resource == null && (depots = con.members()) != null) {
            IP4Resource[] iP4ResourceArray = depots;
            int n = depots.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource depot = iP4ResourceArray[n2];
                if (files[0].equals(depot.getRemotePath())) {
                    resource = depot;
                    break;
                }
                ++n2;
            }
        }
        if (resource != null && (path = resource.getActionPath()) != null) {
            this.view.changeConnection(con);
            this.view.setPath(path);
            return true;
        }
        return false;
    }

    private boolean doResourceDrop(IResource[] resources) {
        if (resources == null || resources.length != 1) {
            return false;
        }
        IP4Connection con = DragData.getConnection();
        this.view.changeConnection(con);
        IPath path = resources[0].getLocation();
        boolean dropped = false;
        if (path != null) {
            String actionPath = path.makeAbsolute().toOSString();
            if (resources[0] instanceof IContainer) {
                actionPath = String.valueOf(actionPath) + IP4Container.DIR_ELLIPSIS;
            }
            this.view.setPath(actionPath);
            dropped = true;
        }
        return dropped;
    }
}

