/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.history.P4HistoryPage;
import com.perforce.team.ui.p4java.actions.ShowHistoryAction;
import com.perforce.team.ui.views.DragData;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.part.ResourceTransfer;

public class HistoryDropAdapter
extends ViewerDropAdapter {
    private TransferData currentTransfer;
    private P4HistoryPage view;

    public HistoryDropAdapter(P4HistoryPage view) {
        super(view.getViewer());
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doResourceDrop((IResource[])data);
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doFileDrop((String[])data);
        }
        if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            ArrayList<IResource> resources = new ArrayList<IResource>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IResource resource = (IResource)P4CoreUtils.convert((Object)object, IResource.class);
                if (resource != null) {
                    resources.add(resource);
                } else if (object instanceof IFileRevision && selection.size() == 1) {
                    return this.doHistoryDrop((IFileRevision)object);
                }
                ++n2;
            }
            return this.doResourceDrop(resources.toArray(new IResource[resources.size()]));
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        return LocalSelectionTransfer.getTransfer().isSupportedType(this.currentTransfer);
    }

    public boolean doFileDrop(String[] files) {
        if (files == null || files.length != 1 || DragData.getConnection() == null) {
            return false;
        }
        IP4Connection con = DragData.getConnection();
        DragData.clear();
        IP4Resource resource = con.getResource(files[0]);
        if (resource != null && resource instanceof IP4File) {
            this.showHistory(resource);
            return true;
        }
        return false;
    }

    private void showHistory(final Object resource) {
        if (resource == null) {
            return;
        }
        PerforceUIPlugin.asyncExec(new Runnable(){

            @Override
            public void run() {
                ShowHistoryAction show = new ShowHistoryAction();
                show.selectionChanged(null, (ISelection)new StructuredSelection(resource));
                show.run(null);
            }
        });
    }

    private boolean doHistoryDrop(IFileRevision revision) {
        Object firstRevision;
        if (revision != null && (firstRevision = this.getCurrentTarget()) instanceof IFileRevision) {
            this.view.compare((IFileRevision)firstRevision, revision);
            return true;
        }
        return false;
    }

    private boolean doResourceDrop(IResource[] resources) {
        if (resources == null || resources.length != 1) {
            return false;
        }
        this.showHistory(resources[0]);
        return true;
    }
}

